/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.i18n.Messages;
import org.gvsig.installer.lib.api.Dependencies;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.Version;
import org.gvsig.installer.swing.api.JProgressPanel;
import org.gvsig.installer.swing.api.SwingInstallerManager;
import org.gvsig.installer.swing.api.creation.JOutputPanel;
import org.gvsig.installer.swing.api.creation.JPackageInfoPanel;
import org.gvsig.installer.swing.api.creation.MakePluginPackageWizard;
import org.gvsig.installer.swing.api.creation.MakePluginPackageWizardException;
import org.gvsig.installer.swing.api.execution.InstallPackageWizardException;
import org.gvsig.installer.swing.api.execution.InstallWizardPanel;
import org.gvsig.installer.swing.api.execution.JShowPackageStatusAndAskContinuePanel;
import org.gvsig.installer.swing.api.execution.JShowPackagesAndAskContinuePanel;
import org.gvsig.installer.swing.api.execution.JShowRequiredPackagesAndAskContinuePanel;
import org.gvsig.installer.swing.api.execution.JShowUnresolvedDependenciesAndAskContinuePanel;
import org.gvsig.installer.swing.api.execution.PackageFilter;
import org.gvsig.installer.swing.api.packagebuilder.PackageBuildder;
import org.gvsig.installer.swing.api.wizard.InstallerWizardPanel;
import org.gvsig.installer.swing.impl.DefaultJShowPackageStatusAndAskContinuePanel;
import org.gvsig.installer.swing.impl.DefaultJShowRequiredPackagesAndAskContinuePanel;
import org.gvsig.installer.swing.impl.DefaultJShowTroubledPackagesAndAskContinuePanel;
import org.gvsig.installer.swing.impl.DefaultJShowUnresolvedDependenciesAndAskContinuePanel;
import org.gvsig.installer.swing.impl.creation.panel.DefaultOutputPanel;
import org.gvsig.installer.swing.impl.creation.panel.DefaultPackageInfoPanel;
import org.gvsig.installer.swing.impl.execution.panel.filters.TypeFilter;
import org.gvsig.installer.swing.impl.packagebuilder.BasePackageWizard;
import org.gvsig.installer.swing.impl.panel.DefaultProgressPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSwingInstallerManager
implements SwingInstallerManager {
    private static Logger logger = LoggerFactory.getLogger(DefaultSwingInstallerManager.class);
    private static final String SWING_INSTALLER_MANAGER_EXTENSION_POINT = "SwingInstallerManagerExtensionPoint";
    private static final String CREATE_INSTALLER_WIZARD_NAME = "CreateInstallerWizard";
    private static final String EXECUTE_INSTALLER_WIZARD_NAME = "ExecuteInstallerWizard";
    private ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
    private String applicationVersion = "1.0.0";
    private List<SwingInstallerManager.UrlAndLabel> defaultDownloadURLs = new ArrayList<SwingInstallerManager.UrlAndLabel>();

    public String getText(String key) {
        return Messages.translate((String)key);
    }

    public void registerMakePluginPackageWizardInstallerCreationWizard(Class<? extends MakePluginPackageWizard> clazz) {
        ExtensionPoint extensionPoint = this.extensionPoints.add(SWING_INSTALLER_MANAGER_EXTENSION_POINT, "");
        extensionPoint.append(CREATE_INSTALLER_WIZARD_NAME, "", clazz);
    }

    public void registerInstallPackageWizard(Class<? extends InstallerWizardPanel> clazz) {
        ExtensionPoint extensionPoint = this.extensionPoints.add(SWING_INSTALLER_MANAGER_EXTENSION_POINT, "");
        extensionPoint.append(EXECUTE_INSTALLER_WIZARD_NAME, "", clazz);
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String gvSIGVersion) {
        this.applicationVersion = gvSIGVersion;
    }

    public URL getDefaultDownloadURL() {
        if (this.defaultDownloadURLs.size() < 1) {
            return null;
        }
        return this.defaultDownloadURLs.get(0).getURL();
    }

    public List<URL> getDefaultDownloadURLs() {
        return new DefaultDownloadURLs<URL>(this.defaultDownloadURLs);
    }

    public List<SwingInstallerManager.UrlAndLabel> getDefaultDownloadUrlAndLabels() {
        return this.defaultDownloadURLs;
    }

    public void setDefaultDownloadURL(String defaultDownloadURLs) {
        String[] urls = defaultDownloadURLs.split(";");
        for (int i = 0; i < urls.length; ++i) {
            try {
                this.addDefaultDownloadURL(urls[i]);
                continue;
            }
            catch (MalformedURLException e) {
                logger.info("Malformed URL (" + urls[i] + ").", (Throwable)e);
            }
        }
    }

    public void setDefaultDownloadURL(URL defaultDownloadURL) {
        this.defaultDownloadURLs.clear();
        this.addDefaultDownloadURL(defaultDownloadURL);
    }

    public void setDefaultDownloadURL(File defaultDownloadURLs) {
        FileInputStream is;
        if (defaultDownloadURLs == null || !defaultDownloadURLs.exists()) {
            return;
        }
        try {
            is = new FileInputStream(defaultDownloadURLs);
        }
        catch (FileNotFoundException e1) {
            logger.warn("Can't open the file " + defaultDownloadURLs.getName(), (Throwable)e1);
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        String line = null;
        try {
            line = in.readLine();
            while (line != null) {
                try {
                    this.addDefaultDownloadURL(line);
                }
                catch (MalformedURLException e) {
                    logger.warn("Error creating the default packages download URL pointing to " + line, (Throwable)e);
                }
                line = in.readLine();
            }
        }
        catch (IOException e) {
            logger.warn("Error reading the file " + defaultDownloadURLs.getName(), (Throwable)e);
        }
    }

    public void addDefaultDownloadURL(URL url) {
        this.addDefaultDownloadURL(url, null);
    }

    public void addDefaultDownloadURL(URL url, String label) {
        for (DefaultUrlAndLabel defaultUrlAndLabel : this.defaultDownloadURLs) {
            if (!defaultUrlAndLabel.getURL().toString().equals(url.toString())) continue;
            if (defaultUrlAndLabel.getLabel() == null) {
                defaultUrlAndLabel.setLabel(label);
            }
            return;
        }
        this.defaultDownloadURLs.add(new DefaultUrlAndLabel(url, label));
    }

    public void addDefaultDownloadURL(String theURL) throws MalformedURLException {
        String label;
        if (StringUtils.isEmpty((CharSequence)theURL)) {
            return;
        }
        String url = StringUtils.trim((String)theURL);
        if (url.startsWith("#")) {
            return;
        }
        Version version = this.getInstallerManager().createVersion();
        String versionFormat = version.getMajor() + "." + version.getMinor() + "." + version.getRevision();
        String[] parts = StringUtils.split((String)url, (String)"##");
        switch (parts.length) {
            case 1: {
                label = url = parts[0];
                break;
            }
            case 2: {
                url = parts[0];
                label = parts[1];
                break;
            }
            default: {
                logger.warn("Can't parse url/url+label (" + theURL + ").");
                return;
            }
        }
        if (StringUtils.isEmpty((CharSequence)url)) {
            logger.warn("Can't parse url/url+label (" + theURL + ").");
            return;
        }
        url = url.replace("$version", versionFormat);
        url = url.replace("<%Version%>", versionFormat);
        url = url.replace("$build", Integer.toString(version.getBuild()));
        url = url.replace("<%Build%>", Integer.toString(version.getBuild()));
        if (StringUtils.isEmpty((CharSequence)label)) {
            label = url;
        } else {
            label = label.replace("$version", versionFormat);
            label = label.replace("<%Version%>", versionFormat);
            label = label.replace("$build", Integer.toString(version.getBuild()));
            label = label.replace("<%Build%>", Integer.toString(version.getBuild()));
        }
        this.addDefaultDownloadURL(new URL(url), label);
    }

    public InstallerManager getInstallerManager() {
        return InstallerLocator.getInstallerManager();
    }

    public JShowPackageStatusAndAskContinuePanel createJShowPackageStatusAndAskContinuePanel(List<PackageInfo> packages, String message) {
        return new DefaultJShowPackageStatusAndAskContinuePanel(this, packages, message);
    }

    public JShowPackagesAndAskContinuePanel createJShowTroubledPackagesAndAskContinuePanel(List<PackageInfo> packages, String message) {
        return new DefaultJShowTroubledPackagesAndAskContinuePanel(this, packages, message);
    }

    public JShowRequiredPackagesAndAskContinuePanel createJShowRequiredPackagesAndAskContinuePanel(List<PackageInfo> packages, String message) {
        return new DefaultJShowRequiredPackagesAndAskContinuePanel(this, packages, message);
    }

    public JShowUnresolvedDependenciesAndAskContinuePanel createJShowUnresolvedDependenciesAndAskContinuePanel(Dependencies dependencies, String message) {
        return new DefaultJShowUnresolvedDependenciesAndAskContinuePanel(this, dependencies, message);
    }

    public JPackageInfoPanel createPackageInfoPanel() {
        return new DefaultPackageInfoPanel();
    }

    public JPackageInfoPanel createPackageInfoPanel(String packageType) {
        return new DefaultPackageInfoPanel(packageType);
    }

    public JOutputPanel createOutputPanel() {
        return new DefaultOutputPanel();
    }

    public JProgressPanel createProgressPanel() {
        return new DefaultProgressPanel();
    }

    public InstallWizardPanel createInstallPackageWizard(File applicationDirectory, File installFolder) throws InstallPackageWizardException {
        ExtensionPoint ep = this.extensionPoints.add(SWING_INSTALLER_MANAGER_EXTENSION_POINT);
        try {
            Object[] args = new Object[]{applicationDirectory, installFolder};
            return (InstallWizardPanel)ep.create(EXECUTE_INSTALLER_WIZARD_NAME, args);
        }
        catch (Exception e) {
            throw new InstallPackageWizardException("Error creating the wizard", (Throwable)e);
        }
    }

    public MakePluginPackageWizard createMakePluginPackageWizard(File applicationDirectory, File installFolder) throws MakePluginPackageWizardException {
        ExtensionPoint ep = this.extensionPoints.add(SWING_INSTALLER_MANAGER_EXTENSION_POINT);
        try {
            Object[] args = new Object[]{applicationDirectory, installFolder};
            return (MakePluginPackageWizard)ep.create(CREATE_INSTALLER_WIZARD_NAME, args);
        }
        catch (Exception e) {
            throw new MakePluginPackageWizardException("Error creating the wizard", (Throwable)e);
        }
    }

    public PackageBuildder createPackagerPanel(String packageType, File selectionFolder, File outputFolder) {
        BasePackageWizard packager = new BasePackageWizard(packageType, selectionFolder, outputFolder);
        return packager;
    }

    public PackageFilter createPackageTypeFilter(String type) {
        return new TypeFilter(type);
    }

    public class DefaultDownloadURLs<URL>
    implements List<URL> {
        private List<SwingInstallerManager.UrlAndLabel> urlAndLabels;

        DefaultDownloadURLs(List<SwingInstallerManager.UrlAndLabel> urlAndLabels) {
            this.urlAndLabels = urlAndLabels;
        }

        @Override
        public boolean add(Object url) {
            throw new UnsupportedOperationException("This is a read-only list");
        }

        @Override
        public void add(int arg0, Object url) {
            throw new UnsupportedOperationException("This is a read-only list");
        }

        @Override
        public boolean addAll(Collection arg0) {
            throw new UnsupportedOperationException("This is a read-only list");
        }

        @Override
        public boolean addAll(int arg0, Collection arg1) {
            throw new UnsupportedOperationException("This is a read-only list");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("This is a read-only list");
        }

        @Override
        public boolean contains(Object arg0) {
            for (SwingInstallerManager.UrlAndLabel x : this.urlAndLabels) {
                if (!x.getURL().equals(arg0)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection arg0) {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public URL get(int arg0) {
            return (URL)this.urlAndLabels.get(arg0).getURL();
        }

        @Override
        public int indexOf(Object arg0) {
            for (int i = 0; i < this.urlAndLabels.size(); ++i) {
                if (!this.urlAndLabels.get(i).getURL().equals(arg0)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.urlAndLabels.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new DefaultDownloadURLsIterator(this.urlAndLabels);
        }

        @Override
        public int lastIndexOf(Object arg0) {
            for (int i = this.urlAndLabels.size() - 1; i >= 0; --i) {
                if (!this.urlAndLabels.get(i).getURL().equals(arg0)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public ListIterator listIterator() {
            return new DefaultDownloadURLsIterator(this.urlAndLabels);
        }

        @Override
        public ListIterator listIterator(int arg0) {
            return new DefaultDownloadURLsIterator(this.urlAndLabels, arg0);
        }

        @Override
        public boolean remove(Object arg0) {
            throw new UnsupportedOperationException("This is a read-only list");
        }

        @Override
        public URL remove(int arg0) {
            throw new UnsupportedOperationException("This is a read-only list");
        }

        @Override
        public boolean removeAll(Collection arg0) {
            throw new UnsupportedOperationException("This is a read-only list");
        }

        @Override
        public boolean retainAll(Collection arg0) {
            throw new UnsupportedOperationException("This is a read-only list");
        }

        @Override
        public Object set(int arg0, Object arg1) {
            throw new UnsupportedOperationException("This is a read-only list");
        }

        @Override
        public int size() {
            return this.urlAndLabels.size();
        }

        @Override
        public List subList(int arg0, int arg1) {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException("This method is not supported");
        }

        @Override
        public Object[] toArray(Object[] arg0) {
            throw new UnsupportedOperationException("This method is not supported");
        }
    }

    public class DefaultDownloadURLsIterator<URL>
    implements ListIterator<URL> {
        private List<SwingInstallerManager.UrlAndLabel> urlAndLabels;
        private ListIterator<SwingInstallerManager.UrlAndLabel> it;

        DefaultDownloadURLsIterator(List<SwingInstallerManager.UrlAndLabel> urlAndLabels, int index) {
            this.urlAndLabels = urlAndLabels;
            this.it = this.urlAndLabels.listIterator(index);
        }

        DefaultDownloadURLsIterator(List<SwingInstallerManager.UrlAndLabel> urlAndLabels) {
            this.urlAndLabels = urlAndLabels;
            this.it = this.urlAndLabels.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public URL next() {
            SwingInstallerManager.UrlAndLabel value = this.it.next();
            if (value == null) {
                return null;
            }
            return (URL)value.getURL();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public URL previous() {
            SwingInstallerManager.UrlAndLabel value = this.it.previous();
            if (value == null) {
                return null;
            }
            return (URL)value.getURL();
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This is read-only");
        }

        @Override
        public void add(Object arg0) {
            throw new UnsupportedOperationException("This is read-only");
        }

        @Override
        public void set(Object arg0) {
            throw new UnsupportedOperationException("This is read-only");
        }
    }

    public class DefaultUrlAndLabel
    implements SwingInstallerManager.UrlAndLabel {
        private URL url;
        private String label;

        public DefaultUrlAndLabel(URL url, String label) {
            this.url = url;
            this.label = label;
        }

        public URL getURL() {
            return this.url;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String toString() {
            if (this.label == null) {
                return this.url.toString();
            }
            return this.label + " - " + this.url.toString();
        }
    }
}

