/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.creation.panel;

import java.awt.BorderLayout;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.Version;
import org.gvsig.installer.lib.spi.InstallerProviderLocator;
import org.gvsig.installer.lib.spi.InstallerProviderManager;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.creation.JPackageInfoPanel;
import org.gvsig.installer.swing.impl.DefaultSwingInstallerManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.DynFormManager;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.service.spi.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPackageInfoPanel
extends JPackageInfoPanel {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPackageInfoPanel.class);
    private static final long serialVersionUID = 3220127550495628087L;
    protected DefaultSwingInstallerManager swingInstallerManager = null;
    private JDynForm form = null;
    private DynObject data = null;
    private final String packageType;

    public DefaultPackageInfoPanel() {
        this(null);
    }

    public DefaultPackageInfoPanel(String packageType) {
        this.packageType = packageType;
        this.swingInstallerManager = (DefaultSwingInstallerManager)SwingInstallerLocator.getSwingInstallerManager();
        this.initComponents();
    }

    private void initComponents() {
        DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
        InputStream resource = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/gvsig/installer/swing/impl/creation/panel/formPackageinfo.xml");
        try {
            Map definitions = dynObjectManager.importDynClassDefinitions(resource, ((Object)((Object)this)).getClass().getClassLoader());
            DynStruct definition = (DynStruct)definitions.get("FormPackageinfo");
            DynField dynField = definition.getDynField("type");
            this.setAvailableValuesOfFieldType(dynField);
            if (this.packageType != null) {
                dynField.setReadOnly(true);
            }
            this.data = dynObjectManager.createDynObject(definition);
            if (this.packageType != null) {
                this.data.setDynValue("type", (Object)this.packageType);
            }
            DynFormManager dynFormManager = DynFormLocator.getDynFormManager();
            this.form = dynFormManager.createJDynForm(this.data);
        }
        catch (Exception e) {
            logger.warn("No se puede crear el formulario.", (Throwable)e);
            throw new RuntimeException("No se puede crear el formulario.", e);
        }
        this.setLayout(new BorderLayout(4, 4));
        this.add(this.form.asJComponent(), "Center");
    }

    protected String findCurrentGvSIGVersion() {
        return SwingInstallerLocator.getSwingInstallerManager().getApplicationVersion();
    }

    public String getName() {
        return (String)this.form.getValue("name");
    }

    public void setName(String name) {
        this.form.setValue("name", (Object)name);
    }

    public boolean validatePanel() {
        return this.form.hasValidValues();
    }

    public void panelToPackageInfo(PackageInfo packageInfo) {
        this.form.getValues(this.data);
        packageInfo.setType((String)this.data.getDynValue("type"));
        packageInfo.setCode((String)this.data.getDynValue("code"));
        packageInfo.setName((String)this.data.getDynValue("name"));
        packageInfo.setDescription((String)this.data.getDynValue("description"));
        packageInfo.setVersion((Version)this.data.getDynValue("version"));
        packageInfo.setBuild(((Integer)this.data.getDynValue("buildNumber")).intValue());
        packageInfo.setState((String)this.data.getDynValue("state"));
        packageInfo.setOfficial(((Boolean)this.data.getDynValue("official")).booleanValue());
        packageInfo.setOperatingSystem((String)this.data.getDynValue("operating-system"));
        packageInfo.setArchitecture((String)this.data.getDynValue("architecture"));
        packageInfo.setJavaVM((String)this.data.getDynValue("java-version"));
        packageInfo.setGvSIGVersion((String)this.data.getDynValue("gvSIG-version"));
        packageInfo.setSourcesURL((URL)this.data.getDynValue("sources-url"));
        packageInfo.setOwnerURL((URL)this.data.getDynValue("owner-url"));
        packageInfo.setOwner((String)this.data.getDynValue("owner"));
        packageInfo.setDependencies((String)this.data.getDynValue("dependencies"));
        packageInfo.getCategories().clear();
        packageInfo.addCategoriesAsString((String)this.data.getDynValue("categories"));
    }

    private boolean isEmptyString(String s) {
        if (s == null) {
            return true;
        }
        return s.length() == 0;
    }

    public void packageInfoToPanel(PackageInfo packageInfo) {
        if (this.packageType != null) {
            this.data.setDynValue("type", (Object)this.packageType);
        } else {
            this.data.setDynValue("type", (Object)packageInfo.getType());
        }
        this.data.setDynValue("code", (Object)packageInfo.getCode());
        this.data.setDynValue("name", (Object)packageInfo.getName());
        this.data.setDynValue("version", (Object)packageInfo.getVersion());
        this.data.setDynValue("gvSIG-version", (Object)this.findCurrentGvSIGVersion());
        this.data.setDynValue("buildNumber", (Object)packageInfo.getBuild());
        this.data.setDynValue("official", (Object)packageInfo.isOfficial());
        this.data.setDynValue("state", (Object)packageInfo.getState());
        this.data.setDynValue("description", (Object)packageInfo.getDescription());
        this.data.setDynValue("operating-system", (Object)packageInfo.getOperatingSystem());
        this.data.setDynValue("architecture", (Object)packageInfo.getArchitecture());
        this.data.setDynValue("java-version", (Object)packageInfo.getJavaVM());
        this.data.setDynValue("sources-url", (Object)packageInfo.getSourcesURL());
        this.data.setDynValue("owner", (Object)packageInfo.getOwner());
        this.data.setDynValue("owner-url", (Object)packageInfo.getOwnerURL());
        this.data.setDynValue("dependencies", (Object)packageInfo.getDependencies());
        this.data.setDynValue("categories", (Object)packageInfo.getCategoriesAsString());
        this.form.getField("code-alias").setReadOnly(true);
        this.form.setValues(this.data);
    }

    private void setAvailableValuesOfFieldType(DynField dynField) {
        InstallerProviderManager providerManager = InstallerProviderLocator.getProviderManager();
        List factories = providerManager.getProviderFactories();
        DynObjectValueItem[] values = new DynObjectValueItem[factories.size()];
        int i = 0;
        for (ProviderFactory factory : factories) {
            String name = factory.getName();
            values[i++] = new DynObjectValueItem((Object)name, name);
        }
        dynField.setAvailableValues(values);
    }
}

