/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller.nullablespinner;

import java.io.Serializable;
import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import javax.swing.SpinnerDateModel;

public class NullableSpinnerTimeModel
extends SpinnerDateModel
implements Serializable {
    private Comparable start;
    private Comparable end;
    private Calendar value;
    private int calendarField;

    private boolean calendarFieldOK(int calendarField) {
        switch (calendarField) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public NullableSpinnerTimeModel(Date value, Comparable start, Comparable end, int calendarField) {
        if (!this.calendarFieldOK(calendarField)) {
            throw new IllegalArgumentException("invalid calendarField");
        }
        if (start != null && start.compareTo(value) > 0 || end != null && end.compareTo(value) < 0) {
            throw new IllegalArgumentException("(start <= value <= end) is false");
        }
        this.start = start;
        this.end = end;
        this.calendarField = calendarField;
        if (value == null) {
            this.value = null;
        } else {
            this.value = Calendar.getInstance();
            this.value.setTime(value);
        }
    }

    public NullableSpinnerTimeModel() {
        this((Date)null, (Comparable)null, (Comparable)null, 5);
    }

    public void setStart(Comparable start) {
        if (start == null ? this.start != null : !start.equals(this.start)) {
            this.start = start;
            this.fireStateChanged();
        }
    }

    public Comparable getStart() {
        return this.start;
    }

    public void setEnd(Comparable end) {
        if (end == null ? this.end != null : !end.equals(this.end)) {
            this.end = end;
            this.fireStateChanged();
        }
    }

    public Comparable getEnd() {
        return this.end;
    }

    @Override
    public void setCalendarField(int calendarField) {
        if (!this.calendarFieldOK(calendarField)) {
            throw new IllegalArgumentException("invalid calendarField");
        }
        if (calendarField != this.calendarField) {
            this.calendarField = calendarField;
            this.fireStateChanged();
        }
    }

    @Override
    public int getCalendarField() {
        return this.calendarField;
    }

    @Override
    public Object getNextValue() {
        if (this.value == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.value.getTime());
        cal.add(this.calendarField, 1);
        Date next = cal.getTime();
        return this.end == null || this.end.compareTo(next) >= 0 ? next : null;
    }

    @Override
    public Object getPreviousValue() {
        if (this.value == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.value.getTime());
        cal.add(this.calendarField, -1);
        Date prev = cal.getTime();
        return this.start == null || this.start.compareTo(prev) <= 0 ? prev : null;
    }

    @Override
    public Date getDate() {
        if (this.value == null) {
            return null;
        }
        return this.value.getTime();
    }

    public Time getTime() {
        if (this.value == null) {
            return null;
        }
        Time time = new Time(this.value.getTime().getTime());
        return time;
    }

    @Override
    public Object getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.getTime();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            if (this.value != null) {
                this.value = null;
                this.fireStateChanged();
            }
            return;
        }
        if (!(value instanceof Date)) {
            throw new IllegalArgumentException("illegal value");
        }
        if (this.value == null || !value.equals(this.value.getTime())) {
            this.value = Calendar.getInstance();
            this.value.setTime((Date)value);
            this.fireStateChanged();
        }
    }
}

