/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.usability.spinner.editor;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.gvsig.tools.dynobject.DynField;

public class DynFieldFormatter {
    private Locale loc;
    private int calendarField = 5;
    private SimpleDateFormat df;
    private DynField dynField;
    private boolean isDate = false;
    private boolean isNumber = false;
    private DecimalFormat f;

    public static DynFieldFormatter getInstance(DynField field, Locale loc) {
        return new DynFieldFormatter(field, loc);
    }

    private DynFieldFormatter(DynField field, Locale loc) {
        this.loc = loc;
        this.dynField = field;
        this.refresh();
    }

    public String format(Object value) {
        System.out.println(value);
        this.refresh();
        if (value == null || value.equals("")) {
            return "";
        }
        if (this.isDate()) {
            if (value instanceof Date) {
                return this.df.format(value);
            }
            return "0";
        }
        if (this.isNumber() && value instanceof Number) {
            return this.f.format(value);
        }
        return "";
    }

    public Date formatDate(Date date) {
        return this.getCalendar(date).getTime();
    }

    public String formatDateFull(Date date) {
        DateFormat df = DateFormat.getDateInstance(0, this.getLocale());
        return df.format(date);
    }

    public String formatDateLong(Date date) {
        DateFormat df = DateFormat.getDateInstance(1, this.getLocale());
        return df.format(date);
    }

    public String formatDateMedium(Date date) {
        DateFormat df = DateFormat.getDateInstance(2, this.getLocale());
        return df.format(date);
    }

    public String formatDateShort(Date date) {
        DateFormat df = DateFormat.getDateInstance(3, this.getLocale());
        return df.format(date);
    }

    private Number formatNumber(Number value) {
        try {
            return this.f.parse(this.f.format(value));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Calendar getCalendar() {
        return this.getDateFormatter().getCalendar();
    }

    public Calendar getCalendar(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.getCalendar().setTime(date);
        return this.getCalendar();
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    public DateFormatter getDateFormatter() {
        if (this.df == null) {
            this.df = (SimpleDateFormat)DateFormat.getDateInstance(2, this.getLocale());
        }
        return new DateFormatter(this);
    }

    public Locale getLocale() {
        if (this.loc == null) {
            this.loc = Locale.getDefault();
        }
        return this.loc;
    }

    public Object getNextValue(Object value) {
        if (this.isDate()) {
            if (value == null) {
                value = new Date();
            }
            Calendar cal = this.getCalendar();
            cal.setTime((Date)value);
            cal.add(this.getCalendarField(), 1);
            return cal.getTime();
        }
        if (this.isNumber()) {
            if (value != null) {
                String strValue = value.toString();
                switch (this.getType()) {
                    case 7: {
                        return this.formatNumber(Double.valueOf(strValue) + 1.0);
                    }
                    case 6: {
                        return this.formatNumber(Float.valueOf(Float.valueOf(strValue).floatValue() + 1.0f));
                    }
                    case 5: {
                        return this.formatNumber(Long.valueOf(strValue) + 1L);
                    }
                    case 4: {
                        return this.formatNumber(Integer.valueOf(strValue) + 1);
                    }
                    case 2: {
                        return this.formatNumber(Byte.valueOf(strValue) + 1);
                    }
                }
            }
            return 0;
        }
        return null;
    }

    public NumberFormat getNumberFormatter() {
        if (this.f == null) {
            if (this.df == null) {
                this.f = (DecimalFormat)NumberFormat.getNumberInstance(this.getLocale());
            } else {
                return this.df.getNumberFormat();
            }
        }
        return this.f;
    }

    public Object getPreviousValue(Object value) {
        if (this.isDate()) {
            if (value != null) {
                Calendar cal = this.getCalendar();
                cal.setTime((Date)value);
                cal.add(this.getCalendarField(), -1);
                return cal.getTime();
            }
            return null;
        }
        if (this.isNumber()) {
            if (value != null) {
                String strValue = value.toString();
                switch (this.getType()) {
                    case 7: {
                        return this.formatNumber(Double.valueOf(strValue) - 1.0);
                    }
                    case 6: {
                        return this.formatNumber(Float.valueOf(Float.valueOf(strValue).floatValue() - 1.0f));
                    }
                    case 5: {
                        return this.formatNumber(Long.valueOf(strValue) - 1L);
                    }
                    case 4: {
                        return this.formatNumber(Integer.valueOf(strValue) - 1);
                    }
                    case 2: {
                        return this.formatNumber(Byte.valueOf(strValue) - 1);
                    }
                }
            }
            return null;
        }
        return null;
    }

    private String getSubType() {
        String str = this.dynField.getSubtype();
        if (str == null) {
            return "";
        }
        return str;
    }

    private int getType() {
        return this.dynField.getType();
    }

    public boolean isDate() {
        return this.isDate;
    }

    public boolean isNumber() {
        return this.isNumber;
    }

    public boolean isValidType(Object value) {
        if (value == null) {
            return true;
        }
        if (this.isDate() && !(value instanceof Date)) {
            return false;
        }
        if (this.isNumber() && !(value instanceof Number)) {
            if (value instanceof String) {
                try {
                    Number number = NumberFormat.getInstance().parse((String)value);
                }
                catch (ParseException e) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public Object parse(String value) throws ParseException {
        if (value == null || value.equals("")) {
            return null;
        }
        if (this.isDate()) {
            if (this.getType() == 11) {
                return Timestamp.valueOf(value);
            }
            return this.df.parse(value);
        }
        if (this.isNumber()) {
            return this.f.parse(value);
        }
        return null;
    }

    public Date parseDate(String date) throws ParseException {
        return this.getDateFormatter().parse(date);
    }

    private void refresh() {
        switch (this.getType()) {
            case 10: {
                this.isDate = true;
                this.calendarField = 12;
                this.df = (SimpleDateFormat)DateFormat.getTimeInstance(2, this.getLocale());
                break;
            }
            case 11: {
                this.isDate = true;
                this.calendarField = 13;
                this.df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                break;
            }
            case 9: {
                this.isDate = true;
                this.calendarField = 5;
                if (!this.getSubType().equals("Date")) {
                    this.df = (SimpleDateFormat)DateFormat.getDateTimeInstance(0, 0, this.getLocale());
                    break;
                }
                this.df = (SimpleDateFormat)DateFormat.getDateInstance(1, this.getLocale());
                break;
            }
            case 7: {
                this.isNumber = true;
                this.f = (DecimalFormat)NumberFormat.getNumberInstance(this.getLocale());
                this.f.setMaximumFractionDigits(2);
                this.f.setMinimumFractionDigits(2);
                break;
            }
            case 6: {
                this.isNumber = true;
                this.f = (DecimalFormat)NumberFormat.getNumberInstance(this.getLocale());
                this.f.setMaximumFractionDigits(2);
                this.f.setMinimumFractionDigits(2);
                break;
            }
            case 5: {
                this.isNumber = true;
                this.f = (DecimalFormat)NumberFormat.getNumberInstance(this.getLocale());
                break;
            }
            case 4: {
                this.isNumber = true;
                this.f = (DecimalFormat)NumberFormat.getIntegerInstance(this.getLocale());
                break;
            }
            case 2: {
                this.isNumber = true;
                this.f = (DecimalFormat)NumberFormat.getIntegerInstance(this.getLocale());
            }
        }
    }

    public void setCalendarField(int calendarField) {
        this.calendarField = calendarField;
    }

    public void setLocale(Locale loc) {
        this.loc = loc;
        this.refresh();
    }

    private SimpleDateFormat toDateFormat() {
        return this.df;
    }

    public Format toFormat() {
        if (this.isDate()) {
            return this.df;
        }
        if (this.isNumber()) {
            return this.f;
        }
        return null;
    }

    public String toLocalizedPattern() {
        if (this.isDate()) {
            return this.df.toLocalizedPattern();
        }
        return this.f.toLocalizedPattern();
    }

    public class DateFormatter
    extends SimpleDateFormat {
        private static final long serialVersionUID = -1744865595768091192L;
        private DynFieldFormatter df;

        public DateFormatter(DynFieldFormatter df) {
            this.df = df;
        }

        public String formatDate(Object obj) throws ParseException {
            return this.df.format(obj);
        }

        @Override
        public Date parse(String value) {
            try {
                return this.parseDate(value);
            }
            catch (ParseException e) {
                return null;
            }
        }

        public Date parseDate(String time) throws ParseException {
            return (Date)this.df.parse(time);
        }
    }
}

