/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.resourcesstorage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.gvsig.tools.resourcesstorage.AbstractResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;

public class URLResource
extends AbstractResourcesStorage.AbstractResource
implements ResourcesStorage.Resource {
    private final URL url;
    private InputStream is;

    public URLResource(String name, URL url) {
        super(name);
        this.url = url;
        this.is = null;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public boolean exists() {
        if (this.is != null) {
            return true;
        }
        try {
            this.is = this.url.openStream();
            this.is.close();
            this.is = null;
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public InputStream asInputStream() throws IOException {
        if (this.is != null) {
            throw new RuntimeException("Stream already open");
        }
        this.is = this.url.openStream();
        return new ResourceInputStream();
    }

    @Override
    public OutputStream asOutputStream() throws IOException {
        return null;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((InputStream)this.is);
        this.is = null;
    }

    private class ResourceInputStream
    extends InputStream {
        private ResourceInputStream() {
        }

        @Override
        public int read() throws IOException {
            return URLResource.this.is.read();
        }

        @Override
        public void close() throws IOException {
            URLResource.this.close();
        }
    }
}

