/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.text;

import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import org.apache.commons.lang3.StringUtils;

public class DMSNumberFormat {
    protected static final String AFTER_DEGREES = " \u00b0\u00bad:";
    protected static final String AFTER_MINUTES = " \u2032':m";
    protected static final String AFTER_SECONDS = " \u2033\"s";
    private String source;
    private int position;
    private int maxposition;
    private int column;
    private final boolean requireLatLongIndicator;
    protected static final char EOF = '\u0000';
    private int degrees;
    private int minutes;
    private double seconds;
    private Integer sign = null;

    public DMSNumberFormat(boolean requireLatLongIndicator) {
        this.source = null;
        this.position = 0;
        this.maxposition = 0;
        this.requireLatLongIndicator = requireLatLongIndicator;
    }

    public DMSNumberFormat(String source, boolean requireLatLongIndicator) {
        this.source = source;
        this.position = 0;
        this.maxposition = 0;
        this.requireLatLongIndicator = requireLatLongIndicator;
    }

    public boolean isEOF() {
        return this.position >= this.source.length();
    }

    protected void skipblanks() {
        if (this.isEOF()) {
            return;
        }
        char ch = this.getch();
        while (ch != '\u0000' && Character.isWhitespace(ch)) {
            ch = this.getch();
        }
        this.ungetch();
    }

    protected char getch() {
        if (this.position >= this.source.length()) {
            return '\u0000';
        }
        ++this.column;
        char ch = this.source.charAt(this.position++);
        if (this.position > this.maxposition) {
            this.maxposition = this.position;
        }
        return ch;
    }

    protected void ungetch() {
        --this.position;
        if (this.position < 0) {
            this.position = 0;
        }
        --this.column;
        if (this.column < 0) {
            this.column = 0;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public double parse(String source) throws ParseException {
        this.source = source;
        this.maxposition = this.position = 0;
        try {
            double value = this.parse();
            return value;
        }
        catch (Exception ex) {
            ParseException ex1 = new ParseException(ex.getMessage(), this.position);
            ex1.initCause(ex);
            throw ex1;
        }
    }

    public double parse(String source, ParsePosition parsePosition) {
        this.source = source;
        if (parsePosition == null) {
            this.position = 0;
            this.maxposition = 0;
        } else {
            this.maxposition = this.position = parsePosition.getIndex();
        }
        try {
            double value = this.parse();
            if (parsePosition != null) {
                parsePosition.setIndex(this.position);
                parsePosition.setErrorIndex(-1);
            }
            return value;
        }
        catch (Exception ex) {
            if (parsePosition != null) {
                parsePosition.setErrorIndex(this.position);
            }
            return 0.0;
        }
    }

    protected double parse() {
        int s_i = 0;
        double s_d = 0.0;
        this.degrees = 0;
        this.minutes = 0;
        this.seconds = 0.0;
        StringBuilder buffer = new StringBuilder();
        this.skipblanks();
        char ch = this.getch();
        if (ch == '\u0000') {
            return 0.0;
        }
        if (ch == '+') {
            this.sign = 1;
            ch = this.getch();
        } else if (ch == '-') {
            this.sign = -1;
            ch = this.getch();
        }
        if (ch == '\u0000') {
            return 0.0;
        }
        buffer.setLength(0);
        if (!Character.isDigit(ch)) {
            throw new DMSNumberParseException(String.format("Expected a number at position %d.", this.getPosition()));
        }
        while (ch != '\u0000' && Character.isDigit(ch)) {
            buffer.append(ch);
            ch = this.getch();
        }
        if (ch != '\u0000' && !StringUtils.contains((CharSequence)AFTER_DEGREES, (int)ch)) {
            throw new DMSNumberParseException(String.format("Expected '%s' and found '%s'.", AFTER_DEGREES, String.valueOf(ch)));
        }
        this.degrees = Integer.parseInt(buffer.toString());
        this.skipblanks();
        ch = this.getch();
        if (ch != '\u0000') {
            buffer.setLength(0);
            if (!Character.isDigit(ch)) {
                throw new DMSNumberParseException(String.format("Expected a number at position %d.", this.getPosition()));
            }
            while (ch != '\u0000' && Character.isDigit(ch)) {
                buffer.append(ch);
                ch = this.getch();
            }
            if (ch != '\u0000' && !StringUtils.contains((CharSequence)AFTER_MINUTES, (int)ch)) {
                throw new DMSNumberParseException(String.format("Expected '%s' and found '%s'.", AFTER_MINUTES, String.valueOf(ch)));
            }
            this.minutes = Integer.parseInt(buffer.toString());
            this.skipblanks();
            ch = this.getch();
            if (ch != '\u0000') {
                buffer.setLength(0);
                if (!Character.isDigit(ch)) {
                    throw new DMSNumberParseException(String.format("Expected a number at position %d.", this.getPosition()));
                }
                while (ch != '\u0000' && Character.isDigit(ch)) {
                    buffer.append(ch);
                    ch = this.getch();
                }
                s_i = Integer.parseInt(buffer.toString());
                if (ch != '\u0000') {
                    if (ch == '.' || ch == DecimalFormatSymbols.getInstance().getDecimalSeparator()) {
                        this.skipblanks();
                        ch = this.getch();
                        buffer.setLength(0);
                        if (!Character.isDigit(ch)) {
                            throw new DMSNumberParseException(String.format("Expected a number at position %d.", this.getPosition()));
                        }
                        while (ch != '\u0000' && Character.isDigit(ch)) {
                            buffer.append(ch);
                            ch = this.getch();
                        }
                        String ss = buffer.toString();
                        s_d = (double)Integer.parseInt(ss) / Math.pow(10.0, ss.length());
                    }
                    if (ch != '\u0000' && !StringUtils.contains((CharSequence)AFTER_SECONDS, (int)ch)) {
                        throw new DMSNumberParseException(String.format("Expected any of '%s' and found '%s'.", AFTER_SECONDS, String.valueOf(ch)));
                    }
                }
                this.seconds = (double)s_i + s_d;
            }
        }
        double dd = (double)this.degrees + (double)this.minutes / 60.0 + this.seconds / 3600.0;
        if (this.sign == null) {
            this.skipblanks();
            ch = this.getch();
            switch (ch) {
                case 'N': 
                case 'n': {
                    if (dd > 90.0) {
                        throw new DMSNumberParseException(String.format("Incorrect value for latitude (%f)", dd));
                    }
                    this.sign = 1;
                    break;
                }
                case 'S': 
                case 's': {
                    if (dd > 90.0) {
                        throw new DMSNumberParseException(String.format("Incorrect value for latitude (%f)", dd));
                    }
                    this.sign = -1;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (dd > 180.0) {
                        throw new DMSNumberParseException(String.format("Incorrect value for longitude (%f)", dd));
                    }
                    this.sign = 1;
                    break;
                }
                case 'O': 
                case 'W': 
                case 'o': 
                case 'w': {
                    if (dd > 180.0) {
                        throw new DMSNumberParseException(String.format("Incorrect value for longitude (%f)", dd));
                    }
                    this.sign = -1;
                    break;
                }
                default: {
                    if (this.requireLatLongIndicator) {
                        throw new DMSNumberParseException(String.format("Expected '%s' and found '%s'.", "N/S/E/W", String.valueOf(ch)));
                    }
                    this.sign = 1;
                }
            }
        }
        return dd *= (double)this.sign.intValue();
    }

    public int getDegrees() {
        return this.degrees;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public int getSign() {
        return this.sign;
    }

    public static class DMSNumberParseException
    extends IllegalArgumentException {
        public DMSNumberParseException() {
        }

        private DMSNumberParseException(String msg) {
            super(msg);
        }
    }
}

