/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.messages;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.MessageEvent;
import org.gvsig.andami.messages.NotificationListener;
import org.gvsig.tools.exception.IBaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationManager {
    private static int SIZE_MESSAGE = 4;
    private static Logger logger = LoggerFactory.getLogger((String)NotificationManager.class.getName());
    private static Timer timer;
    private static boolean addedMessage;
    private static ArrayList info;
    private static ArrayList infoExceptions;
    private static ArrayList warnings;
    private static ArrayList warningsExceptions;
    private static ArrayList errors;
    private static ArrayList errorsExceptions;
    private static Vector listeners;
    private static boolean isFirst;

    public static synchronized void addNotificationListener(NotificationListener nl) {
        logger.info("Se a\u00f1ade un listener al manager de notificaciones (" + nl.getClass().getName() + "/" + nl.toString() + ")");
        listeners.add(nl);
    }

    public static synchronized void addError(String err, Throwable e) {
        logger.error(err, e);
        try {
            NotificationManager.dispatchError(err, e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void dispatchError(String err, Throwable e) {
        errors.add(err);
        errorsExceptions.add(e);
        if (isFirst) {
            NotificationManager.AddError(errors.toArray(new String[0]), errorsExceptions.toArray(new Throwable[0]));
            errors.clear();
            errorsExceptions.clear();
            isFirst = false;
        }
        NotificationManager.dispatchMessages();
    }

    public static synchronized void addWarning(String warn, Throwable e) {
        logger.warn(warn, e);
        NotificationManager.dispatchWarning(warn, e);
    }

    public static synchronized void dispatchWarning(String warn, Throwable e) {
        warnings.add(warn);
        warningsExceptions.add(e);
        if (isFirst) {
            NotificationManager.AddWarning(warnings.toArray(new String[0]), warningsExceptions.toArray(new Throwable[0]));
            warnings.clear();
            warningsExceptions.clear();
            isFirst = false;
        }
        NotificationManager.dispatchMessages();
    }

    public static synchronized void addWarning(String warn) {
        NotificationManager.addWarning(warn, null);
    }

    public static synchronized void addInfo(String inf, Throwable e) {
        logger.info(inf, e);
        info.add(inf);
        infoExceptions.add(e);
        if (isFirst) {
            NotificationManager.AddInfo(info.toArray(new String[0]), infoExceptions.toArray(new Throwable[0]));
            info.clear();
            infoExceptions.clear();
            isFirst = false;
        }
        NotificationManager.dispatchMessages();
    }

    public static synchronized void addInfo(String inf) {
        NotificationManager.addInfo(inf, null);
    }

    private static void AddError(String[] error, Throwable[] e) {
        for (int i = 0; i < listeners.size(); ++i) {
            ((NotificationListener)listeners.get(i)).errorEvent(new MessageEvent(error, e));
        }
    }

    private static void AddWarning(String[] warn, Throwable[] e) {
        for (int i = 0; i < listeners.size(); ++i) {
            ((NotificationListener)listeners.get(i)).warningEvent(new MessageEvent(warn, e));
        }
    }

    private static void AddInfo(String[] info, Throwable[] e) {
        for (int i = 0; i < listeners.size(); ++i) {
            ((NotificationListener)listeners.get(i)).infoEvent(new MessageEvent(info, e));
        }
    }

    private static void dispatchMessages() {
        addedMessage = true;
        if (timer == null) {
            timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (errors.size() > 0) {
                        NotificationManager.AddError(errors.toArray(new String[0]), errorsExceptions.toArray(new Throwable[0]));
                        errors.clear();
                        errorsExceptions.clear();
                    }
                    if (warnings.size() > 0) {
                        NotificationManager.AddWarning(warnings.toArray(new String[0]), warningsExceptions.toArray(new Throwable[0]));
                        warnings.clear();
                        warningsExceptions.clear();
                    }
                    if (info.size() > 0) {
                        NotificationManager.AddInfo(info.toArray(new String[0]), infoExceptions.toArray(new Throwable[0]));
                        info.clear();
                        infoExceptions.clear();
                    }
                    if (!addedMessage) {
                        if (timer != null) {
                            timer.stop();
                        }
                        timer = null;
                    }
                    addedMessage = false;
                    isFirst = true;
                }
            });
            timer.start();
        }
    }

    public static void addError(Throwable e1) {
        if (e1 instanceof IBaseException) {
            String msg;
            IBaseException ex = (IBaseException)e1;
            try {
                msg = ex.getLocalizedMessageStack();
            }
            catch (Exception ex1) {
                try {
                    msg = ex.getMessageStack();
                }
                catch (Exception ex2) {
                    msg = ex.getMessage();
                }
            }
            NotificationManager.addError(msg, e1);
        } else {
            NotificationManager.addError(e1.toString(), e1);
        }
    }

    public static void showMessageError(String message, Exception e) {
        message = NotificationManager.splitMessage(message);
        JOptionPane.showMessageDialog((Component)((Object)PluginServices.getMainFrame()), message, PluginServices.getText(NotificationManager.class, "error"), 0);
        NotificationManager.addWarning(message, e);
    }

    public static void showMessageWarning(String message, Exception e) {
        message = NotificationManager.splitMessage(message);
        JOptionPane.showMessageDialog((Component)((Object)PluginServices.getMainFrame()), message, PluginServices.getText(NotificationManager.class, "warning"), 2);
        NotificationManager.addWarning(message, e);
    }

    public static void showMessageInfo(String message, Exception e) {
        message = NotificationManager.splitMessage(message);
        JOptionPane.showMessageDialog((Component)((Object)PluginServices.getMainFrame()), message, PluginServices.getText(NotificationManager.class, "info"), 1);
        NotificationManager.addInfo(message, e);
    }

    private static String splitMessage(String message) {
        String[] messages = message.split("\n");
        String resultMessage = "";
        for (int i = 0; i < messages.length && i <= SIZE_MESSAGE; ++i) {
            resultMessage = resultMessage + messages[i];
            resultMessage = resultMessage + "\n";
        }
        return resultMessage;
    }

    static {
        addedMessage = false;
        info = new ArrayList();
        infoExceptions = new ArrayList();
        warnings = new ArrayList();
        warningsExceptions = new ArrayList();
        errors = new ArrayList();
        errorsExceptions = new ArrayList();
        listeners = new Vector();
        isFirst = true;
    }
}

