/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5BinaryFileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MD5BinaryFileUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5InRemoteFile(URL remote_file) {
        BufferedReader in = null;
        InputStreamReader istr = null;
        try {
            String _url = remote_file.toString() + ".md5";
            URL md5_url = new URL(_url);
            URLConnection connection = md5_url.openConnection();
            connection.setUseCaches(false);
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(20000);
            istr = new InputStreamReader(connection.getInputStream());
            in = new BufferedReader(istr);
            String inputLine = in.readLine();
            int space = inputLine.indexOf(" ");
            String string = inputLine = inputLine.substring(0, space);
            return string;
        }
        catch (Exception ex) {
            LOG.info("Error while reading MD5 file: " + ex.getMessage());
            String string = null;
            return string;
        }
        finally {
            try {
                in.close();
                istr.close();
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] createChecksum(File the_file) throws Exception {
        int numRead;
        FileInputStream fis = new FileInputStream(the_file);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    public static String getMD5Checksum(File the_file) throws Exception {
        byte[] b = MD5BinaryFileUtils.createChecksum(the_file);
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }
}

