/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.compat.se.lang;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.prefs.Preferences;
import org.gvsig.compat.lang.GraphicsUtils;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.compat.se.print.SePrintAttributes;
import org.gvsig.tools.swing.api.ToolsSwingLocator;

public class SEGraphUtils
implements GraphicsUtils {
    public BufferedImage copyBufferedImage(BufferedImage img) {
        BufferedImage newImage = ToolsSwingLocator.getToolsSwingManager().copyBufferedImage(img);
        return newImage;
    }

    public BufferedImage createBufferedImage(int w, int h, int type) {
        return ToolsSwingLocator.getToolsSwingManager().createBufferedImage(w, h, type);
    }

    public PrintAttributes createPrintAttributes() {
        return new SePrintAttributes();
    }

    public Font deriveFont(Font srcfont, float newheight) {
        return srcfont.deriveFont(newheight);
    }

    public int getScreenDPI() {
        Preferences prefsResolution = Preferences.userRoot().node("gvsig.configuration.screen");
        Toolkit kit = Toolkit.getDefaultToolkit();
        int dpi = prefsResolution.getInt("dpi", kit.getScreenResolution());
        return dpi;
    }

    public void translate(Graphics2D g, double x, double y) {
        g.translate(x, y);
    }

    public void setRenderingHintsForDrawing(Graphics2D g) {
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHints(renderHints);
    }

    public void setRenderingHintsForPrinting(Graphics2D g) {
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHints(renderHints);
    }
}

