/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.text.MessageFormat;
import java.util.Objects;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.GeometryExpressionBuilderHelper;
import org.gvsig.expressionevaluator.impl.ProjectionUtils;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.lang.Cloneable;

public class DefaultGeometryExpressionBuilderHelper
implements GeometryExpressionBuilderHelper {
    private static final String FORMAT_ST_SRID = "ST_SRID({0})";
    private static final String FORMAT_ST_ASTEXT = "ST_AsText({0})";
    private static final String FORMAT_ST_ASBINARY = "ST_AsBinary({0})";
    private static final String FORMAT_ST_ASEWKB = "ST_AsEWKB({0})";
    private static final String FORMAT_ST_CONTAINS = "ST_Contains(({0}), ({1}))";
    private static final String FORMAT_ST_CROSSES = "ST_Crosses(({0}), ({1}))";
    private static final String FORMAT_ST_DISJOINT = "ST_Disjoint(({0}), ({1}))";
    private static final String FORMAT_ST_EQUALS = "ST_Equals(({0}), ({1}))";
    private static final String FORMAT_ST_ISCLOSED = "ST_IsClosed({0})";
    private static final String FORMAT_ST_OVERLAPS = "ST_Overlaps(({0}), ({1}))";
    private static final String FORMAT_ST_TOUCHES = "ST_Touches(({0}), ({1}))";
    private static final String FORMAT_ST_WITHIN = "ST_Within(({0}), ({1}))";
    private static final String FORMAT_ST_ENVELOPE = "ST_Envelope({0})";
    private static final String FORMAT_ST_FORCE2D = "ST_Force2D({0})";
    private static final String FORMAT_ST_INTERSECTS = "ST_Intersects(({0}), ({1}))";
    private static final String FORMAT_ST_GEOMFROMTEXT = "ST_GeomFromText(({0}), ({1}))";
    private static final String FORMAT_ST_GEOMFROMWKB = "ST_GeomFromWKB(({0}), ({1}))";
    private static final String FORMAT_ST_GEOMFROMEWKB = "ST_GeomFromEWKB(({0}), ({1}))";
    private static final String FORMAT_ST_SIMPLIFY = "ST_Simplify(({0}), ({1}))";
    protected GeometryExpressionBuilderHelper.GeometrySupportType geometrySupportType;
    private ExpressionBuilder builder;

    public DefaultGeometryExpressionBuilderHelper(ExpressionBuilder builder) {
        this.builder = builder;
        this.geometrySupportType = GeometryExpressionBuilderHelper.GeometrySupportType.WKB;
    }

    public DefaultGeometryExpressionBuilderHelper() {
        this.geometrySupportType = GeometryExpressionBuilderHelper.GeometrySupportType.WKB;
    }

    public ExpressionBuilder builder() {
        return this.builder;
    }

    public GeometryExpressionBuilderHelper.GeometrySupportType geometry_support_type() {
        return this.geometrySupportType;
    }

    public GeometryExpressionBuilderHelper geometry_support_type(GeometryExpressionBuilderHelper.GeometrySupportType geometrySupportType) {
        this.geometrySupportType = geometrySupportType;
        return this;
    }

    public Object srs_id(IProjection projection) {
        if (projection == null) {
            return 0;
        }
        return ProjectionUtils.getCode(projection);
    }

    public ExpressionBuilder.Constant srs(IProjection projection) {
        if (projection == null) {
            return this.builder().constant(null);
        }
        return new ProjectionConstant(this, projection);
    }

    public ExpressionBuilder.Constant geometry(Geometry geom, IProjection projection) {
        if (geom == null) {
            return this.builder().constant(null);
        }
        geom.setProjection(projection);
        return new GeometryConstant(this, geom);
    }

    public ExpressionBuilder.Constant geometry(Geometry geom) {
        if (geom == null) {
            return this.builder().constant(null);
        }
        if (geom.getProjection() == null) {
            throw new IllegalArgumentException("The geometry does not have an associated projection. Use 'geometry(Geometry, IProjection)'.");
        }
        return new GeometryConstant(this, geom);
    }

    public ExpressionBuilder.Constant envelope(Envelope envelope, IProjection projection) {
        if (envelope == null) {
            return this.builder().constant(null);
        }
        Geometry geom = envelope.getGeometry();
        geom.setProjection(projection);
        return new GeometryConstant(this, geom);
    }

    public ExpressionBuilder.Constant envelope(Envelope envelope) {
        if (envelope == null) {
            return this.builder().constant(null);
        }
        if (envelope.getProjection() == null) {
            throw new IllegalArgumentException("The envelope does not have an associated projection. Use 'envelope(Geometry, IProjection)'.");
        }
        Geometry geom = envelope.getGeometry();
        return new GeometryConstant(this, geom);
    }

    public GeometryExpressionBuilderHelper.GeometryParameter parameter() {
        GeometryParameterBase p = new GeometryParameterBase(this);
        return p;
    }

    public GeometryExpressionBuilderHelper.GeometryParameter parameter(String name) {
        GeometryParameterBase p = new GeometryParameterBase(this);
        p.name(name);
        return p;
    }

    public GeometryExpressionBuilderHelper.GeometryParameter parameter(Object value) {
        GeometryParameterBase p = new GeometryParameterBase(this);
        p.value(value);
        return p;
    }

    public ExpressionBuilder.Function builtin_function(String name, String format, ExpressionBuilder.Value ... values) {
        ExpressionBuilder.Function func = this.builder().function(name, values);
        func.format(format);
        return func;
    }

    public ExpressionBuilder.Function function(String name, ExpressionBuilder.Value ... values) {
        ExpressionBuilder.Function func = this.builder().function(name, values);
        return func;
    }

    public ExpressionBuilder.Value as_geometry(ExpressionBuilder.Value value) {
        return this.builtin_function("ST_AsBinary", FORMAT_ST_ASBINARY, value);
    }

    public ExpressionBuilder.Function ST_Intersects(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.builtin_function("ST_Intersects", FORMAT_ST_INTERSECTS, geom1, geom2);
    }

    public ExpressionBuilder.Function andand(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.builtin_function("&&", "(({0}) && ({1}))", geom1, geom2);
    }

    public ExpressionBuilder.Function ST_SRID(ExpressionBuilder.Value geom) {
        return this.builtin_function("ST_SRID", FORMAT_ST_SRID, geom);
    }

    public ExpressionBuilder.Function ST_Envelope(ExpressionBuilder.Value geom) {
        return this.builtin_function("ST_Envelope", FORMAT_ST_ENVELOPE, geom);
    }

    public ExpressionBuilder.Function ST_Force2D(ExpressionBuilder.Value geom) {
        return this.builtin_function("ST_Force2D", FORMAT_ST_FORCE2D, geom);
    }

    public ExpressionBuilder.Function ST_AsText(ExpressionBuilder.Value geom) {
        return this.builtin_function("ST_AsText", FORMAT_ST_ASTEXT, geom);
    }

    public ExpressionBuilder.Function ST_AsBinary(ExpressionBuilder.Value geom) {
        return this.builtin_function("ST_AsBinary", FORMAT_ST_ASBINARY, geom);
    }

    public ExpressionBuilder.Function ST_AsEWKB(ExpressionBuilder.Value geom) {
        return this.builtin_function("ST_AsEWKB", FORMAT_ST_ASEWKB, geom);
    }

    public ExpressionBuilder.Function ST_GeomFromText(ExpressionBuilder.Value geom, ExpressionBuilder.Value crs) {
        return this.builtin_function("ST_GeomFromText", FORMAT_ST_GEOMFROMTEXT, geom, crs);
    }

    public ExpressionBuilder.Function ST_GeomFromWKB(ExpressionBuilder.Value geom, ExpressionBuilder.Value crs) {
        return this.builtin_function("ST_GeomFromWKB", FORMAT_ST_GEOMFROMWKB, geom, crs);
    }

    public ExpressionBuilder.Function ST_GeomFromEWKB(ExpressionBuilder.Value geom, ExpressionBuilder.Value crs) {
        return this.builtin_function("ST_GeomFromEWKB", FORMAT_ST_GEOMFROMEWKB, geom, crs);
    }

    public ExpressionBuilder.Function ST_Simplify(ExpressionBuilder.Value geom, ExpressionBuilder.Value tolerance) {
        return this.builtin_function("ST_Simplify", FORMAT_ST_SIMPLIFY, tolerance);
    }

    public ExpressionBuilder.Function ST_Disjoint(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.builtin_function("ST_Disjoint", FORMAT_ST_DISJOINT, geom1, geom2);
    }

    public ExpressionBuilder.Function ST_Contains(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.builtin_function("ST_Contains", FORMAT_ST_CONTAINS, geom1, geom2);
    }

    public ExpressionBuilder.Function ST_Equals(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.builtin_function("ST_Equals", FORMAT_ST_EQUALS, geom1, geom2);
    }

    public ExpressionBuilder.Function ST_Crosses(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.builtin_function("ST_Crosses", FORMAT_ST_CROSSES, geom1, geom2);
    }

    public ExpressionBuilder.Function ST_IsClosed(ExpressionBuilder.Value geom) {
        return this.builtin_function("ST_IsClosed", FORMAT_ST_ISCLOSED, geom);
    }

    public ExpressionBuilder.Function ST_Overlaps(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.builtin_function("ST_Overlaps", FORMAT_ST_OVERLAPS, geom1, geom2);
    }

    public ExpressionBuilder.Function ST_Touches(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.builtin_function("ST_Touches", FORMAT_ST_TOUCHES, geom1, geom2);
    }

    public ExpressionBuilder.Function ST_Within(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.builtin_function("ST_Within", FORMAT_ST_WITHIN, geom1, geom2);
    }

    public ExpressionBuilder.Function ST_Area(ExpressionBuilder.Value geom) {
        return this.function("ST_Area", geom);
    }

    public ExpressionBuilder.Function ST_Buffer(ExpressionBuilder.Value geom) {
        return this.function("ST_Buffer", geom);
    }

    public ExpressionBuilder.Function ST_Buffer(ExpressionBuilder.Value geom, ExpressionBuilder.Value dist) {
        return this.function("ST_Buffer", geom, dist);
    }

    public ExpressionBuilder.Function ST_Centroid(ExpressionBuilder.Value geom) {
        return this.function("ST_Centroid", geom);
    }

    public ExpressionBuilder.Function ST_CoveredBy(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.function("ST_CoveredBy", geom1, geom2);
    }

    public ExpressionBuilder.Function ST_Covers(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.function("ST_Covers", geom1, geom2);
    }

    public ExpressionBuilder.Function ST_Diference(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.function("ST_Difference", geom1, geom2);
    }

    public ExpressionBuilder.Function ST_Difference(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.function("ST_Difference", geom1, geom2);
    }

    public ExpressionBuilder.Function ST_Dimension(ExpressionBuilder.Value geom) {
        return this.function("ST_Dimension", geom);
    }

    public ExpressionBuilder.Function ST_Distance(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.function("ST_Distance", geom1, geom2);
    }

    public ExpressionBuilder.Function ST_EndPoint(ExpressionBuilder.Value geom) {
        return this.function("ST_EndPoint", geom);
    }

    public ExpressionBuilder.Function ST_Intersection(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.function("ST_Intersection", geom1, geom2);
    }

    public ExpressionBuilder.Function ST_IsSimple(ExpressionBuilder.Value geom) {
        return this.function("ST_IsSimple", geom);
    }

    public ExpressionBuilder.Function ST_IsValid(ExpressionBuilder.Value geom) {
        return this.function("ST_IsValid", geom);
    }

    public ExpressionBuilder.Function ST_IsEmpty(ExpressionBuilder.Value geom) {
        return this.function("ST_IsEmpty", geom);
    }

    public ExpressionBuilder.Function ST_NumGeometries(ExpressionBuilder.Value geom) {
        return this.function("ST_NumGeometries", geom);
    }

    public ExpressionBuilder.Function ST_NumPoints(ExpressionBuilder.Value geom) {
        return this.function("ST_NumPoints", geom);
    }

    public ExpressionBuilder.Function ST_Perimeter(ExpressionBuilder.Value geom) {
        return this.function("ST_Perimeter", geom);
    }

    public ExpressionBuilder.Function ST_PointN(ExpressionBuilder.Value geom, ExpressionBuilder.Value n) {
        return this.function("ST_PointN", geom, n);
    }

    public ExpressionBuilder.Function ST_StartPoint(ExpressionBuilder.Value geom) {
        return this.function("ST_StartPoint", geom);
    }

    public ExpressionBuilder.Function ST_Union(ExpressionBuilder.Value geom1, ExpressionBuilder.Value geom2) {
        return this.function("ST_Union", geom1, geom2);
    }

    public ExpressionBuilder.Function ST_X(ExpressionBuilder.Value geom) {
        return this.function("ST_X", geom);
    }

    public ExpressionBuilder.Function ST_Y(ExpressionBuilder.Value geom) {
        return this.function("ST_Y", geom);
    }

    public ExpressionBuilder.Function ST_Z(ExpressionBuilder.Value geom) {
        return this.function("ST_Z", geom);
    }

    public ExpressionBuilder.Function ST_Length(ExpressionBuilder.Value geom) {
        return this.function("ST_Length", geom);
    }

    public ExpressionBuilder.Function ST_ExtentAggregate(ExpressionBuilder.Value geom) {
        return this.function("ST_ExtentAggregate", geom);
    }

    public ExpressionBuilder.Function ST_UnionAggregate(ExpressionBuilder.Value geom) {
        return this.function("ST_UnionAggregate", geom);
    }

    public ExpressionBuilder.Function ST_Point(ExpressionBuilder.Value x, ExpressionBuilder.Value y) {
        return this.function("ST_Point", x, y);
    }

    public ExpressionBuilder.Function ST_MakePoint(ExpressionBuilder.Value x, ExpressionBuilder.Value y) {
        return this.function("ST_MakePoint", x, y);
    }

    public ExpressionBuilder.Function ST_MakePoint(ExpressionBuilder.Value x, ExpressionBuilder.Value y, ExpressionBuilder.Value z) {
        return this.function("ST_MakePoint", x, y, z);
    }

    public ExpressionBuilder.Function ST_MakePoint(ExpressionBuilder.Value x, ExpressionBuilder.Value y, ExpressionBuilder.Value z, ExpressionBuilder.Value m) {
        return this.function("ST_MakePoint", x, y, z, m);
    }

    public ExpressionBuilder.Function ST_MakePolygon(ExpressionBuilder.Value lineString) {
        return this.function("ST_MakePolygon", lineString);
    }

    public ExpressionBuilder.Function ST_SetSRID(ExpressionBuilder.Value geom, ExpressionBuilder.Value srid) {
        return this.function("ST_Point", geom, srid);
    }

    public ExpressionBuilder.Function ST_ExteriorRing(ExpressionBuilder.Value geom) {
        return this.function("ST_ExteriorRing", geom);
    }

    public static class ProjectionConstant
    extends ExpressionBuilder.AbstractValue
    implements ExpressionBuilder.Constant {
        protected IProjection projection;
        protected GeometryExpressionBuilderHelper builder;

        public ProjectionConstant(GeometryExpressionBuilderHelper builder, IProjection projection) {
            this.projection = projection;
            this.builder = builder;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)this.builder.builder().formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            return Objects.toString(this.builder.srs_id(this.projection));
        }

        public Object value() {
            return this.projection;
        }
    }

    public static class GeometryConstant
    extends ExpressionBuilder.AbstractValue
    implements ExpressionBuilder.Constant {
        protected Geometry geometry;
        protected GeometryExpressionBuilderHelper builder;

        public GeometryConstant(GeometryExpressionBuilderHelper builder, Geometry geometry) {
            this.builder = builder;
            this.geometry = geometry;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)this.builder.builder().formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            switch (this.builder.geometry_support_type()) {
                case EWKB: {
                    return MessageFormat.format(DefaultGeometryExpressionBuilderHelper.FORMAT_ST_GEOMFROMEWKB, "DECODE('" + this.builder.builder().bytearray_hex(GeometryUtils.toEWKB((Geometry)this.geometry)) + "','hex')", this.getSRS());
                }
                case WKB: {
                    return MessageFormat.format(DefaultGeometryExpressionBuilderHelper.FORMAT_ST_GEOMFROMWKB, "DECODE('" + this.builder.builder().bytearray_hex(GeometryUtils.toWKB((Geometry)this.geometry)) + "','hex')", this.getSRS());
                }
                case NATIVE: {
                    return MessageFormat.format("DECODE(''{0}'',''hex'')", this.builder.builder().bytearray_hex(GeometryUtils.toEWKB((Geometry)this.geometry)));
                }
            }
            return MessageFormat.format(DefaultGeometryExpressionBuilderHelper.FORMAT_ST_GEOMFROMTEXT, this.builder.builder().string(GeometryUtils.toWKT((Geometry)this.geometry)), this.getSRS());
        }

        public Object value() {
            return this.geometry;
        }

        private String getSRS() {
            IProjection proj = this.geometry.getProjection();
            Object s = this.builder.srs_id(proj);
            if (s == null) {
                throw new IllegalArgumentException("A parameter of type Geometry with an invalid SRS.");
            }
            return s.toString();
        }
    }

    public class GeometryParameterBase
    extends ExpressionBuilder.AbstractValue
    implements GeometryExpressionBuilderHelper.GeometryParameter {
        protected ExpressionBuilder.Value srs;
        protected GeometryExpressionBuilderHelper builder;
        protected String name = null;
        protected Object value = null;
        protected int type = 0;

        public GeometryParameterBase(GeometryExpressionBuilderHelper builder) {
            this.builder = builder;
        }

        public ExpressionBuilder.Value clone() throws CloneNotSupportedException {
            GeometryParameterBase other = (GeometryParameterBase)super.clone();
            other.srs = (ExpressionBuilder.Value)Cloneable.cloneQuietly((Cloneable)this.srs);
            return other;
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren && this.srs != null) {
                block0 : switch (this.type) {
                    case 0: 
                    case 2: {
                        switch (this.builder.geometry_support_type()) {
                            case NATIVE: {
                                break block0;
                            }
                        }
                        this.srs.accept(visitor, filter);
                        break;
                    }
                    default: {
                        this.srs.accept(visitor, filter);
                    }
                }
            }
        }

        public void replace(ExpressionBuilder.Value target, ExpressionBuilder.Value replacement) {
            if (this.srs == null) {
                return;
            }
            if (this.srs == target) {
                this.srs = replacement;
            } else {
                this.srs.replace(target, replacement);
            }
        }

        public GeometryExpressionBuilderHelper.GeometryParameter value(Object value) {
            if (value instanceof Geometry && this.srs == null) {
                IProjection proj = ((Geometry)value).getProjection();
                this.srs((ExpressionBuilder.Value)this.builder.parameter().value((Object)proj));
            }
            this.value = value;
            return this;
        }

        public GeometryExpressionBuilderHelper.GeometryParameter srs(IProjection srs) {
            this.srs = new ProjectionConstant(this.builder, srs);
            if (this.type == 1) {
                this.type = 2;
            }
            return this;
        }

        public GeometryExpressionBuilderHelper.GeometryParameter srs(ExpressionBuilder.Value srs) {
            this.srs = srs;
            if (this.type == 1) {
                this.type = 2;
            }
            return this;
        }

        public ExpressionBuilder.Value srs() {
            return this.srs;
        }

        public Geometry geometry() {
            return (Geometry)this.value;
        }

        public GeometryExpressionBuilderHelper.GeometryParameter as_constant() {
            this.type = 0;
            if (this.value == null && this.name != null) {
                this.value = this.name;
            }
            return this;
        }

        public GeometryExpressionBuilderHelper.GeometryParameter as_variable() {
            this.type = 1;
            if (this.value != null && this.name == null) {
                this.name = (String)this.value;
            }
            return this;
        }

        public GeometryExpressionBuilderHelper.GeometryParameter name(String name) {
            this.type = 1;
            this.name = name;
            return this;
        }

        public String name() {
            switch (this.type) {
                case 1: {
                    return this.name;
                }
                case 0: {
                    if (this.value == null) {
                        return null;
                    }
                    return this.value.toString();
                }
            }
            if (this.name != null) {
                return this.name;
            }
            if (this.value != null) {
                return this.value.toString();
            }
            return null;
        }

        public int type() {
            return this.type;
        }

        public boolean is_constant() {
            return this.type == 0;
        }

        public boolean is_variable() {
            return this.type == 1;
        }

        public GeometryExpressionBuilderHelper.GeometryParameter as_geometry_variable() {
            this.type = 2;
            if (this.value == null && this.name != null) {
                this.value = this.name;
            }
            return this;
        }

        public boolean is_geometry_variable() {
            return this.type == 2;
        }

        public Object value() {
            try {
                switch (this.type) {
                    case 0: {
                        if (this.value instanceof Geometry) {
                            switch (this.builder.geometry_support_type()) {
                                case NATIVE: {
                                    return GeometryUtils.toEWKB((Geometry)this.geometry());
                                }
                                case EWKB: {
                                    return GeometryUtils.toEWKB((Geometry)this.geometry());
                                }
                                case WKB: {
                                    return GeometryUtils.toWKB((Geometry)this.geometry());
                                }
                            }
                            return GeometryUtils.toWKT((Geometry)this.geometry());
                        }
                        if (this.value instanceof IProjection) {
                            return this.builder.srs_id((IProjection)this.value);
                        }
                        return this.value;
                    }
                }
                return this.value;
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't get value from parameter.", ex);
            }
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)this.builder.builder().formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            switch (this.type) {
                case 0: {
                    if (this.value instanceof Geometry) {
                        switch (this.builder.geometry_support_type()) {
                            case EWKB: {
                                return MessageFormat.format(DefaultGeometryExpressionBuilderHelper.FORMAT_ST_GEOMFROMEWKB, "?", this.getSRS(formatter));
                            }
                            case WKB: {
                                return MessageFormat.format(DefaultGeometryExpressionBuilderHelper.FORMAT_ST_GEOMFROMWKB, "?", this.getSRS(formatter));
                            }
                            case NATIVE: {
                                return MessageFormat.format("DECODE('{0}','hex')", this.builder.builder().bytearray_hex(GeometryUtils.toEWKB((Geometry)((Geometry)this.value))));
                            }
                        }
                        return MessageFormat.format(DefaultGeometryExpressionBuilderHelper.FORMAT_ST_GEOMFROMTEXT, "?", this.getSRS(formatter));
                    }
                }
                default: {
                    return "?";
                }
                case 2: 
            }
            switch (this.builder.geometry_support_type()) {
                case EWKB: {
                    return MessageFormat.format(DefaultGeometryExpressionBuilderHelper.FORMAT_ST_GEOMFROMEWKB, "?", this.getSRS(formatter));
                }
                case WKB: {
                    return MessageFormat.format(DefaultGeometryExpressionBuilderHelper.FORMAT_ST_GEOMFROMWKB, "?", this.getSRS(formatter));
                }
                case NATIVE: {
                    return "?";
                }
            }
            return MessageFormat.format(DefaultGeometryExpressionBuilderHelper.FORMAT_ST_GEOMFROMTEXT, "?", this.getSRS(formatter));
        }

        private String getSRS(Formatter formatter) {
            if (this.srs != null) {
                return this.srs.toString(formatter);
            }
            if (this.value instanceof Geometry) {
                IProjection proj = ((Geometry)this.value).getProjection();
                Object s = this.builder.srs_id(proj);
                if (s == null) {
                    throw new IllegalArgumentException("A parameter of type Geometry with an invalid SRS.");
                }
                return s.toString();
            }
            throw new IllegalArgumentException("The parameter of type Geometry need a SRS.");
        }
    }
}

