/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.spatial;

import org.apache.commons.lang3.Range;
import org.gvsig.euclidean.EuclideanManager;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractGeometryFunction;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.tools.util.ToolsUtilLocator;

public class ConvexTrapezoidLengthFunction
extends AbstractGeometryFunction {
    public ConvexTrapezoidLengthFunction() {
        super("Spatial", "ConvexTrapezoidLength", Range.is((Comparable)Integer.valueOf(1)));
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Geometry arg1 = (Geometry)this.getObject(args, 0);
        if (arg1 == null) {
            return null;
        }
        try {
            return ConvexTrapezoidLengthFunction.convexTrapezoidLength((Polygon)arg1);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static double convexTrapezoidLength(Polygon geom) {
        EuclideanManager manager = ToolsUtilLocator.getEuclideanManager();
        if (geom.getNumInteriorRings() != 0) {
            throw new IllegalArgumentException("Can't calculate convex trapezoid length if the polygon has interior rings");
        }
        if (geom.isClosed() ? geom.getNumVertices() != 5 : geom.getNumVertices() != 4) {
            throw new IllegalArgumentException("Wrong number of sides, a convex trapezoid is required");
        }
        double[] l = new double[]{manager.distance(geom.getCoordinateAt(0, 0), geom.getCoordinateAt(0, 1), geom.getCoordinateAt(1, 0), geom.getCoordinateAt(1, 1)), manager.distance(geom.getCoordinateAt(1, 0), geom.getCoordinateAt(1, 1), geom.getCoordinateAt(2, 0), geom.getCoordinateAt(2, 1)), manager.distance(geom.getCoordinateAt(2, 0), geom.getCoordinateAt(2, 1), geom.getCoordinateAt(3, 0), geom.getCoordinateAt(3, 1)), manager.distance(geom.getCoordinateAt(3, 0), geom.getCoordinateAt(3, 1), geom.getCoordinateAt(4, 0), geom.getCoordinateAt(4, 1))};
        if (!geom.isSimple()) {
            throw new IllegalArgumentException("Wrong trapezoid, a convex trapezoid is required");
        }
        int max = 0;
        for (int i = 0; i < l.length; ++i) {
            if (!(l[max] < l[i])) continue;
            max = i;
        }
        int opposed = max + 2;
        if (opposed > 3) {
            opposed = 1;
        }
        double n = (l[max] + l[opposed]) / 2.0;
        return n;
    }
}

