/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.spatial;

import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.apache.commons.math.util.MathUtils;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractGeometryFunction;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.text.DMSNumberFormat;

public class PointByAzimuthAndDistanceFunction
extends AbstractGeometryFunction {
    public PointByAzimuthAndDistanceFunction() {
        super("Spatial", "PointByAzimuthAndDistance", Range.is((Comparable)Integer.valueOf(3)), "Creates a point from an origin point, azimuth, and distance.\n\nFor example, to specify a point 52 units away at an angle of 15 degrees 17 minutes north and east of the origin point, you would indicate it with:\n  PointByAzimuthAndDistance(origin, 'N-15-17-E', 52)\nIn the editing console, this example would be entered as: \n  $ADI 'N-15-17-E', 52\ntaking the previously input point in the console as its origin.\n", "PointByAzimuthAndDistance({{origin}}, azimuth, distance)", new String[]{"origin - Origin Point", "azimuth - Angle in format [NS]-angle-[EW]", "distance - Distance from the origin point"}, "Point", false);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Object origin_o = this.getObject(args, 0);
        String azimuth_s = this.getStr(args, 1);
        double distance = this.getDouble(args, 2);
        Azimuth azimuth = this.parseAzimuth(azimuth_s);
        Point origin = origin_o instanceof Point ? (Point)origin_o : (Point)GeometryLocator.getGeometryManager().createFrom(origin_o);
        double angle = Math.toRadians(azimuth.getNormalizedAngleInDegrees());
        double deltaX = distance * MathUtils.round((double)Math.cos(angle), (int)8);
        double deltaY = distance * MathUtils.round((double)Math.sin(angle), (int)8);
        origin.move(deltaX, deltaY);
        return origin;
    }

    private Azimuth parseAzimuth(String azimuth_s) {
        Azimuth azimuth = new Azimuth();
        String s = azimuth_s.toUpperCase();
        int l = s.length();
        if (s.charAt(0) == 'S') {
            azimuth.northSouth = 2;
        } else if (s.charAt(0) == 'N') {
            azimuth.northSouth = 1;
        } else {
            throw new IllegalArgumentException("Azimuth format invalid [" + azimuth_s + "]");
        }
        if (s.charAt(l - 1) == 'E') {
            azimuth.eastWest = 3;
        } else if (s.charAt(l - 1) == 'W') {
            azimuth.eastWest = 4;
        } else {
            throw new IllegalArgumentException("Invalid format for azimuth [" + azimuth_s + "]");
        }
        s = s.substring(2, l - 2);
        s = s.replace('-', ' ');
        try {
            DMSNumberFormat formatter = new DMSNumberFormat(false);
            azimuth.angle = formatter.parse(s);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid format for azimuth [" + azimuth_s + "]", ex);
        }
        return azimuth;
    }

    public static void main(String[] args) {
        PointByAzimuthAndDistanceFunction function = new PointByAzimuthAndDistanceFunction();
        String entrada = "N-45-30-E";
        System.out.println("\nentrada: " + entrada);
        Azimuth azimuth = function.parseAzimuth(entrada);
        System.out.println("NS: " + Objects.toString(azimuth.northSouth));
        System.out.println("EW: " + Objects.toString(azimuth.eastWest));
        System.out.println("angle: " + Objects.toString(azimuth.angle));
        System.out.println("standard angle: " + azimuth.getNormalizedAngleInDegrees());
        entrada = "N-45-30-W";
        System.out.println("\nentrada: " + entrada);
        azimuth = function.parseAzimuth(entrada);
        System.out.println("NS: " + Objects.toString(azimuth.northSouth));
        System.out.println("EW: " + Objects.toString(azimuth.eastWest));
        System.out.println("angle: " + Objects.toString(azimuth.angle));
        System.out.println("standard angle: " + azimuth.getNormalizedAngleInDegrees());
        entrada = "S-45-30-E";
        System.out.println("\nentrada: " + entrada);
        azimuth = function.parseAzimuth(entrada);
        System.out.println("NS: " + Objects.toString(azimuth.northSouth));
        System.out.println("EW: " + Objects.toString(azimuth.eastWest));
        System.out.println("angle: " + Objects.toString(azimuth.angle));
        System.out.println("standard angle: " + azimuth.getNormalizedAngleInDegrees());
        entrada = "S-45-30-W";
        System.out.println("\nentrada: " + entrada);
        azimuth = function.parseAzimuth(entrada);
        System.out.println("NS: " + Objects.toString(azimuth.northSouth));
        System.out.println("EW: " + Objects.toString(azimuth.eastWest));
        System.out.println("angle: " + Objects.toString(azimuth.angle));
        System.out.println("standard angle: " + azimuth.getNormalizedAngleInDegrees());
    }

    private static class Azimuth {
        private static final int N = 1;
        private static final int S = 2;
        private static final int E = 3;
        private static final int W = 4;
        int northSouth;
        double angle;
        int eastWest;

        private Azimuth() {
        }

        public double getNormalizedAngleInDegrees() {
            double standardAngle = this.northSouth == 1 ? (this.eastWest == 3 ? 90.0 - this.angle : 90.0 + this.angle) : (this.eastWest == 3 ? 270.0 + this.angle : 270.0 - this.angle);
            standardAngle %= 360.0;
            if (standardAngle < 0.0) {
                standardAngle += 360.0;
            }
            return standardAngle;
        }
    }
}

