/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.legend.picturemarkersymboltable.swing.impl;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.gvsig.app.project.documents.view.legend.gui.Categories;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.legend.picturemarkersymboltable.lib.api.PictureMarkerSymbolTableLegend;
import org.gvsig.legend.picturemarkersymboltable.lib.api.PictureMarkerSymbolTableLocator;
import org.gvsig.legend.picturemarkersymboltable.swing.api.PictureMarkerSymbolTableLegendEditor;
import org.gvsig.legend.picturemarkersymboltable.swing.impl.DefaultPictureMarkerSymbolTableLegendEditorView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.documentfilters.DoubleDocumentFilter;
import org.gvsig.tools.swing.api.pickercontroller.ColorPickerController;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.util.LabeledValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPictureMarkerSymbolTableLegendEditor
extends DefaultPictureMarkerSymbolTableLegendEditorView
implements PictureMarkerSymbolTableLegendEditor {
    private static final long serialVersionUID = 4307714097793669675L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPictureMarkerSymbolTableLegendEditor.class);
    private PictureMarkerSymbolTableLegend legend;
    private FLayer layer;
    private final Class<? extends PictureMarkerSymbolTableLegend> legendClass = PictureMarkerSymbolTableLocator.getPictureMarkerSymbolTableManager().getPictureMarkerSymbolTableLegendClass();
    private ColorPickerController pickerLineToOffsetColor;
    private AttributeDescriptorPickerController pickerClassifyingField;
    private AttributeDescriptorPickerController pickerOffsetXField;
    private AttributeDescriptorPickerController pickerOffsetYField;
    private AttributeDescriptorPickerController pickerRotationField;
    private AttributeDescriptorPickerController pickerLineToOffsetColorField;
    private AttributeDescriptorPickerController pickerImagesTableClassifyingField;
    private AttributeDescriptorPickerController pickerImageField;
    private AttributeDescriptorPickerController pickerImageSelectedField;
    private List<String> availablesTables;

    public DefaultPictureMarkerSymbolTableLegendEditor() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        this.translateAll();
        DoubleDocumentFilter.install((JTextField)this.txtImageSize);
        this.cboUnits.setModel(this.createModelUnits());
        this.cboUnits.setSelectedIndex(0);
        this.pickerLineToOffsetColor = toolsSwingManager.createColorPickerController((JTextComponent)this.txtLineToOffsetColor, this.btnLineToOffsetColor);
        this.pickerClassifyingField = dataSwingManager.createAttributeDescriptorPickerController(this.cboClassifyingFieldName, t -> t.getDataType().isNumeric() || t.getType() == 8);
        this.pickerClassifyingField.setAllowNull(true);
        this.pickerOffsetXField = dataSwingManager.createAttributeDescriptorPickerController(this.cboOffsetXFieldName, t -> t.getDataType().isNumeric());
        this.pickerOffsetYField = dataSwingManager.createAttributeDescriptorPickerController(this.cboOffsetYFieldName, t -> t.getDataType().isNumeric());
        this.pickerRotationField = dataSwingManager.createAttributeDescriptorPickerController(this.cboRotationFieldName, t -> t.getDataType().isNumeric());
        this.pickerLineToOffsetColorField = dataSwingManager.createAttributeDescriptorPickerController(this.cboLineToOffsetColorFieldName, t -> t.getDataType().isNumeric() || t.getType() == 8);
        this.cboImagesTableName.setModel(this.createImagesTableNameModel());
        this.pickerImagesTableClassifyingField = dataSwingManager.createAttributeDescriptorPickerController(this.cboImagesTableClassifyingFieldName, t -> t.getDataType().isNumeric() || t.getType() == 8);
        this.pickerImageField = dataSwingManager.createAttributeDescriptorPickerController(this.cboImageFieldName, t -> StringUtils.equalsIgnoreCase((String)"Image", (String)t.getDataProfileName()));
        this.pickerImageSelectedField = dataSwingManager.createAttributeDescriptorPickerController(this.cboImageSelectedFieldName, t -> StringUtils.equalsIgnoreCase((String)"Image", (String)t.getDataProfileName()));
        this.cboImagesTableName.addItemListener(e -> this.doChangeImageTableName());
        this.btnImagesTableNameRefresh.addActionListener(e -> this.doRefreshImageTables());
        this.cboImagesTableName.setSelectedIndex(-1);
        DoubleDocumentFilter.install((JTextField)this.txtScale);
    }

    private void translateAll() {
        ToolsSwingManager toolsSwingmanager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingmanager.translate(this.lblClassifyingFieldName);
        toolsSwingmanager.translate(this.lblDrawLineToOffset);
        toolsSwingmanager.translate(this.lblImageFieldName);
        toolsSwingmanager.translate(this.lblImageSelectedFieldName);
        toolsSwingmanager.translate(this.lblImagesTableClassifyingFieldName);
        toolsSwingmanager.translate((JComponent)this.lblImagesTableFields);
        toolsSwingmanager.translate(this.lblImagesTableName);
        toolsSwingmanager.translate((JComponent)this.lblLegendTableFields);
        toolsSwingmanager.translate(this.lblLineToOffsetColor);
        toolsSwingmanager.translate(this.lblLineToOffsetColorFieldName);
        toolsSwingmanager.translate(this.lblOffsetXFieldName);
        toolsSwingmanager.translate(this.lblOffsetYFieldName);
        toolsSwingmanager.translate(this.lblRotationFieldName);
        toolsSwingmanager.translate(this.lblImageSize);
        toolsSwingmanager.translate(this.lblUnits);
        toolsSwingmanager.translate(this.lblScale);
        toolsSwingmanager.translate(this.lblReverseDirectionOfAngle);
    }

    private ComboBoxModel createModelUnits() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        DefaultComboBoxModel<LabeledValueImpl> model = new DefaultComboBoxModel<LabeledValueImpl>();
        model.addElement(new LabeledValueImpl(i18n.getTranslation("_Pixels"), (Object)-1));
        String[] names = MapContext.getDistanceNames();
        int n = 0;
        for (String name : names) {
            model.addElement(new LabeledValueImpl(i18n.getTranslation(name), (Object)n++));
        }
        return model;
    }

    public void setData(FLayer layer, ILegend legend) {
        FeatureStore store;
        if (layer == this.layer && legend == this.legend) {
            return;
        }
        this.layer = layer;
        this.legend = this.getLegendClass().isInstance(legend) ? (PictureMarkerSymbolTableLegend)legend : PictureMarkerSymbolTableLocator.getPictureMarkerSymbolTableManager().createPictureMarkerSymbolTableLegend();
        if (layer instanceof FLyrVect && (store = ((FLyrVect)layer).getFeatureStore()) != null) {
            try {
                FeatureType ftype = store.getDefaultFeatureType();
                this.txtImageSize.setText(String.valueOf(this.legend.getImageSize()));
                ListElement.setSelected((JComboBox)this.cboUnits, (Object)this.legend.getUnits());
                this.pickerLineToOffsetColor.set((Object)this.legend.getDefaultLineToOffsetColor());
                this.chkDrawLineToOffset.setSelected(this.legend.isDrawLineToOffset());
                this.chkReverseDirectionOfAngle.setSelected(this.legend.isReverseDirectionOfAngle());
                this.pickerClassifyingField.setFeatureType(ftype);
                this.pickerOffsetXField.setFeatureType(ftype);
                this.pickerOffsetYField.setFeatureType(ftype);
                this.pickerRotationField.setFeatureType(ftype);
                this.pickerLineToOffsetColorField.setFeatureType(ftype);
                ListElement.setSelected((JComboBox)this.cboImagesTableName, (Object)this.legend.getImagesTableName());
                this.pickerClassifyingField.set(this.legend.getClassifyingFieldName());
                this.txtClassifyingValue.setText(this.legend.getClassifyingValue());
                this.pickerLineToOffsetColorField.set(this.legend.getLineToOffsetColorFieldName());
                this.pickerRotationField.set(this.legend.getRotationFieldName());
                this.pickerOffsetXField.set(this.legend.getOffsetXFieldName());
                this.pickerOffsetYField.set(this.legend.getOffsetYFieldName());
                DoubleDocumentFilter.setValue((JTextField)this.txtScale, (double)this.legend.getScale());
            }
            catch (Exception ex) {
                LOGGER.warn("Can't fill data of legend.", (Throwable)ex);
            }
        }
    }

    public ILegend getLegend() {
        this.legend.setImageSize((double)this.getImageSize());
        this.legend.setUnits(((Integer)ListElement.getSelected((JComboBox)this.cboUnits)).intValue());
        this.legend.setDefaultLineToOffsetColor((Color)this.pickerLineToOffsetColor.get());
        this.legend.setDrawLineToOffset(this.chkDrawLineToOffset.isSelected());
        this.legend.setReverseDirectionOfAngle(this.chkReverseDirectionOfAngle.isSelected());
        if (this.pickerClassifyingField.isEmpty()) {
            this.legend.setClassifyingValue(this.txtClassifyingValue.getText());
        } else {
            this.legend.setClassifyingFieldName(this.pickerClassifyingField.getName());
        }
        this.legend.setOffsetXFieldName(this.pickerOffsetXField.getName());
        this.legend.setOffsetYFieldName(this.pickerOffsetYField.getName());
        this.legend.setRotationFieldName(this.pickerRotationField.getName());
        this.legend.setLineToOffsetColorFieldName(this.pickerLineToOffsetColorField.getName());
        this.legend.setImagesTableName((String)this.cboImagesTableName.getSelectedItem());
        this.legend.setImagesTableClassifyingFieldName(this.pickerImagesTableClassifyingField.getName());
        this.legend.setImageFieldName(this.pickerImageField.getName());
        this.legend.setImageSelectedFieldName(this.pickerImageSelectedField.getName());
        this.legend.setScale(DoubleDocumentFilter.getValue((JTextField)this.txtScale));
        return this.legend;
    }

    private int getImageSize() {
        String s = this.txtImageSize.getText();
        return ExpressionUtils.parseInt(null, (String)s, (int)15);
    }

    public String getDescription() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Picture_marker_symbol_table_legend");
    }

    public ImageIcon getIcon() {
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        return theme.get("legend-overview-vectorial-picturemarkersymboltable");
    }

    public Class getParentClass() {
        return Categories.class;
    }

    public String getTitle() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Picture_marker_symbol_table_legend");
    }

    public JPanel getPanel() {
        return this;
    }

    public Class getLegendClass() {
        return this.legendClass;
    }

    public boolean isSuitableFor(FLayer layer) {
        return layer instanceof FLyrVect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doChangeImageTableName() {
        String tableName = (String)this.cboImagesTableName.getSelectedItem();
        if (StringUtils.isNotBlank((String)tableName)) {
            FeatureStore store;
            block6: {
                store = null;
                try {
                    DataManager dataManager = DALLocator.getDataManager();
                    StoresRepository repositories = dataManager.getStoresRepository();
                    store = (FeatureStore)repositories.getStore(tableName);
                    FeatureType ftype = store.getDefaultFeatureTypeQuietly();
                    boolean hasimages = false;
                    for (FeatureAttributeDescriptor attr : ftype) {
                        if (!StringUtils.equalsIgnoreCase((String)"Image", (String)attr.getDataProfileName())) continue;
                        hasimages = true;
                        break;
                    }
                    if (!hasimages) break block6;
                    this.pickerImagesTableClassifyingField.setFeatureType(ftype);
                    this.pickerImageField.setFeatureType(ftype);
                    this.pickerImageSelectedField.setFeatureType(ftype);
                    this.pickerImagesTableClassifyingField.setEnabled(true);
                    this.pickerImageField.setEnabled(true);
                    this.pickerImageSelectedField.setEnabled(true);
                    this.pickerImagesTableClassifyingField.set(this.legend.getImagesTableClassifyingFieldName());
                    this.pickerImageField.set(this.legend.getImageFieldName());
                    this.pickerImageSelectedField.set(this.legend.getImageSelectedFieldName());
                }
                catch (Exception ex) {
                    try {
                        LOGGER.debug("Can't use '" + tableName + "' as table for retrieve images.", (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        DisposeUtils.disposeQuietly(store);
                        throw throwable;
                    }
                    DisposeUtils.disposeQuietly((Disposable)store);
                }
                DisposeUtils.disposeQuietly((Disposable)store);
                return;
            }
            DisposeUtils.disposeQuietly((Disposable)store);
        }
        this.pickerImagesTableClassifyingField.clean();
        this.pickerImageField.clean();
        this.pickerImageSelectedField.clean();
        this.pickerImagesTableClassifyingField.setEnabled(false);
        this.pickerImageField.setEnabled(false);
        this.pickerImageSelectedField.setEnabled(false);
    }

    private void createListOfAvailableTables() {
        DataManager dataManager = DALLocator.getDataManager();
        HashMap<String, Integer> allTableNames = new HashMap<String, Integer>();
        StoresRepository repositories = dataManager.getStoresRepository();
        for (String tableName : repositories.keySet()) {
            DataStoreParameters params = (DataStoreParameters)repositories.get((Object)tableName);
            if (!(params instanceof OpenFeatureStoreParameters)) continue;
            if (allTableNames.containsKey(tableName)) {
                allTableNames.put(tableName, (Integer)allTableNames.get(tableName) + 1);
                continue;
            }
            allTableNames.put(tableName, 1);
        }
        ArrayList<String> tableNames = new ArrayList<String>();
        for (String tableName : allTableNames.keySet()) {
            if ((Integer)allTableNames.get(tableName) != 1) continue;
            tableNames.add(tableName);
        }
        Collections.sort(tableNames);
        this.availablesTables = tableNames;
    }

    private ComboBoxModel createImagesTableNameModel() {
        if (CollectionUtils.isEmpty(this.availablesTables)) {
            this.createListOfAvailableTables();
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String tableName : this.availablesTables) {
            model.addElement(tableName);
        }
        return model;
    }

    private void doRefreshImageTables() {
        this.availablesTables = null;
        this.cboImagesTableName.setModel(this.createImagesTableNameModel());
        this.cboImagesTableName.setSelectedIndex(-1);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }
}

