/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.app;

import java.awt.Component;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.prepareAction.PrepareDataStoreParameters;
import org.gvsig.app.prepareAction.PrepareLayer;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.raster.cache.tile.TileCache;
import org.gvsig.raster.cache.tile.TileCacheLibrary;
import org.gvsig.raster.cache.tile.TileCacheLocator;
import org.gvsig.raster.tilecache.app.Configuration;
import org.gvsig.raster.tilecache.app.ConfigurationEvent;
import org.gvsig.raster.tilecache.app.ConfigurationListener;
import org.gvsig.raster.tilecache.app.PrepareLayerAskUsingTiles;
import org.gvsig.raster.tilecache.app.TileCachePreferences;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;

public class CacheExtension
extends Extension
implements ConfigurationListener {
    public void execute(String actionCommand) {
    }

    public void initialize() {
        IconThemeHelper.registerIcon(null, (String)"pref-tilecache-icon", (Object)this);
        Configuration.addValueChangedListener(this);
        Preferences prefs = Preferences.userRoot().node("gvsig.foldering");
        prefs.put("DataFolder", System.getProperty("user.home"));
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add("AplicationPreferences");
        point.append("TileCachePreferences", "", TileCachePreferences.class);
        TileCacheLibrary.DEFAULT_TILEHEIGHT = TileCacheLibrary.DEFAULT_TILEWIDTH = Configuration.getValue("tilesize", TileCacheLibrary.DEFAULT_TILEWIDTH).intValue();
        TileCacheLibrary.ALTERNATIVE_TILESIZE = Configuration.getValue("tilesizewms", TileCacheLibrary.ALTERNATIVE_TILESIZE);
        ApplicationManager appGvSigMan = ApplicationLocator.getManager();
        appGvSigMan.registerPrepareOpenLayer((PrepareLayer)new PrepareLayerAskUsingTiles());
        appGvSigMan.registerPrepareOpenDataStoreParameters((PrepareDataStoreParameters)new PrepareLayerAskUsingTiles());
    }

    public boolean isEnabled() {
        return false;
    }

    public boolean isVisible() {
        return false;
    }

    @Override
    public void actionConfigurationChanged(ConfigurationEvent e) {
        if (e.getKey().equals("path_tilecache")) {
            String value;
            if (e.getValue() instanceof String && (value = (String)e.getValue()) != null && value.compareTo("") != 0) {
                RasterLibrary.pathTileCache = (String)e.getValue();
                TileCache tc = TileCacheLocator.getManager().getTileCache(RasterLibrary.pathTileCache);
                tc.updateBaseDirectory(RasterLibrary.pathTileCache);
            }
            return;
        }
        if (e.getKey().equals("tile_levels")) {
            if (e.getValue() instanceof String) {
                try {
                    TileCacheLibrary.DEFAULT_LEVELS = new Integer((String)e.getValue());
                }
                catch (NumberFormatException value) {
                    // empty catch block
                }
            }
            if (e.getValue() instanceof Integer) {
                TileCacheLibrary.DEFAULT_LEVELS = (Integer)e.getValue();
            }
            return;
        }
        if (e.getKey().equals("tilesize")) {
            if (e.getValue() instanceof String) {
                try {
                    String text = (String)e.getValue();
                    text = text.replaceAll("\\.", "");
                    text = text.replaceAll(",", "\\.");
                    TileCacheLibrary.DEFAULT_TILEHEIGHT = TileCacheLibrary.DEFAULT_TILEWIDTH = new Integer(text).intValue();
                }
                catch (NumberFormatException text) {
                    // empty catch block
                }
            }
            if (e.getValue() instanceof Integer) {
                TileCacheLibrary.DEFAULT_TILEHEIGHT = TileCacheLibrary.DEFAULT_TILEWIDTH = ((Integer)e.getValue()).intValue();
            }
            return;
        }
        if (e.getKey().equals("tilesizewms")) {
            if (e.getValue() instanceof String) {
                try {
                    String text = (String)e.getValue();
                    text = text.replaceAll("\\.", "");
                    text = text.replaceAll(",", "\\.");
                    TileCacheLibrary.ALTERNATIVE_TILESIZE = new Integer(text);
                }
                catch (NumberFormatException text) {
                    // empty catch block
                }
            }
            if (e.getValue() instanceof Integer) {
                TileCacheLibrary.ALTERNATIVE_TILESIZE = (Integer)e.getValue();
            }
            return;
        }
        if (e.getKey().equals("tilecache_size")) {
            if (e.getValue() instanceof String) {
                try {
                    String text = (String)e.getValue();
                    text = text.replaceAll("\\.", "");
                    text = text.replaceAll(",", "\\.");
                    TileCacheLibrary.MAX_CACHE_SIZE = new Integer((String)e.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (e.getValue() instanceof Integer) {
                TileCacheLibrary.MAX_CACHE_SIZE = (Integer)e.getValue();
            }
            return;
        }
        if (e.getKey().equals("cache_struct")) {
            if (e.getValue() instanceof String) {
                TileCacheLibrary.DEFAULT_STRUCTURE = (String)e.getValue();
            }
            return;
        }
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
    }

    public void postInitialize() {
        super.postInitialize();
    }

    public static void messageBoxError(String msg, Object parentWindow) {
        String string = PluginServices.getText((Object)parentWindow, (String)"accept");
        Object[] options = new Object[]{string};
        JOptionPane.showOptionDialog((Component)PluginServices.getMainFrame(), "<html>" + PluginServices.getText((Object)parentWindow, (String)msg).replaceAll("\n", "<br>") + "</html>", PluginServices.getText((Object)parentWindow, (String)"confirmacion"), 0, 0, null, options, string);
    }

    public static boolean messageBoxYesOrNot(String msg, Object parentWindow) {
        String string1 = PluginServices.getText((Object)parentWindow, (String)"yes");
        String string2 = PluginServices.getText((Object)parentWindow, (String)"no");
        Object[] options = new Object[]{string1, string2};
        int n = JOptionPane.showOptionDialog((Component)PluginServices.getMainFrame(), "<html>" + PluginServices.getText((Object)parentWindow, (String)msg).replaceAll("\n", "<br>") + "</html>", PluginServices.getText((Object)parentWindow, (String)"confirmacion"), 0, 3, null, options, string1);
        return n == 0;
    }
}

