/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.preferences.DlgPreferences;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.cache.tile.TileCacheLibrary;
import org.gvsig.raster.tilecache.app.CacheExtension;
import org.gvsig.raster.tilecache.app.Configuration;
import org.gvsig.raster.util.BasePanel;

public class TileCachePreferencesPanel
extends BasePanel
implements ActionListener {
    protected static final long serialVersionUID = 1L;
    private static int TILE_SIZE_WMS = 1024;
    private JLabel labelWarning = null;
    private JLabel labelCacheSize = null;
    private JLabel labelLevels = null;
    private JLabel labelStruct = null;
    private JLabel labelTileSize = null;
    private JLabel labelWMSTileSize = null;
    private JLabel labelPath = null;
    private JFormattedTextField textFieldCacheSize = null;
    private JFormattedTextField textFieldLevels = null;
    private JFormattedTextField textFieldTileSize = null;
    private JFormattedTextField textFieldWMSTileSize = null;
    private JTextField textFieldPath = null;
    private JComboBox comboBoxStruct = null;
    private JButton buttonRemove = null;

    public TileCachePreferencesPanel() {
        this.init();
        this.translate();
    }

    protected void translate() {
        this.setBorder(BorderFactory.createTitledBorder(this.getText(this, "tilecache")));
        this.getLabelWarning().setText(this.getText(this, "preference_cache_warning"));
        this.getLabelCacheSize().setText(this.getText(this, "tamanyo_max_tilecache") + ":");
        this.getLabelLevels().setText(this.getText(this, "res_levels") + ":");
        this.getLabelTileSize().setText(this.getText(this, "tilesize") + ":");
        this.getLabelWMSTileSize().setText("WMS/WCS " + this.getText(this, "tilesize") + ":");
        this.getLabelStruct().setText(this.getText(this, "tilecache_struct") + ":");
        this.getButtonRemove().setText(this.getText(this, "remove_cache"));
        this.getLabelPath().setText(this.getText(this, "path_tilecache"));
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        this.add(this.getLabelWarning(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getLabelCacheSize(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getLabelLevels(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getLabelTileSize(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getLabelWMSTileSize(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getLabelStruct(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getButtonRemove(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getLabelPath(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add(this.getTextFieldCacheSize(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add(this.getTextFieldLevels(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add(this.getTextFieldTileSize(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add(this.getTextFieldWMSTileSize(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add(this.getComboBoxStruct(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add(this.getTextFieldPath(), gridBagConstraints);
    }

    private JLabel getLabelWarning() {
        if (this.labelWarning == null) {
            this.labelWarning = new JLabel();
            this.labelWarning.setForeground(new Color(255, 0, 0));
            this.labelWarning.setHorizontalAlignment(0);
            this.labelWarning.setPreferredSize(new Dimension(0, 32));
        }
        return this.labelWarning;
    }

    private JButton getButtonRemove() {
        if (this.buttonRemove == null) {
            this.buttonRemove = new JButton();
            this.buttonRemove.addActionListener(this);
        }
        return this.buttonRemove;
    }

    private JComboBox getComboBoxStruct() {
        if (this.comboBoxStruct == null) {
            this.comboBoxStruct = new JComboBox();
            this.comboBoxStruct.setModel(new DefaultComboBoxModel<String>(new String[]{"FLATX"}));
        }
        return this.comboBoxStruct;
    }

    private JTextField getTextFieldPath() {
        if (this.textFieldPath == null) {
            this.textFieldPath = new JTextField();
        }
        return this.textFieldPath;
    }

    private JFormattedTextField getTextFieldCacheSize() {
        if (this.textFieldCacheSize == null) {
            NumberFormat integerFormat = NumberFormat.getNumberInstance();
            integerFormat.setParseIntegerOnly(true);
            this.textFieldCacheSize = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(integerFormat), new NumberFormatter(integerFormat), new NumberFormatter(integerFormat)));
        }
        return this.textFieldCacheSize;
    }

    private JFormattedTextField getTextFieldTileSize() {
        if (this.textFieldTileSize == null) {
            NumberFormat integerFormat = NumberFormat.getNumberInstance();
            integerFormat.setParseIntegerOnly(true);
            this.textFieldTileSize = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(integerFormat), new NumberFormatter(integerFormat), new NumberFormatter(integerFormat)));
        }
        return this.textFieldTileSize;
    }

    private JFormattedTextField getTextFieldWMSTileSize() {
        if (this.textFieldWMSTileSize == null) {
            NumberFormat integerFormat = NumberFormat.getNumberInstance();
            integerFormat.setParseIntegerOnly(true);
            this.textFieldWMSTileSize = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(integerFormat), new NumberFormatter(integerFormat), new NumberFormatter(integerFormat)));
        }
        return this.textFieldWMSTileSize;
    }

    private JFormattedTextField getTextFieldLevels() {
        if (this.textFieldLevels == null) {
            NumberFormat integerFormat = NumberFormat.getNumberInstance();
            integerFormat.setParseIntegerOnly(true);
            this.textFieldLevels = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(integerFormat), new NumberFormatter(integerFormat), new NumberFormatter(integerFormat)));
        }
        return this.textFieldLevels;
    }

    private JLabel getLabelPath() {
        if (this.labelPath == null) {
            this.labelPath = new JLabel();
        }
        return this.labelPath;
    }

    private JLabel getLabelCacheSize() {
        if (this.labelCacheSize == null) {
            this.labelCacheSize = new JLabel();
        }
        return this.labelCacheSize;
    }

    private JLabel getLabelLevels() {
        if (this.labelLevels == null) {
            this.labelLevels = new JLabel();
        }
        return this.labelLevels;
    }

    private JLabel getLabelStruct() {
        if (this.labelStruct == null) {
            this.labelStruct = new JLabel();
        }
        return this.labelStruct;
    }

    private JLabel getLabelTileSize() {
        if (this.labelTileSize == null) {
            this.labelTileSize = new JLabel();
        }
        return this.labelTileSize;
    }

    private JLabel getLabelWMSTileSize() {
        if (this.labelWMSTileSize == null) {
            this.labelWMSTileSize = new JLabel();
        }
        return this.labelWMSTileSize;
    }

    public void initializeDefaults() {
        this.getTextFieldCacheSize().setValue(Configuration.getDefaultValue("tilecache_size"));
        this.getTextFieldTileSize().setValue(Configuration.getDefaultValue("tilesize"));
        this.getTextFieldWMSTileSize().setValue(Configuration.getDefaultValue("tilesizewms"));
        this.getTextFieldLevels().setValue(Configuration.getDefaultValue("tile_levels"));
        this.getTextFieldPath().setText(Configuration.getDefaultValue("path_tilecache").toString());
        String struct = (String)Configuration.getDefaultValue("cache_struct");
        if (struct != null) {
            for (int i = 0; i < this.getComboBoxStruct().getItemCount(); ++i) {
                if (!this.getComboBoxStruct().getItemAt(i).toString().equals(struct.toString())) continue;
                this.getComboBoxStruct().setSelectedIndex(i);
                break;
            }
        }
    }

    public void initializeValues() {
        this.getTextFieldCacheSize().setValue(Configuration.getValue("tilecache_size", TileCacheLibrary.MAX_CACHE_SIZE));
        this.getTextFieldTileSize().setValue(Configuration.getValue("tilesize", TileCacheLibrary.DEFAULT_TILEWIDTH));
        this.getTextFieldWMSTileSize().setValue(Configuration.getValue("tilesizewms", TILE_SIZE_WMS));
        this.getTextFieldLevels().setValue(Configuration.getValue("tile_levels", TileCacheLibrary.DEFAULT_LEVELS));
        this.getTextFieldPath().setText(Configuration.getValue("path_tilecache", RasterLibrary.pathTileCache));
        String struct = Configuration.getValue("cache_struct", TileCacheLibrary.DEFAULT_STRUCTURE);
        if (struct != null) {
            for (int i = 0; i < this.getComboBoxStruct().getItemCount(); ++i) {
                if (!this.getComboBoxStruct().getItemAt(i).toString().equals(struct.toString())) continue;
                this.getComboBoxStruct().setSelectedIndex(i);
                break;
            }
        }
    }

    public void storeValues() {
        Integer tilecachesize = null;
        try {
            String s = this.getTextFieldCacheSize().getText().replaceAll(",", "");
            tilecachesize = new Integer(s);
            Configuration.setValue("tilecache_size", tilecachesize);
        }
        catch (NumberFormatException s) {
            // empty catch block
        }
        Integer tilesize = null;
        try {
            String s = this.getTextFieldTileSize().getText().replaceAll(",", "");
            tilesize = new Integer(s);
            Configuration.setValue("tilesize", tilesize);
        }
        catch (NumberFormatException s) {
            // empty catch block
        }
        Integer tilesizewms = null;
        try {
            String s = this.getTextFieldWMSTileSize().getText().replaceAll(",", "");
            tilesizewms = new Integer(s);
            Configuration.setValue("tilesizewms", tilesizewms);
        }
        catch (NumberFormatException s) {
            // empty catch block
        }
        Integer tilelevels = null;
        try {
            String s = this.getTextFieldLevels().getText().replaceAll(",", "");
            tilelevels = new Integer(s);
            Configuration.setValue("tile_levels", tilelevels);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Configuration.setValue("cache_struct", this.getComboBoxStruct().getSelectedItem() != null ? this.getComboBoxStruct().getSelectedItem().toString() : TileCacheLibrary.DEFAULT_STRUCTURE);
        Configuration.setValue("path_tilecache", this.getTextFieldPath().getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String path = this.getTextFieldPath().getText();
        IWindow parent = PluginServices.getMDIManager().getActiveWindow();
        IWindow[] wList = PluginServices.getMDIManager().getAllWindows();
        for (int i = 0; i < wList.length; ++i) {
            if (!(wList[i] instanceof DlgPreferences)) continue;
            parent = wList[i];
        }
        if (CacheExtension.messageBoxYesOrNot(Messages.getText((String)"remove_directory") + "<BR>" + path, parent)) {
            File f = new File(path);
            if (f.exists()) {
                if (!this.deleteDirectory(f)) {
                    CacheExtension.messageBoxError("open_files", parent);
                }
            } else {
                CacheExtension.messageBoxError("path_not_exists", parent);
            }
        }
    }

    public boolean deleteDirectory(File directory) {
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.deleteDirectory(files[i]);
                continue;
            }
            files[i].delete();
        }
        return directory.delete();
    }
}

