/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geodb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.util.ContainerUtils;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;
import org.gvsig.tools.util.PropertiesSupport;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableInfo
extends LabeledValueImpl<JDBCStoreParameters>
implements PropertiesSupport {
    protected static final Logger LOGGER = LoggerFactory.getLogger(TableInfo.class);
    private final ListSelectionModel columnChecksModel;
    protected FeatureType featureType;
    protected int geomFieldSelected = -1;
    protected int idFieldSelected = -1;
    protected DefaultComboBoxModel<String> idFieldComboModel;
    protected ComboBoxModel<String> geomFieldComboModel;
    protected List<FeatureAttributeDescriptor> attributeDescriptors;
    protected ListModel<LabeledValue<FeatureAttributeDescriptor>> columnsListModel;
    protected Expression filter;
    protected IProjection projection;
    protected boolean selected;
    protected String documentName;
    protected boolean isView;
    protected Boolean readOnly;
    protected boolean requireGeometry;
    protected Boolean visible;
    protected PropertiesSupportHelper propertiesHelper;
    protected final String id;
    protected String table;
    private final String schema;
    private boolean canLoadAttributeDescriptors = true;

    public TableInfo(String id, JDBCStoreParameters parameters, boolean requireGeometry, boolean isView) {
        super(TableInfo.getLabelForTable(parameters), (Object)parameters.getCopy());
        this.id = id;
        this.columnChecksModel = new DefaultListSelectionModel();
        this.selected = false;
        this.table = parameters.getTable();
        this.schema = parameters.getSchema();
        this.documentName = parameters.getTable();
        this.projection = parameters.getCRS();
        this.isView = isView;
        this.readOnly = null;
        this.requireGeometry = requireGeometry;
        this.propertiesHelper = new PropertiesSupportHelper();
    }

    private static String getLabelForTable(JDBCStoreParameters parameters) {
        String schema = parameters.getSchema();
        String tableName = parameters.getTable();
        if (StringUtils.isBlank((CharSequence)schema)) {
            return tableName;
        }
        return schema + "." + tableName;
    }

    public void fetch(JDBCStoreParameters parameters) {
        this.value = parameters.getCopy();
        this.projection = parameters.getCRS();
        if (this.projection == null) {
            this.setProjectionFromFeatureType();
        }
        String geometryField = parameters.getDefaultGeometryField();
        this.setGeomFieldSelected(geometryField);
        if (geometryField == null) {
            this.geomFieldComboModel = null;
            this.getGeomFieldComboModel();
        }
        this.filter = StringUtils.isBlank((CharSequence)parameters.getBaseFilter()) ? null : ExpressionUtils.createExpression((String)parameters.getBaseFilter());
        if (StringUtils.isBlank((CharSequence)parameters.getPkFieldsString())) {
            this.idFieldComboModel = null;
            this.getIdFieldComboModel();
        } else {
            this.setIdFieldSelected(parameters.getPkFieldsString());
            if (this.getIdFieldSelected() < 0 && StringUtils.contains((CharSequence)parameters.getPkFieldsString(), (int)44)) {
                this.idFieldComboModel.addElement(parameters.getPkFieldsString());
                this.idFieldSelected = this.idFieldComboModel.getSize() - 1;
            }
        }
        String[] fieldsArray = parameters.getFields();
        if (fieldsArray == null) {
            this.columnChecksModel.setSelectionInterval(0, this.getColumnsListModel().getSize() - 1);
        } else {
            ListModel<LabeledValue<FeatureAttributeDescriptor>> model = this.getColumnsListModel();
            List<String> fields = Arrays.asList(fieldsArray);
            this.columnChecksModel.clearSelection();
            for (int i = 0; i < model.getSize(); ++i) {
                FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)model.getElementAt(i).getValue();
                if (!ContainerUtils.contains(fields, (Object)attr.getName(), (Comparator)ContainerUtils.EQUALS_IGNORECASE_COMPARATOR)) continue;
                this.columnChecksModel.addSelectionInterval(i, i);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public void setDocumentName(String name) {
        this.documentName = name;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.fetchFromStore();
        this.selected = selected;
    }

    public ListSelectionModel getColumnChecksModel() {
        return this.columnChecksModel;
    }

    public JDBCStoreParameters getParameters() {
        JDBCStoreParameters p = (JDBCStoreParameters)this.getValue();
        List<FeatureAttributeDescriptor> attributes = this.getAttributeDescriptors();
        if (attributes != null) {
            StringBuilder fields = new StringBuilder();
            boolean allSelected = true;
            for (int i = 0; i < attributes.size(); ++i) {
                if (this.columnChecksModel.isSelectedIndex(i)) {
                    if (fields.length() > 0) {
                        fields.append(",");
                    }
                    fields.append(attributes.get(i).getName());
                    continue;
                }
                allSelected = false;
            }
            if (!allSelected) {
                p.setFields(fields.toString());
            }
        }
        if (this.idFieldSelected >= 0) {
            p.setPkFields(this.getFieldId());
        }
        p.setCRS(this.getProjection());
        p.setDefaultGeometryField(this.getGeomField());
        if (!ExpressionUtils.isEmpty((Expression)this.filter)) {
            p.setBaseFilter(this.filter.getPhrase());
        } else {
            p.setBaseFilter(null);
        }
        return p;
    }

    public void setProjection(IProjection projection) {
        this.projection = projection;
    }

    public IProjection getProjection() {
        return this.projection;
    }

    public String getFieldId() {
        if (this.idFieldSelected < 0) {
            return null;
        }
        return (String)this.getIdFieldComboModel().getElementAt(this.idFieldSelected);
    }

    public String getGeomField() {
        if (this.geomFieldSelected < 0) {
            return null;
        }
        return (String)this.geomFieldComboModel.getElementAt(this.geomFieldSelected);
    }

    public FeatureType getFeatureType() {
        if (this.featureType == null) {
            this.fetchFromStore();
        }
        return this.featureType;
    }

    public String getTable() {
        return this.table;
    }

    public String getSchema() {
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchFromStore() {
        DataManager dataManager = DALLocator.getDataManager();
        if (this.featureType != null) {
            return;
        }
        FeatureStore store = null;
        try {
            JDBCStoreParameters params = (JDBCStoreParameters)this.getValue();
            store = (FeatureStore)dataManager.openStore(params.getDataStoreName(), (DataStoreParameters)params);
            this.featureType = store.getDefaultFeatureType();
            this.table = this.featureType.getTags().getString("Layer.name", this.table);
            this.setProjectionFromFeatureType();
            if (this.readOnly == null) {
                this.readOnly = !store.allowWrite();
            }
            this.getGeomFieldComboModel();
            this.getIdFieldComboModel();
            DisposeUtils.disposeQuietly((Disposable)store);
        }
        catch (Exception ex) {
            LOGGER.trace("Can't get feature type.", (Throwable)ex);
        }
        finally {
            DisposeUtils.disposeQuietly(store);
        }
    }

    private void setProjectionFromFeatureType() {
        if (this.featureType == null) {
            return;
        }
        FeatureAttributeDescriptor attr = this.featureType.getDefaultGeometryAttribute();
        if (attr != null) {
            GeometryType geomType = attr.getGeomType();
            if (geomType != null) {
                if (this.getGeometryType() == -1) {
                    this.setGeometryType(geomType.getType());
                }
                if (this.getGeometrySubtype() == 4) {
                    this.setGeometrySubtype(geomType.getSubType());
                }
            }
            if (this.getProjection() == null) {
                this.setProjection(attr.getSRS());
            }
        }
    }

    public ComboBoxModel getGeomFieldComboModel() {
        if (this.geomFieldComboModel == null) {
            DefaultComboBoxModel<String> geomModel = new DefaultComboBoxModel<String>();
            geomModel.addElement(" ");
            int geomIndex = -1;
            List<FeatureAttributeDescriptor> attributes = this.getAttributeDescriptors();
            if (attributes != null) {
                int n = 1;
                for (FeatureAttributeDescriptor attr : attributes) {
                    int dataType;
                    if (geomIndex < 0 && attr.getType() == 66) {
                        geomIndex = n;
                    }
                    if ((dataType = attr.getType()) != 66 && dataType != 12 && dataType != 8) continue;
                    geomModel.addElement(attr.getName());
                    ++n;
                }
                if (geomIndex < 0) {
                    geomIndex = 0;
                }
            }
            this.geomFieldComboModel = geomModel;
            this.geomFieldSelected = geomIndex;
        }
        return this.geomFieldComboModel;
    }

    public int getGeomFieldSelected() {
        return this.geomFieldSelected;
    }

    public ComboBoxModel<String> getIdFieldComboModel() {
        if (this.idFieldComboModel == null) {
            DefaultComboBoxModel<String> idsModel = new DefaultComboBoxModel<String>();
            int idsIndex = -1;
            List<FeatureAttributeDescriptor> attributes = this.getAttributeDescriptors();
            if (attributes != null) {
                StringBuilder pkName = new StringBuilder();
                for (FeatureAttributeDescriptor attr : attributes) {
                    if (!attr.isPrimaryKey()) continue;
                    if (!StringUtils.isBlank((CharSequence)pkName)) {
                        pkName.append(",");
                    }
                    pkName.append(attr.getName());
                }
                idsModel.addElement(" ");
                int n = 1;
                if (!StringUtils.isBlank((CharSequence)pkName) && StringUtils.contains((CharSequence)pkName, (CharSequence)",")) {
                    idsModel.addElement(pkName.toString());
                    idsIndex = n++;
                }
                for (FeatureAttributeDescriptor attr : attributes) {
                    if (idsIndex < 0 && attr.isPrimaryKey()) {
                        idsIndex = n;
                    }
                    idsModel.addElement(attr.getName());
                    ++n;
                }
                if (idsIndex < 0) {
                    idsIndex = 0;
                }
            }
            this.idFieldComboModel = idsModel;
            this.idFieldSelected = idsIndex;
        }
        return this.idFieldComboModel;
    }

    public List<FeatureAttributeDescriptor> getAttributeDescriptors() {
        if (this.attributeDescriptors == null && this.canLoadAttributeDescriptors) {
            try {
                ArrayList<FeatureAttributeDescriptor> attrs = new ArrayList<FeatureAttributeDescriptor>();
                for (FeatureAttributeDescriptor attr : this.getFeatureType()) {
                    attrs.add(attr);
                }
                attrs.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
                this.columnChecksModel.setSelectionInterval(0, attrs.size());
                this.attributeDescriptors = attrs;
            }
            catch (Exception ex) {
                LOGGER.warn("Can't get attribute descriptors", (Throwable)ex);
                this.canLoadAttributeDescriptors = false;
            }
        }
        return this.attributeDescriptors;
    }

    public ListModel<LabeledValue<FeatureAttributeDescriptor>> getColumnsListModel() {
        if (this.columnsListModel == null) {
            DefaultListModel<LabeledValue<FeatureAttributeDescriptor>> model = new DefaultListModel<LabeledValue<FeatureAttributeDescriptor>>();
            for (FeatureAttributeDescriptor attr : this.getAttributeDescriptors()) {
                model.addElement((LabeledValue<FeatureAttributeDescriptor>)new LabeledValueImpl(attr.getName() + " [" + attr.getDataTypeName() + "]", (Object)attr));
            }
            this.columnsListModel = model;
        }
        return this.columnsListModel;
    }

    public FeatureAttributeDescriptor getAttributeDescriptor(String attrName) {
        return this.getFeatureType().getAttributeDescriptor(attrName);
    }

    public int getIdFieldSelected() {
        return this.idFieldSelected;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public void setFilter(Expression filter) {
        this.filter = filter;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    void setIdFieldSelected(int selectedIndex) {
        this.idFieldSelected = selectedIndex;
    }

    void setIdFieldSelected(String selected) {
        ComboBoxModel<String> model = this.getIdFieldComboModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)selected, (CharSequence)((CharSequence)model.getElementAt(i)))) continue;
            this.idFieldSelected = i;
            return;
        }
        this.idFieldSelected = -1;
    }

    void setGeomFieldSelected(int selectedIndex) {
        this.geomFieldSelected = selectedIndex;
    }

    void setGeomFieldSelected(String selected) {
        ComboBoxModel model = this.getGeomFieldComboModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)selected, (CharSequence)((CharSequence)model.getElementAt(i)))) continue;
            this.geomFieldSelected = i;
            return;
        }
        this.geomFieldSelected = -1;
    }

    public boolean requireGeometry() {
        return this.requireGeometry;
    }

    public boolean hasValidValues() {
        if (this.getGeomFieldSelected() < 0 && this.requireGeometry()) {
            return false;
        }
        if (this.requireGeometry()) {
            FeatureType featType = this.getFeatureType();
            if (StringUtils.isBlank((CharSequence)this.getGeomField())) {
                return false;
            }
            if (this.getGeometryType() == 16 || this.getGeometryType() == -1) {
                return false;
            }
            if (this.getGeometrySubtype() == 4) {
                return false;
            }
        }
        JDBCStoreParameters p = this.getParameters();
        try {
            p.validate();
            return true;
        }
        catch (ValidateDataParametersException ex) {
            return false;
        }
    }

    public boolean isView() {
        return this.isView;
    }

    public boolean isReadOnly() {
        if (this.readOnly == null) {
            this.fetchFromStore();
        }
        return this.readOnly;
    }

    public Object getProperty(String name) {
        return this.propertiesHelper.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.propertiesHelper.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesHelper.getProperties();
    }

    protected JDBCServerExplorer getExplorer() throws DataException, ValidateDataParametersException {
        DataManager manager = DALLocator.getDataManager();
        JDBCStoreParameters storeParameters = this.getParameters();
        DataServerExplorerParameters explorerParameters = manager.createServerExplorerParameters(storeParameters.getProviderName());
        ToolsLocator.getDynObjectManager().copy((DynObject)storeParameters, (DynObject)explorerParameters);
        DataServerExplorer explorer = manager.openServerExplorer(storeParameters.getProviderName(), explorerParameters);
        return (JDBCServerExplorer)explorer;
    }

    public boolean existsDALInfo() {
        try {
            JDBCStoreParameters storeParameters = this.getParameters();
            JDBCServerExplorer explorer = this.getExplorer();
            ResourcesStorage resources = explorer.getResourcesStorage((DataStoreParameters)storeParameters);
            return resources.exists("dal");
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void removeDALInfo() {
        try {
            JDBCStoreParameters storeParameters = this.getParameters();
            JDBCServerExplorer explorer = this.getExplorer();
            ResourcesStorage resources = explorer.getResourcesStorage((DataStoreParameters)storeParameters);
            if (resources.exists("dal")) {
                resources.remove("dal");
                JDBCStoreParameters params = explorer.get(storeParameters.getTable());
                this.value = params;
                this.featureType = null;
            }
            DisposeUtils.disposeQuietly((Disposable)explorer);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't remove DAL resource.", ex);
        }
    }

    public int getGeometryType() {
        return ((JDBCStoreParameters)this.getValue()).getGeometryType();
    }

    public int getGeometrySubtype() {
        return ((JDBCStoreParameters)this.getValue()).getGeometrySubtype();
    }

    public void setGeometryType(int geomType) {
        ((JDBCStoreParameters)this.getValue()).setGeometryType(geomType);
    }

    public void setGeometrySubtype(int geomSubtype) {
        ((JDBCStoreParameters)this.getValue()).setGeometrySubtype(geomSubtype);
    }
}

