/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geodb.databaseworkspace;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanel;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanelManager;
import org.gvsig.fmap.dal.swing.searchpanel.FeatureStoreSearchPanel;
import org.gvsig.geodb.databaseworkspace.RepositoryAddTablePanel;
import org.gvsig.geodb.databaseworkspace.WorkspaceConfigurationPanelView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.LabeledValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceConfigurationPanel
extends WorkspaceConfigurationPanelView
implements org.gvsig.tools.swing.api.Component {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkspaceConfigurationPanel.class);
    private FeatureStoreSearchPanel configurationSearch;
    private FeatureStoreSearchPanel repositorySearch;
    private FeatureStoreSearchPanel resourcesSearch;
    private TableController resourcesTableController;
    private TableController repositoryTableController;
    private TableController configurationTableController;
    private PickerController<JDBCServerExplorerParameters> connectionPicker;

    public WorkspaceConfigurationPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.connectionPicker = DALSwingLocator.getSwingManager().createJDBCConnectionPickerController(this.cboConnections, this.btnAddConnection);
        this.connectionPicker.addChangeListener(e -> {
            this.doUpdateEnableComponents();
            this.doUpdateStoresRepositoryInfo();
        });
        this.resourcesTableController = new TableController(0, this.btnCreateResourceTable, this.btnDropResourceTable, this.btnShowResourceTable);
        this.repositoryTableController = new TableController(1, this.btnCreateRepositoryTable, this.btnDropRepositoryTable, this.btnShowRepositoryTable);
        this.configurationTableController = new TableController(2, this.btnCreateConfigurationTable, this.btnDropConfigurationTable, this.btnShowConfigurationTable);
        this.btnRepositoryAddTable.addActionListener(e -> this.doAddTableToRepository());
        this.btnConnectToRepository.addActionListener(e -> this.doConnectToRepository());
        this.btnShowRepositoryTableParameters.addActionListener(e -> this.doShowParametersOfRepositoryTable());
        this.btnFixRepositoryEntries.addActionListener(e -> this.doFixRepositoryEntriesToSelectedConnection());
        this.pnlConfiguration.setLayout(new BorderLayout());
        this.pnlRepository.setLayout(new BorderLayout());
        this.pnlResorces.setLayout(new BorderLayout());
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)20, (int)150, (int)25, (int)200);
        this.doUpdateEnableComponents();
    }

    public JComponent asJComponent() {
        return this;
    }

    public JDBCServerExplorerParameters getConnection() {
        JDBCServerExplorerParameters conn = (JDBCServerExplorerParameters)this.connectionPicker.get();
        return conn;
    }

    private void doUpdateEnableComponents() {
        boolean theEnabled = this.getConnection() != null;
        this.repositoryTableController.setEnabled(theEnabled);
        this.resourcesTableController.setEnabled(theEnabled);
        this.configurationTableController.setEnabled(theEnabled);
        this.btnRepositoryAddTable.setEnabled(theEnabled);
        this.btnConnectToRepository.setEnabled(theEnabled);
    }

    private void doAddTableToRepository() {
        final RepositoryAddTablePanel panel = new RepositoryAddTablePanel();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        final Dialog dialog = winManager.createDialog((JComponent)panel, "Add table to repository", null, 3);
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dialog.getAction() == 1) {
                    DataManager dataManager = DALLocator.getDataManager();
                    DatabaseWorkspaceManager workspace = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)WorkspaceConfigurationPanel.this.getConnection());
                    for (LabeledValue<DataStoreParameters> p : panel.getDataStoreParameters()) {
                        if (p == null || workspace.writeStoresRepositoryEntry(p.getLabel(), (DataStoreParameters)p.getValue())) continue;
                        LOGGER.warn("Can't add table '" + p.getLabel() + "' to repository");
                    }
                }
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    private void doUpdateStoresRepositoryInfo() {
        DataManager dataManager = DALLocator.getDataManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        DatabaseWorkspaceManager workspace = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)this.getConnection());
        String id = workspace.get("StoresRepository.id");
        String label = workspace.get("StoresRepository.label");
        this.txtStoresRepositoryId.setText((String)StringUtils.defaultIfBlank((CharSequence)id, (CharSequence)""));
        this.txtStoresRepositoryLabel.setText((String)StringUtils.defaultIfBlank((CharSequence)label, (CharSequence)""));
        this.btnConnectToRepository.setEnabled(!StringUtils.isBlank((CharSequence)id));
        try {
            this.pnlConfiguration.removeAll();
            this.configurationSearch = dataSwingManager.createFeatureStoreSearchPanel(workspace.getTable(2));
            this.pnlConfiguration.add((Component)this.configurationSearch.asJComponent(), "Center");
            this.configurationSearch.setFilterOnlyMode(true);
            this.configurationSearch.setShowActions(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.pnlRepository.removeAll();
            this.repositorySearch = dataSwingManager.createFeatureStoreSearchPanel(workspace.getTable(1));
            this.pnlRepository.add((Component)this.repositorySearch.asJComponent(), "Center");
            this.repositorySearch.setFilterOnlyMode(true);
            this.repositorySearch.setShowActions(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.pnlResorces.removeAll();
            this.resourcesSearch = dataSwingManager.createFeatureStoreSearchPanel(workspace.getTable(0));
            this.resourcesSearch.setFilterOnlyMode(true);
            this.resourcesSearch.setShowActions(false);
            this.pnlResorces.add((Component)this.resourcesSearch.asJComponent(), "Center");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.invalidate();
    }

    private void doConnectToRepository() {
        DataManager dataManager = DALLocator.getDataManager();
        DatabaseWorkspaceManager workspace = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)this.getConnection());
        StoresRepository repo = workspace.getStoresRepository();
        dataManager.getStoresRepository().addRepository(repo);
    }

    private void doShowParametersOfRepositoryTable() {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            DataStoreParametersPanelManager manager = DALSwingLocator.getDataStoreParametersPanelManager();
            FeatureStore store = this.repositorySearch.getStore();
            Feature f = store.findFirst(this.repositorySearch.getFilterForSelectedFeature());
            if (f == null) {
                return;
            }
            String name = f.getString("name");
            DatabaseWorkspaceManager workspace = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)this.getConnection());
            StoresRepository repository = workspace.getStoresRepository();
            DataStoreParameters parameters = (DataStoreParameters)repository.get((Object)name);
            DataStoreParametersPanel panel = manager.createDataStoreParametersPanel((DynObject)parameters);
            Dialog dialog = manager.createPropertiesDialog((DynObject)parameters, panel);
            dialog.addActionListener(ae -> {
                switch (ae.getID()) {
                    case 4: {
                        manager.showAdvancedPropertiesDialog((DynObject)parameters);
                        break;
                    }
                    case 1: {
                        panel.fetchParameters((DynObject)parameters);
                        workspace.writeStoresRepositoryEntry(name, parameters);
                        break;
                    }
                }
            });
            dialog.show(WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show parameters of repository table", (Throwable)ex);
        }
    }

    private void doFixRepositoryEntriesToSelectedConnection() {
        DataManager dataManager = DALLocator.getDataManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        JDBCServerExplorerParameters conn = this.getConnection();
        DatabaseWorkspaceManager workspace = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)conn);
        StoresRepository repository = workspace.getStoresRepository();
        int n = 0;
        for (String name : repository.keySet()) {
            DataStoreParameters params = (DataStoreParameters)repository.get((Object)name);
            if (!(params instanceof JDBCStoreParameters)) continue;
            ((JDBCStoreParameters)params).setHost(conn.getHost());
            ((JDBCStoreParameters)params).setPort(conn.getPort());
            ((JDBCStoreParameters)params).setSchema(conn.getSchema());
            ((JDBCStoreParameters)params).setDBName(conn.getDBName());
            ((JDBCStoreParameters)params).setCatalog(conn.getCatalog());
            ((JDBCStoreParameters)params).setUser(conn.getUser());
            ((JDBCStoreParameters)params).setPassword(conn.getPassword());
            ((JDBCStoreParameters)params).setUrl(null);
            workspace.writeStoresRepositoryEntry(name, params);
            ++n;
        }
        ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog("Total updateds entries " + n, i18n.getTranslation("_Manage_Dabatase_workspace"), 1);
    }

    private class TableController {
        private final JButton btnCreate;
        private final JButton btnDrop;
        private final JButton btnShowForm;
        private final int tableid;

        public TableController(int tableid, JButton btnCreate, JButton btnDrop, JButton btnShowForm) {
            this.tableid = tableid;
            this.btnCreate = btnCreate;
            this.btnDrop = btnDrop;
            this.btnShowForm = btnShowForm;
            this.btnCreate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableController.this.doCreate();
                }
            });
            this.btnDrop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableController.this.doDrop();
                }
            });
            this.btnShowForm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableController.this.doShowForm();
                }
            });
        }

        private void doCreate() {
            DataManager dataManager = DALLocator.getDataManager();
            DatabaseWorkspaceManager workspace = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)WorkspaceConfigurationPanel.this.getConnection());
            if (workspace.existsTable(this.tableid)) {
                return;
            }
            workspace.createTable(this.tableid);
        }

        private void doShowForm() {
            try {
                DataManager dataManager = DALLocator.getDataManager();
                DatabaseWorkspaceManager workspace = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)WorkspaceConfigurationPanel.this.getConnection());
                if (!workspace.existsTable(this.tableid)) {
                    return;
                }
                FeatureStore store = workspace.getTable(this.tableid);
                DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
                JFeaturesForm form = dalSwingManager.createJFeaturesForm(store);
                WindowManager winManager = ToolsSwingLocator.getWindowManager();
                winManager.showWindow(form.asJComponent(), "Resources", WindowManager.MODE.WINDOW);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't show form of resources table.", (Throwable)ex);
            }
        }

        private void doDrop() {
            DataManager dataManager = DALLocator.getDataManager();
            DatabaseWorkspaceManager workspace = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)WorkspaceConfigurationPanel.this.getConnection());
            if (!workspace.existsTable(this.tableid)) {
                return;
            }
            workspace.dropTable(this.tableid);
        }

        public void setEnabled(boolean enabled) {
            this.btnCreate.setEnabled(enabled);
            this.btnDrop.setEnabled(enabled);
            this.btnShowForm.setEnabled(enabled);
        }
    }
}

