/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wms;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.gvsig.remoteclient.utils.Utilities;
import org.gvsig.remoteclient.wms.WMSProtocolHandler;
import org.kxml2.io.KXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public class WMSProtocolHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(WMSProtocolHandlerFactory.class);
    public WMSProtocolHandler wMSProtocolHandler;
    private static ArrayList supportedVersions = new ArrayList();

    private static String getDriverVersion(String version, Iterator clients) throws InstantiationException, IllegalAccessException {
        while (clients.hasNext()) {
            String clientVersion = (String)clients.next();
            int ret = version.compareTo(clientVersion);
            if (ret < 0) continue;
            return clientVersion;
        }
        return null;
    }

    public static WMSProtocolHandler negotiate(String host) throws ConnectException, IOException {
        if (supportedVersions.size() == 0) {
            return null;
        }
        try {
            String highestVersionSupportedByServer = WMSProtocolHandlerFactory.getSuitableWMSVersion(host, "");
            if (supportedVersions.contains(highestVersionSupportedByServer)) {
                return WMSProtocolHandlerFactory.createVersionDriver(highestVersionSupportedByServer);
            }
            Iterator iVersion = supportedVersions.iterator();
            while (iVersion.hasNext()) {
                String gvSIGVersion = (String)iVersion.next();
                String wmsVersion = WMSProtocolHandlerFactory.getSuitableWMSVersion(host, gvSIGVersion);
                int res = wmsVersion.compareTo(gvSIGVersion);
                if (res == 0) {
                    return WMSProtocolHandlerFactory.createVersionDriver(gvSIGVersion);
                }
                if (res > 0) {
                    throw new Exception("Server Version too high: " + wmsVersion);
                }
                String lowerVersion = WMSProtocolHandlerFactory.getDriverVersion(wmsVersion, iVersion);
                if (lowerVersion == null) {
                    throw new Exception("Lowest server version is " + wmsVersion);
                }
                if (!lowerVersion.equals(wmsVersion)) continue;
                return WMSProtocolHandlerFactory.createVersionDriver(lowerVersion);
            }
            return null;
        }
        catch (ConnectException conEx) {
            throw conEx;
        }
        catch (IOException ioEx) {
            throw ioEx;
        }
        catch (Exception e) {
            logger.warn("Can't determine server version", (Throwable)e);
            return null;
        }
    }

    private static String getSuitableWMSVersion(String host, String _version) throws ConnectException, IOException {
        int[] sizes = new int[]{1024, 10240, 51200, 102400};
        XmlPullParserException xmlEx = null;
        for (int i = 0; i < sizes.length; ++i) {
            try {
                String version = WMSProtocolHandlerFactory.getSuitableWMSVersion(host, _version, sizes[i]);
                return version;
            }
            catch (XmlPullParserException ex) {
                xmlEx = ex;
                continue;
            }
        }
        logger.warn("Can't determine server version", xmlEx);
        return "";
    }

    private static String readFromUrl(String url_s, int size) throws IOException {
        URL url = new URL(url_s);
        Utilities.removeURL((URL)url);
        File f = Utilities.downloadFile((URL)url, (String)"wms_capabilities.xml", null);
        return FileUtils.readFileToString((File)f);
    }

    private static String getSuitableWMSVersion(String host, String _version, int size) throws ConnectException, IOException, XmlPullParserException {
        String request = WMSProtocolHandler.buildCapabilitiesSuitableVersionRequest(host, _version);
        String version = new String();
        StringReader reader = null;
        try {
            String string = WMSProtocolHandlerFactory.readFromUrl(request, size);
            int a = string.toLowerCase().indexOf("<?xml");
            if (a != -1) {
                string = string.substring(a, string.length());
            }
            reader = new StringReader(string);
            KXmlParser kxmlParser = null;
            kxmlParser = new KXmlParser();
            kxmlParser.setInput((Reader)reader);
            kxmlParser.nextTag();
            if (kxmlParser.getEventType() != 1 && (kxmlParser.getName().compareTo("WMT_MS_Capabilities") == 0 || kxmlParser.getName().compareTo("WMT_MS_Capabilities") == 0 || kxmlParser.getName().compareTo("WMS_Capabilities") == 0)) {
                version = kxmlParser.getAttributeValue("", "version");
            }
            reader.close();
            reader = null;
            String string2 = version;
            return string2;
        }
        catch (ConnectException conEx) {
            throw new ConnectException(conEx.getMessage());
        }
        catch (IOException ioEx) {
            throw new IOException(ioEx.getMessage());
        }
        catch (XmlPullParserException xmlEx) {
            throw xmlEx;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {
                    logger.warn("Can't close reader", (Throwable)ex);
                }
            }
        }
    }

    private static WMSProtocolHandler createVersionDriver(String version) {
        try {
            version = version.replace('.', '_');
            Class<?> driver = Class.forName("org.gvsig.remoteclient.wms.wms_" + version + ".WMSProtocolHandler" + version);
            return (WMSProtocolHandler)((Object)driver.newInstance());
        }
        catch (Exception e) {
            logger.warn("Can't create WMS protocol handler for version '" + version + "'.", (Throwable)e);
            return null;
        }
    }

    static {
        supportedVersions.add("1.3.0");
        supportedVersions.add("1.1.1");
        supportedVersions.add("1.1.0");
    }
}

