/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wms.wms_1_3_0;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.lang.StringUtils;
import org.gvsig.remoteclient.utils.BoundaryBox;
import org.gvsig.remoteclient.utils.Utilities;
import org.gvsig.remoteclient.wms.WMSDimension;
import org.gvsig.remoteclient.wms.WMSLayer;
import org.gvsig.remoteclient.wms.wms_1_3_0.WMSStyle1_3_0;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class WMSLayer1_3_0
extends WMSLayer {
    private static final StringUtils stringUtils = CompatLocator.getStringUtils();

    @Override
    public ArrayList getDimensions() {
        ArrayList myDimensions = (ArrayList)this.dimensions.clone();
        if (this.parent != null) {
            ArrayList pDimensions = this.parent.getDimensions();
            for (int i = 0; i < pDimensions.size(); ++i) {
                WMSDimension pDimension = (WMSDimension)pDimensions.get(i);
                WMSDimension myDimension = this.getDimension(pDimension.getName());
                if (myDimension == null) continue;
                pDimensions.remove(pDimension);
            }
            myDimensions.addAll(pDimensions);
        }
        return myDimensions;
    }

    public WMSLayer1_3_0() {
        this.children = new ArrayList();
    }

    @Override
    public void parse(KXmlParser parser, TreeMap layerTreeMap) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "Layer");
        this.readLayerAttributes(parser);
        int currentTag = parser.nextTag();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    BoundaryBox bbox;
                    String value;
                    if (parser.getName().compareTo("Layer") == 0) {
                        WMSLayer1_3_0 lyr = new WMSLayer1_3_0();
                        lyr.parse(parser, layerTreeMap);
                        lyr.setParent(this);
                        this.children.add(lyr);
                        if (lyr.getName() == null) break;
                        layerTreeMap.put(lyr.getName(), lyr);
                        break;
                    }
                    if (parser.getName().compareTo("Attribution") == 0) {
                        parser.skipSubTree();
                        break;
                    }
                    if (parser.getName().compareTo("Name") == 0) {
                        value = parser.nextText();
                        if (value == null) break;
                        this.setName(value);
                        break;
                    }
                    if (parser.getName().compareTo("Title") == 0) {
                        value = parser.nextText();
                        if (value == null) break;
                        this.setTitle(value);
                        break;
                    }
                    if (parser.getName().compareTo("Abstract") == 0) {
                        value = parser.nextText();
                        if (value == null) break;
                        this.setAbstract(value);
                        break;
                    }
                    if (parser.getName().compareTo("CRS") == 0) {
                        value = parser.nextText();
                        if (value == null) break;
                        String[] mySRSs = stringUtils.split(value, " ");
                        for (int i = 0; i < mySRSs.length; ++i) {
                            this.addSrs(mySRSs[i]);
                        }
                        break;
                    }
                    if (parser.getName().compareTo("BoundingBox") == 0) {
                        bbox = new BoundaryBox();
                        value = parser.getAttributeValue("", "CRS");
                        if (value != null) {
                            bbox.setSrs(value);
                        }
                        if ((value = parser.getAttributeValue("", "minx")) != null && Utilities.isNumber((String)value)) {
                            bbox.setXmin(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "miny")) != null && Utilities.isNumber((String)value)) {
                            bbox.setYmin(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "maxx")) != null && Utilities.isNumber((String)value)) {
                            bbox.setXmax(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "maxy")) != null && Utilities.isNumber((String)value)) {
                            bbox.setYmax(Double.parseDouble(value));
                        }
                        this.addBBox(bbox);
                        this.addSrs(bbox.getSrs());
                        break;
                    }
                    if (parser.getName().compareTo("EX_GeographicBoundingBox") == 0) {
                        bbox = this.parseEXGeographicBBTag(parser);
                        this.addBBox(bbox);
                        this.setLatLonBox(bbox);
                        this.addSrs(bbox.getSrs());
                        break;
                    }
                    if (parser.getName().compareTo("ScaleHint") == 0) {
                        value = parser.getAttributeValue("", "min");
                        if (value != null && Utilities.isNumber((String)value)) {
                            this.setScaleMin(Double.parseDouble(value));
                        }
                        if ((value = parser.getAttributeValue("", "max")) == null || !Utilities.isNumber((String)value)) break;
                        this.setScaleMax(Double.parseDouble(value));
                        break;
                    }
                    if (parser.getName().compareTo("Style") == 0) {
                        WMSStyle1_3_0 style = new WMSStyle1_3_0();
                        style.parse(parser);
                        if (style == null || style.getName() == null) break;
                        this.styles.add(style);
                        break;
                    }
                    if (parser.getName().compareTo("Dimension") == 0) {
                        WMSDimension dim = new WMSDimension();
                        dim.parse(parser);
                        if (dim == null || dim.getName() == null) break;
                        this.addDimension(dim);
                        break;
                    }
                    if (parser.getName().compareTo("KeywordList") != 0) break;
                    this.parseKeywordList(parser);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Layer") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
        parser.require(3, null, "Layer");
    }

    private BoundaryBox parseEXGeographicBBTag(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        BoundaryBox bbox = new BoundaryBox();
        parser.require(2, null, "EX_GeographicBoundingBox");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    String value;
                    if (parser.getName().compareTo("westBoundLongitude") == 0) {
                        value = parser.nextText();
                        if (value == null || !Utilities.isNumber((String)value)) break;
                        bbox.setXmin(Double.parseDouble(value));
                        break;
                    }
                    if (parser.getName().compareTo("eastBoundLongitude") == 0) {
                        value = parser.nextText();
                        if (value == null || !Utilities.isNumber((String)value)) break;
                        bbox.setXmax(Double.parseDouble(value));
                        break;
                    }
                    if (parser.getName().compareTo("northBoundLatitude") == 0) {
                        value = parser.nextText();
                        if (value == null || !Utilities.isNumber((String)value)) break;
                        bbox.setYmax(Double.parseDouble(value));
                        break;
                    }
                    if (parser.getName().compareTo("southBoundLatitude") != 0 || (value = parser.nextText()) == null || !Utilities.isNumber((String)value)) break;
                    bbox.setYmin(Double.parseDouble(value));
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("EX_GeographicBoundingBox") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
        parser.require(3, null, "EX_GeographicBoundingBox");
        bbox.setSrs("CRS:84");
        return bbox;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

