/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.dwg.lib.DwgHandleReference;

public class DwgObject
implements Cloneable {
    protected int type;
    protected DwgHandleReference handle;
    protected String version;
    protected int mode;
    protected DwgHandleReference layerHandle;
    protected int color;
    protected int numReactors;
    protected boolean noLinks;
    protected int linetypeFlags;
    protected int plotstyleFlags;
    protected int sizeInBits;
    protected List extendedData;
    protected int graphicData;
    protected int address;
    protected DwgHandleReference plotStyleHandle = null;
    protected DwgHandleReference subEntityHandle = null;
    protected DwgHandleReference xDicObjHandle = null;
    protected boolean graphicsFlag;
    protected boolean xDicObjFlag;
    protected boolean avanzarFlag = false;
    protected int index = 0;
    private DwgHandleReference nextHandle = null;
    private DwgHandleReference previousHandle = null;
    private ArrayList reactorsHandles = new ArrayList();
    private boolean insertar = false;
    private boolean lyrByLineType = false;
    private DwgHandleReference lineTypeHandle = null;

    public DwgObject(int index) {
        this.index = index;
    }

    public void inserta() {
        this.insertar = true;
    }

    public boolean insertar() {
        return this.insertar;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public int getAddress() {
        return this.address;
    }

    public void setNextHandle(DwgHandleReference hr) {
        this.nextHandle = hr;
    }

    public void setPreviousHandle(DwgHandleReference hr) {
        this.previousHandle = hr;
    }

    public void setAvanzar(boolean avanza) {
        this.avanzarFlag = avanza;
    }

    public boolean getAvanzar() {
        return this.avanzarFlag;
    }

    public void addReactorHandle(DwgHandleReference hr) {
        if (this.reactorsHandles == null) {
            this.reactorsHandles = new ArrayList();
        }
        this.reactorsHandles.add(hr);
    }

    public DwgHandleReference getNextHandle() {
        return this.nextHandle;
    }

    public DwgHandleReference getPreviousHandle() {
        return this.previousHandle;
    }

    public ArrayList getReactorsHandles() {
        return this.reactorsHandles;
    }

    public boolean hasLayerHandle() {
        return this.layerHandle != null;
    }

    public boolean hasNextHandle() {
        return this.nextHandle != null;
    }

    public boolean hasPreviousHandle() {
        return this.previousHandle != null;
    }

    public boolean hasSubEntityHandle() {
        return this.subEntityHandle != null;
    }

    public boolean hasXDicObjHandle() {
        return this.xDicObjHandle != null;
    }

    public boolean hasReactorsHandles() {
        return this.reactorsHandles.size() != 0;
    }

    public int reactorsHandlesQuantity() {
        return this.reactorsHandles.size();
    }

    public int getIndex() {
        return this.index;
    }

    public int getSizeInBits() {
        return this.sizeInBits;
    }

    public void setSizeInBits(int sizeInBits) {
        this.sizeInBits = sizeInBits;
    }

    public List getExtendedData() {
        return this.extendedData;
    }

    public void setExtendedData(List extData) {
        this.extendedData = extData;
    }

    public int getGraphicData() {
        return this.graphicData;
    }

    public void setGraphicData(int graphicData) {
        this.graphicData = graphicData;
    }

    public String getVersion() {
        return this.version;
    }

    public void setLinetypeFlags(int linetypeFlags) {
        this.linetypeFlags = linetypeFlags;
    }

    public void setPlotstyleFlags(int plotstyleFlags) {
        this.plotstyleFlags = plotstyleFlags;
    }

    public DwgHandleReference getSubEntityHandle() {
        return this.subEntityHandle;
    }

    public void setSubEntityHandle(DwgHandleReference subEntityHandle) {
        this.subEntityHandle = subEntityHandle;
    }

    public DwgHandleReference getXDicObjHandle() {
        return this.xDicObjHandle;
    }

    public void setXDicObjHandle(DwgHandleReference dicObjHandle) {
        this.xDicObjHandle = dicObjHandle;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public DwgHandleReference getHandle() {
        return this.handle;
    }

    public void setHandle(DwgHandleReference handle) {
        this.handle = handle;
    }

    public DwgHandleReference getLayerHandle() {
        return this.layerHandle;
    }

    public void setLayerHandle(DwgHandleReference layerHandle) {
        this.layerHandle = layerHandle;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean isNoLinks() {
        return this.noLinks;
    }

    public void setNoLinks(boolean noLinks) {
        this.noLinks = noLinks;
    }

    public int getNumReactors() {
        return this.numReactors;
    }

    public void setNumReactors(int numReactors) {
        this.numReactors = numReactors;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getLinetypeFlags() {
        return this.linetypeFlags;
    }

    public int getPlotstyleFlags() {
        return this.plotstyleFlags;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isGraphicsFlag() {
        return this.graphicsFlag;
    }

    public void setGraphicsFlag(boolean graphicsFlag) {
        this.graphicsFlag = graphicsFlag;
    }

    public boolean isXDicObjFlag() {
        return this.xDicObjFlag;
    }

    public void setXDicObjFlag(boolean xDicObjFlag) {
        this.xDicObjFlag = xDicObjFlag;
    }

    public void setLyrByLineType(boolean lyrByLineType) {
        this.lyrByLineType = lyrByLineType;
    }

    public boolean isLyrByLineType() {
        return this.lyrByLineType;
    }

    public void setPlotStyleHandle(DwgHandleReference hr) {
        this.plotStyleHandle = hr;
    }

    public boolean hasPlotStyleHandle() {
        return this.plotStyleHandle != null;
    }

    public void setLineTypeHandle(DwgHandleReference hr) {
        this.lineTypeHandle = hr;
    }

    public DwgHandleReference getLineTypeHandle() {
        return this.lineTypeHandle;
    }

    public boolean hasLineTypeHandle() {
        return this.lineTypeHandle != null;
    }

    public Object clone() {
        DwgObject obj = new DwgObject(this.index);
        this.fill(obj);
        return obj;
    }

    protected void fill(DwgObject obj) {
        obj.setColor(this.color);
        obj.setExtendedData(this.extendedData);
        obj.setGraphicData(this.graphicData);
        obj.setGraphicsFlag(this.graphicsFlag);
        obj.setHandle(this.handle);
        obj.setLayerHandle(this.layerHandle);
        obj.setLinetypeFlags(this.linetypeFlags);
        obj.setLineTypeHandle(this.lineTypeHandle);
        obj.setLyrByLineType(this.lyrByLineType);
        obj.setMode(this.mode);
        obj.setNextHandle(this.nextHandle);
        obj.setNoLinks(this.noLinks);
        obj.setNumReactors(this.numReactors);
        obj.setPlotstyleFlags(this.plotstyleFlags);
        obj.setPlotStyleHandle(this.plotStyleHandle);
        obj.setPreviousHandle(this.previousHandle);
        obj.setSizeInBits(this.sizeInBits);
        obj.setSubEntityHandle(this.subEntityHandle);
        obj.setType(this.type);
        obj.setVersion(this.version);
        obj.setXDicObjHandle(this.xDicObjHandle);
    }

    public int getGeometrySubType(boolean is3DFile) {
        if (is3DFile) {
            return 1;
        }
        return 0;
    }
}

