/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib;

import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.objects.DwgArc;
import org.gvsig.dwg.lib.objects.DwgAttdef;
import org.gvsig.dwg.lib.objects.DwgAttrib;
import org.gvsig.dwg.lib.objects.DwgBlock;
import org.gvsig.dwg.lib.objects.DwgBlockControl;
import org.gvsig.dwg.lib.objects.DwgBlockHeader;
import org.gvsig.dwg.lib.objects.DwgCircle;
import org.gvsig.dwg.lib.objects.DwgDictionary;
import org.gvsig.dwg.lib.objects.DwgDimOrd;
import org.gvsig.dwg.lib.objects.DwgEllipse;
import org.gvsig.dwg.lib.objects.DwgEndblk;
import org.gvsig.dwg.lib.objects.DwgFace3D;
import org.gvsig.dwg.lib.objects.DwgInsert;
import org.gvsig.dwg.lib.objects.DwgLayer;
import org.gvsig.dwg.lib.objects.DwgLayerControl;
import org.gvsig.dwg.lib.objects.DwgLine;
import org.gvsig.dwg.lib.objects.DwgLwPolyline;
import org.gvsig.dwg.lib.objects.DwgMText;
import org.gvsig.dwg.lib.objects.DwgMeshPolyline;
import org.gvsig.dwg.lib.objects.DwgPFacePolyline;
import org.gvsig.dwg.lib.objects.DwgPoint;
import org.gvsig.dwg.lib.objects.DwgPolyline2D;
import org.gvsig.dwg.lib.objects.DwgPolyline3D;
import org.gvsig.dwg.lib.objects.DwgSeqend;
import org.gvsig.dwg.lib.objects.DwgSolid;
import org.gvsig.dwg.lib.objects.DwgSpline;
import org.gvsig.dwg.lib.objects.DwgText;
import org.gvsig.dwg.lib.objects.DwgVertex2D;
import org.gvsig.dwg.lib.objects.DwgVertex3D;
import org.gvsig.dwg.lib.objects.DwgVertexMesh;
import org.gvsig.dwg.lib.objects.DwgVertexPFace;
import org.gvsig.dwg.lib.objects.DwgVertexPFaceFace;

public class DwgObjectFactory {
    private static DwgObjectFactory _instance = new DwgObjectFactory();

    private DwgObjectFactory() {
    }

    public static final DwgObjectFactory getInstance() {
        return _instance;
    }

    public DwgObject create(int type, int index) {
        DwgObject obj = null;
        if (type == 1) {
            obj = new DwgText(index);
            obj.setGraphicsFlag(true);
        } else if (type == 2) {
            obj = new DwgAttrib(index);
            obj.setGraphicsFlag(true);
        } else if (type == 3) {
            obj = new DwgAttdef(index);
            obj.setGraphicsFlag(true);
        } else if (type == 4) {
            obj = new DwgBlock(index);
            obj.setGraphicsFlag(true);
        } else if (type == 5) {
            obj = new DwgEndblk(index);
            obj.setGraphicsFlag(true);
        } else if (type == 6) {
            obj = new DwgSeqend(index);
            obj.setGraphicsFlag(true);
        } else if (type == 7) {
            obj = new DwgInsert(index);
            obj.setGraphicsFlag(true);
        } else if (type == 10) {
            obj = new DwgVertex2D(index);
            obj.setGraphicsFlag(true);
        } else if (type == 11) {
            obj = new DwgVertex3D(index);
            obj.setGraphicsFlag(true);
        } else if (type == 12) {
            obj = new DwgVertexMesh(index);
            obj.setGraphicsFlag(true);
        } else if (type == 13) {
            obj = new DwgVertexPFace(index);
            obj.setGraphicsFlag(true);
        } else if (type == 14) {
            obj = new DwgVertexPFaceFace(index);
            obj.setGraphicsFlag(true);
        } else if (type == 15) {
            obj = new DwgPolyline2D(index);
            obj.setGraphicsFlag(true);
        } else if (type == 16) {
            obj = new DwgPolyline3D(index);
            obj.setGraphicsFlag(true);
        } else if (type == 17) {
            obj = new DwgArc(index);
            obj.setGraphicsFlag(true);
        } else if (type == 18) {
            obj = new DwgCircle(index);
            obj.setGraphicsFlag(true);
        } else if (type == 19) {
            obj = new DwgLine(index);
            obj.setGraphicsFlag(true);
        } else if (type == 27) {
            obj = new DwgPoint(index);
            obj.setGraphicsFlag(true);
        } else if (type == 29) {
            obj = new DwgPFacePolyline(index);
            obj.setGraphicsFlag(true);
        } else if (type == 30) {
            obj = new DwgMeshPolyline(index);
            obj.setGraphicsFlag(true);
        } else if (type == 35) {
            obj = new DwgEllipse(index);
            obj.setGraphicsFlag(true);
        } else if (type == 36) {
            obj = new DwgSpline(index);
            obj.setGraphicsFlag(true);
        } else if (type == 42) {
            obj = new DwgDictionary(index);
            obj.setGraphicsFlag(false);
        } else if (type == 44) {
            obj = new DwgMText(index);
            obj.setGraphicsFlag(true);
        } else if (type == 48) {
            obj = new DwgBlockControl(index);
            obj.setGraphicsFlag(false);
        } else if (type == 49) {
            obj = new DwgBlockHeader(index);
            obj.setGraphicsFlag(false);
        } else if (type == 50) {
            obj = new DwgLayerControl(index);
            obj.setGraphicsFlag(false);
        } else if (type == 51) {
            obj = new DwgLayer(index);
            obj.setGraphicsFlag(false);
        } else if (type == 77) {
            obj = new DwgLwPolyline(index);
            obj.setGraphicsFlag(true);
        } else if (type == 31) {
            obj = new DwgSolid(index);
            obj.setGraphicsFlag(true);
        } else {
            return null;
        }
        obj.setType(type);
        return obj;
    }

    public DwgObject create(String dxfName, int index) {
        if (dxfName.equalsIgnoreCase("LWPOLYLINE")) {
            DwgLwPolyline solution = new DwgLwPolyline(index);
            solution.setGraphicsFlag(true);
            return solution;
        }
        return null;
    }

    public DwgObject create(byte kind, int index) {
        switch (kind) {
            case 1: {
                return new DwgLine(index);
            }
            case 2: {
                return new DwgPoint(index);
            }
            case 3: {
                return new DwgCircle(index);
            }
            case 7: {
                return new DwgText(index);
            }
            case 8: {
                return new DwgArc(index);
            }
            case 11: {
                return new DwgSolid(index);
            }
            case 12: {
                return new DwgBlockHeader(index);
            }
            case 13: {
                return new DwgEndblk(index);
            }
            case 14: {
                return new DwgInsert(index);
            }
            case 15: {
                return new DwgAttdef(index);
            }
            case 16: {
                return new DwgAttrib(index);
            }
            case 17: {
                return new DwgSeqend(index);
            }
            case 19: {
                return null;
            }
            case 20: {
                return null;
            }
            case 22: {
                return new DwgFace3D(index);
            }
            case 23: {
                return new DwgDimOrd(index);
            }
        }
        return null;
    }
}

