/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import java.awt.geom.Point2D;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.IDwgExtrusionable;
import org.gvsig.dwg.lib.util.AcadExtrusionCalculator;

public class DwgAttrib
extends DwgObject
implements IDwgExtrusionable,
IDwg3DTestable {
    private int dataFlag;
    private double elevation;
    private Point2D insertionPoint;
    private Point2D alignmentPoint;
    private double[] extrusion;
    private double thickness;
    private double obliqueAngle;
    private double rotationAngle;
    private double height;
    private double widthFactor;
    private String text;
    private int generation;
    private int halign;
    private int valign;
    private String tag;
    private int fieldLength;
    private int flags;
    private String prompt;
    private DwgHandleReference styleHandle = null;

    public DwgAttrib(int index) {
        super(index);
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public Point2D getInsertionPoint() {
        return this.insertionPoint;
    }

    public void setInsertionPoint(Point2D insertionPoint) {
        this.insertionPoint = insertionPoint;
    }

    public Point2D getAlignmentPoint() {
        return this.alignmentPoint;
    }

    public void setAlignmentPoint(Point2D alignmentPoint) {
        this.alignmentPoint = alignmentPoint;
    }

    public int getDataFlag() {
        return this.dataFlag;
    }

    public void setDataFlag(int dataFlag) {
        this.dataFlag = dataFlag;
    }

    public int getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int fieldLength) {
        this.fieldLength = fieldLength;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public int getHalign() {
        return this.halign;
    }

    public void setHalign(int halign) {
        this.halign = halign;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getObliqueAngle() {
        return this.obliqueAngle;
    }

    public void setObliqueAngle(double obliqueAngle) {
        this.obliqueAngle = obliqueAngle;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(double rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public DwgHandleReference getStyleHandle() {
        return this.styleHandle;
    }

    public void setStyleHandle(DwgHandleReference styleHandle) {
        this.styleHandle = styleHandle;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public int getValign() {
        return this.valign;
    }

    public void setValign(int valign) {
        this.valign = valign;
    }

    public double getWidthFactor() {
        return this.widthFactor;
    }

    public void setWidthFactor(double widthFactor) {
        this.widthFactor = widthFactor;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }

    @Override
    public void applyExtrussion() {
        Point2D attribInsertionPoint = this.getInsertionPoint();
        if (attribInsertionPoint == null) {
            System.out.println("ATTRIB sin insertion point");
            return;
        }
        double attribElevation = this.getElevation();
        double[] attribInsertionPoint3D = new double[]{attribInsertionPoint.getX(), attribInsertionPoint.getY(), attribElevation};
        double[] attribExt = this.getExtrusion();
        attribInsertionPoint3D = AcadExtrusionCalculator.extrude2(attribInsertionPoint3D, attribExt);
        this.setInsertionPoint(new Point2D.Double(attribInsertionPoint3D[0], attribInsertionPoint3D[1]));
        this.setElevation(attribInsertionPoint3D[2]);
    }

    @Override
    public boolean has3DData() {
        return this.getElevation() != 0.0;
    }

    @Override
    public double getZ() {
        return this.getElevation();
    }

    @Override
    public Object clone() {
        DwgAttrib obj = new DwgAttrib(this.index);
        this.fill(obj);
        return obj;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgAttrib myObj = (DwgAttrib)obj;
        myObj.setAlignmentPoint(this.alignmentPoint);
        myObj.setDataFlag(this.dataFlag);
        myObj.setElevation(this.elevation);
        myObj.setExtrusion(this.extrusion);
        myObj.setFieldLength(this.fieldLength);
        myObj.setFlags(this.flags);
        myObj.setGeneration(this.generation);
        myObj.setHalign(this.halign);
        myObj.setHeight(this.height);
        myObj.setInsertionPoint(this.insertionPoint);
        myObj.setObliqueAngle(this.obliqueAngle);
        myObj.setPrompt(this.prompt);
        myObj.setRotationAngle(this.rotationAngle);
        myObj.setStyleHandle(this.styleHandle);
        myObj.setTag(this.tag);
        myObj.setText(this.text);
        myObj.setThickness(this.thickness);
        myObj.setValign(this.valign);
        myObj.setWidthFactor(this.widthFactor);
    }
}

