/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.IDwgBlockMember;
import org.gvsig.dwg.lib.IDwgExtrusionable;
import org.gvsig.dwg.lib.IDwgPolyline;
import org.gvsig.dwg.lib.IDwgVertex;
import org.gvsig.dwg.lib.util.AcadExtrusionCalculator;
import org.gvsig.dwg.lib.util.FMapUtil;
import org.gvsig.dwg.lib.util.GisModelCurveCalculator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;

public class DwgLwPolyline
extends DwgObject
implements IDwgPolyline,
IDwgExtrusionable,
IDwg3DTestable,
IDwg2FMap,
IDwgBlockMember {
    private int flag;
    private double constWidth;
    private double elevation;
    private double thickness;
    private double[] normal;
    private List vertices = new ArrayList();
    private double[] bulges;
    private double[][] widths;

    public DwgLwPolyline(int index) {
        super(index);
    }

    public double[] getBulges() {
        return this.bulges;
    }

    public void setBulges(double[] bulges) {
        this.bulges = bulges;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public List getVertices() {
        return this.vertices;
    }

    public void setVertices(List vertices) {
        this.vertices = vertices;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public double[] getNormal() {
        return this.normal;
    }

    public double getConstWidth() {
        return this.constWidth;
    }

    public void setConstWidth(double constWidth) {
        this.constWidth = constWidth;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public double[][] getWidths() {
        return this.widths;
    }

    public void setWidths(double[][] widths) {
        this.widths = widths;
    }

    public void setNormal(double[] normal) {
        this.normal = normal;
    }

    @Override
    public void calculateGisModel(DwgFile dwgFile) {
        int j;
        if (this.getVertices() == null) {
            return;
        }
        int flags = this.getFlag();
        List pts = this.getVertices();
        double[] bulges = this.getBulges();
        ArrayList newPts = new ArrayList();
        double[] newBulges = null;
        if (bulges != null) {
            newBulges = new double[bulges.length];
            System.arraycopy(bulges, 0, newBulges, 0, bulges.length);
        } else {
            bulges = new double[pts.size()];
            newBulges = new double[bulges.length];
            for (int i = 0; i < newBulges.length; ++i) {
                bulges[i] = 0.0;
            }
            newBulges = new double[bulges.length];
            System.arraycopy(bulges, 0, newBulges, 0, bulges.length);
        }
        if (flags == 512 || flags == 776 || flags == 768) {
            newBulges = new double[bulges.length + 1];
            for (j = 0; j < pts.size(); ++j) {
                newPts.add(pts.get(j));
            }
            newPts.add(pts.get(0));
            newBulges[pts.size()] = 0.0;
        } else {
            for (j = 0; j < pts.size(); ++j) {
                newPts.add(pts.get(j));
            }
        }
        if (newPts.size() > 0) {
            this.setBulges(newBulges);
            List points = GisModelCurveCalculator.calculateGisModelBulge(newPts, newBulges);
            this.setVertices(points);
        }
    }

    @Override
    public void applyExtrussion() {
        if (this.getVertices() == null) {
            return;
        }
        List vertices = this.getVertices();
        double[] lwPolylineExt = this.getNormal();
        if (lwPolylineExt[0] == 0.0 && lwPolylineExt[1] == 0.0 && lwPolylineExt[2] == 0.0) {
            lwPolylineExt[2] = 1.0;
        }
        double elev = this.getElevation();
        ArrayList<double[]> lwPolylinePoints3D = new ArrayList<double[]>();
        for (int j = 0; j < vertices.size(); ++j) {
            double[] point = new double[]{((double[])vertices.get(j))[0], ((double[])vertices.get(j))[1], elev};
            lwPolylinePoints3D.add(AcadExtrusionCalculator.extrude2(point, lwPolylineExt));
        }
        this.setElevation(elev);
        ArrayList<double[]> newVertices = new ArrayList<double[]>();
        for (int j = 0; j < vertices.size(); ++j) {
            double[] point = (double[])lwPolylinePoints3D.get(j);
            newVertices.add(new double[]{point[0], point[1]});
        }
        this.setVertices(newVertices);
    }

    @Override
    public boolean has3DData() {
        return this.getElevation() != 0.0;
    }

    @Override
    public double getZ() {
        return this.getElevation();
    }

    @Override
    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        return FMapUtil.ptsToLine(this.getVertices(), this.getGeometrySubType(is3DFile));
    }

    @Override
    public String toFMapString(boolean is3DFile) {
        if (is3DFile) {
            return "FPolyline3D";
        }
        return "FPolyline2D";
    }

    @Override
    public String toString() {
        return "LwPolyline";
    }

    @Override
    public void transform2Block(double[] bPoint, Point2D insPoint, double[] scale, double rot, List dwgObjectsWithoutBlocks, Map handleObjWithoutBlocks, DwgFile callBack) {
        DwgLwPolyline transformedEntity = null;
        List vertices = this.getVertices();
        if (vertices != null) {
            ArrayList<double[]> transformedVertices = new ArrayList<double[]>();
            for (int i = 0; i < vertices.size(); ++i) {
                Object vertice = vertices.get(i);
                double[] point = vertice instanceof Point2D.Double ? new double[]{((Point2D.Double)vertices.get((int)i)).x, ((Point2D.Double)vertices.get((int)i)).y} : (double[])vertices.get(i);
                double[] pointAux = new double[]{point[0] - bPoint[0], point[1] - bPoint[1]};
                double laX = insPoint.getX() + (pointAux[0] * scale[0] * Math.cos(rot) + pointAux[1] * scale[1] * -1.0 * Math.sin(rot));
                double laY = insPoint.getY() + (pointAux[0] * scale[0] * Math.sin(rot) + pointAux[1] * scale[1] * Math.cos(rot));
                transformedVertices.add(new double[]{laX, laY});
            }
            transformedEntity = (DwgLwPolyline)this.clone();
            transformedEntity.setVertices(transformedVertices);
            transformedEntity.setElevation(this.getElevation() * scale[2]);
            transformedEntity.setHandle(this.getHandle());
            dwgObjectsWithoutBlocks.add(transformedEntity);
            handleObjWithoutBlocks.put(new Integer(transformedEntity.getHandle().getOffset()), transformedEntity);
        }
    }

    @Override
    public Object clone() {
        DwgLwPolyline dwgLwPolyline = new DwgLwPolyline(this.index);
        this.fill(dwgLwPolyline);
        return dwgLwPolyline;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgLwPolyline myObj = (DwgLwPolyline)obj;
        myObj.setBulges(this.bulges);
        myObj.setConstWidth(this.constWidth);
        myObj.setElevation(this.elevation);
        myObj.setFlag(this.flag);
        myObj.setNormal(this.normal);
        myObj.setThickness(this.thickness);
        myObj.setVertices(this.vertices);
        myObj.setWidths(this.widths);
    }

    @Override
    public void addVertex(IDwgVertex vertex) {
        this.vertices.add(vertex.getPoint());
    }

    @Override
    public int getGeometryType() {
        return 8;
    }
}

