/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwgBlockMember;
import org.gvsig.dwg.lib.IDwgPolyline;
import org.gvsig.dwg.lib.IDwgVertex;
import org.gvsig.dwg.lib.objects.DwgPolyline3D;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;

public class DwgMeshPolyline
extends DwgObject
implements IDwgPolyline,
IDwg2FMap,
IDwgBlockMember {
    private int flags;
    private int curveType;
    private int mVerticies;
    private int nVerticies;
    private boolean isClosedM;
    private boolean isClosedN;
    private DwgHandleReference firstVertexHandle;
    private DwgHandleReference lastVertexHandle;
    private DwgHandleReference seqendHandle;
    private List vertices;
    private ArrayList ownedObjectsHandles = new ArrayList();

    public DwgMeshPolyline(int index) {
        super(index);
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setCurveType(int curveType) {
        this.curveType = curveType;
    }

    public void setMVerticies(int verticies) {
        this.mVerticies = verticies;
    }

    public void setNVerticies(int verticies) {
        this.nVerticies = verticies;
    }

    public void setFirstVertexHandle(DwgHandleReference handle) {
        this.firstVertexHandle = handle;
    }

    public void setLastVertexHandle(DwgHandleReference handle) {
        this.lastVertexHandle = handle;
    }

    public void setSeqendHandle(DwgHandleReference handle) {
        this.seqendHandle = handle;
    }

    public int getCurveType() {
        return this.curveType;
    }

    public DwgHandleReference getFirstVertexHandle() {
        return this.firstVertexHandle;
    }

    public int getFlags() {
        return this.flags;
    }

    public DwgHandleReference getLastVertexHandle() {
        return this.lastVertexHandle;
    }

    public int getMVerticies() {
        return this.mVerticies;
    }

    public int getNVerticies() {
        return this.nVerticies;
    }

    public DwgHandleReference getSeqendHandle() {
        return this.seqendHandle;
    }

    @Override
    public Object clone() {
        DwgMeshPolyline obj = new DwgMeshPolyline(this.index);
        this.fill(obj);
        return obj;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgMeshPolyline myObj = (DwgMeshPolyline)obj;
        myObj.setCurveType(this.curveType);
        myObj.setFirstVertexHandle(this.firstVertexHandle);
        myObj.setFlags(this.flags);
        myObj.setLastVertexHandle(this.lastVertexHandle);
        myObj.setMVerticies(this.mVerticies);
        myObj.setNVerticies(this.nVerticies);
        myObj.setSeqendHandle(this.seqendHandle);
    }

    @Override
    public void calculateGisModel(DwgFile dwgFile) {
    }

    @Override
    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        return null;
    }

    @Override
    public String toFMapString(boolean is3DFile) {
        if (is3DFile) {
            return "FPolyline3D";
        }
        return "FPolyline2D";
    }

    @Override
    public String toString() {
        return "MeshPolyline";
    }

    public List getVertices() {
        return this.vertices;
    }

    public void setVertices(List vertices) {
        this.vertices = vertices;
    }

    public boolean isClosedM() {
        return this.isClosedM;
    }

    public void setClosedM(boolean isClosedM) {
        this.isClosedM = isClosedM;
    }

    public boolean isClosedN() {
        return this.isClosedN;
    }

    public void setClosedN(boolean isClosedN) {
        this.isClosedN = isClosedN;
    }

    public void setMDensity(int density) {
        this.mVerticies = density;
    }

    public void setNDensity(int density) {
        this.nVerticies = density;
    }

    @Override
    public void addVertex(IDwgVertex vertex) {
        this.vertices.add(vertex.getPoint());
    }

    public ArrayList getOwnedObjectsHandles() {
        return this.ownedObjectsHandles;
    }

    public void setOwnedObjectsHandles(ArrayList handles) {
        this.ownedObjectsHandles = handles;
    }

    public void addOwnedObjectHandle(DwgHandleReference handle) {
        this.ownedObjectsHandles.add(handle);
    }

    @Override
    public void transform2Block(double[] bPoint, Point2D insPoint, double[] scale, double rot, List dwgObjectsWithoutBlocks, Map handleObjWithoutBlocks, DwgFile callBack) {
        DwgPolyline3D transformedEntity = null;
        List vertices = this.getVertices();
        if (vertices != null) {
            ArrayList<double[]> transformedVertices = new ArrayList<double[]>();
            for (int i = 0; i < vertices.size(); ++i) {
                double[] pointAux = null;
                pointAux = new double[]{((double[])vertices.get(i))[0] - bPoint[0], ((double[])vertices.get(i))[1] - bPoint[1]};
                double laX = insPoint.getX() + (pointAux[0] * scale[0] * Math.cos(rot) + pointAux[1] * scale[1] * -1.0 * Math.sin(rot));
                double laY = insPoint.getY() + (pointAux[0] * scale[0] * Math.sin(rot) + pointAux[1] * scale[1] * Math.cos(rot));
                double laZ = ((double[])vertices.get(i))[2] - bPoint[2];
                transformedVertices.add(new double[]{laX, laY, laZ});
            }
            transformedEntity = (DwgPolyline3D)this.clone();
            transformedEntity.setPts(transformedVertices);
            dwgObjectsWithoutBlocks.add(transformedEntity);
            handleObjWithoutBlocks.put(new Integer(transformedEntity.getHandle().getOffset()), transformedEntity);
        }
    }

    @Override
    public int getGeometryType() {
        return 8;
    }
}

