/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.IDwgBlockMember;
import org.gvsig.dwg.lib.IDwgExtrusionable;
import org.gvsig.dwg.lib.IDwgPolyline;
import org.gvsig.dwg.lib.IDwgVertex;
import org.gvsig.dwg.lib.objects.DwgSeqend;
import org.gvsig.dwg.lib.objects.DwgVertex2D;
import org.gvsig.dwg.lib.util.AcadExtrusionCalculator;
import org.gvsig.dwg.lib.util.FMapUtil;
import org.gvsig.dwg.lib.util.GisModelCurveCalculator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwgPolyline2D
extends DwgObject
implements IDwgPolyline,
IDwgExtrusionable,
IDwg3DTestable,
IDwg2FMap,
IDwgBlockMember {
    private static Logger logger = LoggerFactory.getLogger((String)DwgPolyline2D.class.getName());
    private int flags;
    private int curveType;
    private double initWidth;
    private double endWidth;
    private double thickness;
    private double elevation;
    private double[] extrusion;
    private DwgHandleReference firstVertexHandle = null;
    private DwgHandleReference lastVertexHandle = null;
    private DwgHandleReference seqendHandle = null;
    private List vertices = new ArrayList();
    private double[] bulges;
    private ArrayList vertexHandles = new ArrayList();

    public DwgPolyline2D(int index) {
        super(index);
    }

    public DwgHandleReference getFirstVertexHandle() {
        return this.firstVertexHandle;
    }

    public void setFirstVertexHandle(DwgHandleReference firstVertexHandle) {
        this.firstVertexHandle = firstVertexHandle;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public DwgHandleReference getLastVertexHandle() {
        return this.lastVertexHandle;
    }

    public void setLastVertexHandle(DwgHandleReference lastVertexHandle) {
        this.lastVertexHandle = lastVertexHandle;
    }

    public List getPts() {
        return this.vertices;
    }

    public void setPts(List pts) {
        this.vertices = pts;
    }

    public double[] getBulges() {
        return this.bulges;
    }

    public void setBulges(double[] bulges) {
        this.bulges = bulges;
    }

    public double getInitWidth() {
        return this.initWidth;
    }

    public void setInitWidth(double initWidth) {
        this.initWidth = initWidth;
    }

    public DwgHandleReference getSeqendHandle() {
        return this.seqendHandle;
    }

    public void setSeqendHandle(DwgHandleReference seqendHandle) {
        this.seqendHandle = seqendHandle;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public int getCurveType() {
        return this.curveType;
    }

    public void setCurveType(int curveType) {
        this.curveType = curveType;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public double getEndWidth() {
        return this.endWidth;
    }

    public void setEndWidth(double endWidth) {
        this.endWidth = endWidth;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }

    public void setVertexHandles(ArrayList handles) {
        this.vertexHandles = handles;
    }

    public ArrayList getVertexHandles() {
        return this.vertexHandles;
    }

    public void addVertexHandle(DwgHandleReference handle) {
        this.vertexHandles.add(handle);
    }

    @Override
    public void calculateGisModel(DwgFile dwgFile) {
        int flags = this.getFlags();
        ArrayList<Object> pts = new ArrayList<Object>();
        ArrayList<Double> bulges = new ArrayList<Double>();
        double[] pt = new double[3];
        double bulge = 0.0;
        if (dwgFile.getDwgVersion().equalsIgnoreCase("Autocad R2004, R2005, R2006")) {
            ArrayList vertexHandles = this.getVertexHandles();
            Object seqend = null;
            for (int i = 0; i < vertexHandles.size(); ++i) {
                DwgHandleReference vertice = (DwgHandleReference)vertexHandles.get(i);
                DwgObject objVertex = dwgFile.getDwgObjectFromHandle(vertice.getOffset());
                if (objVertex != null) {
                    if (objVertex instanceof DwgVertex2D) {
                        pts.add(((DwgVertex2D)objVertex).getPoint());
                        bulge = ((DwgVertex2D)objVertex).getBulge();
                        bulges.add(new Double(bulge));
                        continue;
                    }
                    logger.warn("Encontrado un " + objVertex.getClass().getName() + " " + "con indice " + i + " en la lista de vertices de Polyline2D");
                    continue;
                }
                logger.warn("No se ha encontrado el vertice " + i + " de " + vertexHandles.size() + " de la Polyline2D " + this.getIndex());
                if (i != 0) continue;
                seqend = dwgFile.getDwgObjectFromHandle(this.seqendHandle.getOffset());
            }
            if (seqend != null) {
                if (seqend instanceof DwgVertex2D) {
                    pts.add(((DwgVertex2D)seqend).getPoint());
                    bulge = ((DwgVertex2D)seqend).getBulge();
                    bulges.add(new Double(bulge));
                } else {
                    logger.warn("Encontrado un " + seqend.getClass().getName() + " en seqend de Polyline2D " + this.getIndex() + " cuando deber\u00c3\u00ada ser un DwgVertex2D");
                }
            }
        } else {
            DwgHandleReference firstHandle = this.getFirstVertexHandle();
            DwgHandleReference lastHandle = this.getLastVertexHandle();
            DwgObject first = dwgFile.getDwgObjectFromHandle(firstHandle.getOffset());
            DwgObject last = dwgFile.getDwgObjectFromHandle(lastHandle.getOffset());
            if (first == null || last == null) {
                logger.warn("Polyline2D con vertices inicial o final a null");
                return;
            }
            if (!(first instanceof DwgVertex2D)) {
                logger.warn("El primer vertice de Polyline2D es " + first.getClass().getName());
                return;
            }
            if (!(last instanceof DwgVertex2D)) {
                logger.warn("El primer vertice de Polyline2D es " + first.getClass().getName());
                return;
            }
            int firstObjIdx = dwgFile.getIndexOf(first);
            int lastObjIdx = dwgFile.getIndexOf(last);
            if (firstObjIdx == -1 || lastObjIdx == -1) {
                logger.warn("Calculate GIS Model: Problemas en la LinkedList: 1\u00ef\u00bf\u00bd=" + firstObjIdx + ",Ultimo=" + lastObjIdx);
                return;
            }
            for (int i = firstObjIdx; i <= lastObjIdx; ++i) {
                DwgObject obj = dwgFile.getDwgObject(i);
                if (obj instanceof DwgVertex2D) {
                    DwgVertex2D vertex = (DwgVertex2D)obj;
                    pt = vertex.getPoint();
                    pts.add(new Point2D.Double(pt[0], pt[1]));
                    bulge = vertex.getBulge();
                    bulges.add(new Double(bulge));
                    continue;
                }
                logger.warn("Encontrado " + obj.getClass().getName() + " en la lista de vertices de Polyline2D");
            }
        }
        if (pts.size() > 0) {
            int j;
            ArrayList newPts = new ArrayList();
            if ((flags & 1) == 1) {
                for (j = 0; j < pts.size(); ++j) {
                    newPts.add(pts.get(j));
                }
                newPts.add(pts.get(0));
                bulges.add(new Double(0.0));
            } else {
                for (j = 0; j < pts.size(); ++j) {
                    newPts.add(pts.get(j));
                }
            }
            double[] bs = new double[bulges.size()];
            for (int j2 = 0; j2 < bulges.size(); ++j2) {
                bs[j2] = (Double)bulges.get(j2);
            }
            this.setBulges(bs);
            List points = GisModelCurveCalculator.calculateGisModelBulge(newPts, bs);
            this.setPts(points);
        } else {
            logger.warn("Encontrada polil\u00c3\u00adnea sin puntos ...");
        }
    }

    public void calculateGisModel(List dwgObjects) {
        int flags = this.getFlags();
        int firstHandle = this.getFirstVertexHandle().getOffset();
        int lastHandle = this.getLastVertexHandle().getOffset();
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        ArrayList<Double> bulges = new ArrayList<Double>();
        double[] pt = new double[3];
        block0: for (int j = 0; j < dwgObjects.size(); ++j) {
            int vertexHandle;
            DwgObject firstVertex = (DwgObject)dwgObjects.get(j);
            if (!(firstVertex instanceof DwgVertex2D) || (vertexHandle = firstVertex.getHandle().getOffset()) != firstHandle) continue;
            int k = 0;
            while (true) {
                DwgObject vertex = (DwgObject)dwgObjects.get(j + k);
                int vHandle = vertex.getHandle().getOffset();
                if (vertex instanceof DwgVertex2D) {
                    pt = ((DwgVertex2D)vertex).getPoint();
                    pts.add(new Point2D.Double(pt[0], pt[1]));
                    double bulge = ((DwgVertex2D)vertex).getBulge();
                    bulges.add(new Double(bulge));
                    ++k;
                    if (vHandle != lastHandle || !(vertex instanceof DwgVertex2D)) continue;
                    continue block0;
                }
                if (!(vertex instanceof DwgSeqend)) continue;
                ++k;
            }
        }
        if (pts.size() > 0) {
            int j;
            ArrayList newPts = new ArrayList();
            if ((flags & 1) == 1) {
                for (j = 0; j < pts.size(); ++j) {
                    newPts.add(pts.get(j));
                }
                newPts.add(pts.get(0));
                bulges.add(new Double(0.0));
            } else {
                for (j = 0; j < pts.size(); ++j) {
                    newPts.add(pts.get(j));
                }
            }
            double[] bs = new double[bulges.size()];
            for (int j2 = 0; j2 < bulges.size(); ++j2) {
                bs[j2] = (Double)bulges.get(j2);
            }
            this.setBulges(bs);
            List points = GisModelCurveCalculator.calculateGisModelBulge(newPts, bs);
            this.setPts(points);
        }
    }

    @Override
    public void applyExtrussion() {
        int j;
        if (this.getPts() == null) {
            return;
        }
        List vertices = this.getPts();
        double[] polyline2DExt = this.getExtrusion();
        double elev = this.getElevation();
        double[][] polylinePoints3D = new double[vertices.size()][3];
        for (j = 0; j < vertices.size(); ++j) {
            polylinePoints3D[j][0] = ((double[])vertices.get(j))[0];
            polylinePoints3D[j][1] = ((double[])vertices.get(j))[1];
            polylinePoints3D[j][2] = elev;
            polylinePoints3D[j] = AcadExtrusionCalculator.extrude2(polylinePoints3D[j], polyline2DExt);
        }
        this.setElevation(elev);
        for (j = 0; j < vertices.size(); ++j) {
            vertices.add(new double[]{polylinePoints3D[j][0], polylinePoints3D[j][1]});
        }
        this.setPts(vertices);
    }

    @Override
    public boolean has3DData() {
        return this.getElevation() != 0.0;
    }

    @Override
    public double getZ() {
        return this.getElevation();
    }

    @Override
    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        return FMapUtil.ptsToLine(this.getPts(), this.getGeometrySubType(is3DFile));
    }

    @Override
    public String toFMapString(boolean is3DFile) {
        if (is3DFile) {
            return "FPolyline3D";
        }
        return "FPolyline2D";
    }

    @Override
    public String toString() {
        return "Polyline2D";
    }

    @Override
    public void transform2Block(double[] bPoint, Point2D insPoint, double[] scale, double rot, List dwgObjectsWithoutBlocks, Map handleObjWithoutBlocks, DwgFile callBack) {
        DwgPolyline2D transformedEntity = null;
        List vertices = this.getPts();
        if (vertices != null) {
            ArrayList<double[]> transformedVertices = new ArrayList<double[]>();
            for (int i = 0; i < vertices.size(); ++i) {
                double[] pointAux = null;
                pointAux = new double[]{((double[])vertices.get(i))[0] - bPoint[0], ((double[])vertices.get(i))[1] - bPoint[1]};
                double laX = insPoint.getX() + (pointAux[0] * scale[0] * Math.cos(rot) + pointAux[1] * scale[1] * -1.0 * Math.sin(rot));
                double laY = insPoint.getY() + (pointAux[0] * scale[0] * Math.sin(rot) + pointAux[1] * scale[1] * Math.cos(rot));
                transformedVertices.add(new double[]{laX, laY});
            }
            transformedEntity = (DwgPolyline2D)this.clone();
            transformedEntity.setPts(transformedVertices);
            transformedEntity.setElevation(this.getElevation() * scale[2]);
            dwgObjectsWithoutBlocks.add(transformedEntity);
            handleObjWithoutBlocks.put(new Integer(transformedEntity.getHandle().getOffset()), transformedEntity);
        }
    }

    @Override
    public Object clone() {
        DwgPolyline2D obj = new DwgPolyline2D(this.index);
        this.fill(obj);
        return obj;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgPolyline2D myObj = (DwgPolyline2D)obj;
        myObj.setBulges(this.bulges);
        myObj.setCurveType(this.curveType);
        myObj.setElevation(this.elevation);
        myObj.setEndWidth(this.endWidth);
        myObj.setExtrusion(this.extrusion);
        myObj.setFirstVertexHandle(this.firstVertexHandle);
        myObj.setFlags(this.flags);
        myObj.setInitWidth(this.initWidth);
        myObj.setLastVertexHandle(this.lastVertexHandle);
        myObj.setPts(this.vertices);
        myObj.setSeqendHandle(this.seqendHandle);
        myObj.setThickness(this.thickness);
    }

    @Override
    public void addVertex(IDwgVertex vertex) {
        this.vertices.add(vertex.getPoint());
    }

    @Override
    public int getGeometrySubType(boolean is3DFile) {
        return 0;
    }

    @Override
    public int getGeometryType() {
        return 8;
    }
}

