/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.IDwgBlockMember;
import org.gvsig.dwg.lib.IDwgPolyline;
import org.gvsig.dwg.lib.IDwgVertex;
import org.gvsig.dwg.lib.objects.DwgSeqend;
import org.gvsig.dwg.lib.objects.DwgVertex3D;
import org.gvsig.dwg.lib.util.FMapUtil;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwgPolyline3D
extends DwgObject
implements IDwgPolyline,
IDwg3DTestable,
IDwg2FMap,
IDwgBlockMember {
    private int splineFlags;
    private int closedFlags;
    private DwgHandleReference firstVertexHandle = null;
    private DwgHandleReference lastVertexHandle = null;
    private DwgHandleReference seqendHandle = null;
    private ArrayList vertexHandles;
    private List vertices = new ArrayList();
    private double[] bulges;
    private static Logger logger = LoggerFactory.getLogger((String)DwgPolyline3D.class.getName());

    public DwgPolyline3D(int index) {
        super(index);
        this.vertexHandles = new ArrayList();
    }

    public int getClosedFlags() {
        return this.closedFlags;
    }

    public void setClosedFlags(int closedFlags) {
        this.closedFlags = closedFlags;
    }

    public DwgHandleReference getFirstVertexHandle() {
        return this.firstVertexHandle;
    }

    public void setFirstVertexHandle(DwgHandleReference firstVertexHandle) {
        this.firstVertexHandle = firstVertexHandle;
    }

    public DwgHandleReference getLastVertexHandle() {
        return this.lastVertexHandle;
    }

    public void setLastVertexHandle(DwgHandleReference lastVertexHandle) {
        this.lastVertexHandle = lastVertexHandle;
    }

    public List getPts() {
        return this.vertices;
    }

    public void setPts(List pts) {
        this.vertices = pts;
    }

    public double[] getBulges() {
        return this.bulges;
    }

    public void setBulges(double[] bulges) {
        this.bulges = bulges;
    }

    public DwgHandleReference getSeqendHandle() {
        return this.seqendHandle;
    }

    public void setSeqendHandle(DwgHandleReference seqendHandle) {
        this.seqendHandle = seqendHandle;
    }

    public int getSplineFlags() {
        return this.splineFlags;
    }

    public void setSplineFlags(int splineFlags) {
        this.splineFlags = splineFlags;
    }

    @Override
    public void calculateGisModel(DwgFile dwgFile) {
        ArrayList<double[]> pts = new ArrayList<double[]>();
        double[] pt = new double[3];
        int closedFlags = this.getClosedFlags();
        if (dwgFile.getDwgVersion().equalsIgnoreCase("Autocad R2004, R2005, R2006")) {
            ArrayList vertexHandles = this.getVertexHandles();
            Object seqend = null;
            for (int i = 0; i < vertexHandles.size(); ++i) {
                DwgHandleReference vertice = (DwgHandleReference)vertexHandles.get(i);
                DwgObject objVertex = dwgFile.getDwgObjectFromHandle(vertice.getOffset());
                if (objVertex != null) {
                    if (objVertex instanceof DwgVertex3D) {
                        pts.add(((DwgVertex3D)objVertex).getPoint());
                        continue;
                    }
                    logger.warn("Encontrado un " + objVertex.getClass().getName() + " " + "con indice " + i + " en la lista de vertices de Polyline3D");
                    continue;
                }
                logger.warn("No se ha encontrado el vertice " + i + " de " + vertexHandles.size() + " de la Polyline3D " + this.getIndex());
                if (i != 0) continue;
                seqend = dwgFile.getDwgObjectFromHandle(this.seqendHandle.getOffset());
            }
            if (seqend != null) {
                if (seqend instanceof DwgVertex3D) {
                    pts.add(((DwgVertex3D)seqend).getPoint());
                } else {
                    logger.warn("Encontrado un " + seqend.getClass().getName() + " en seqend de Polyline3D " + this.getIndex() + " cuando deber\u00c3\u00ada ser un DwgVertex3D");
                }
            }
        } else {
            DwgHandleReference firstHandle = this.getFirstVertexHandle();
            DwgHandleReference lastHandle = this.getLastVertexHandle();
            double bulge = 0.0;
            DwgObject first = dwgFile.getDwgObjectFromHandle(firstHandle.getOffset());
            DwgObject last = dwgFile.getDwgObjectFromHandle(lastHandle.getOffset());
            DwgObject seqend = dwgFile.getDwgObjectFromHandle(this.seqendHandle.getOffset());
            if (last == null) {
                logger.warn("Polyline3D con vertice final a null");
                return;
            }
            if (first == null) {
                logger.warn("Polyline3D con offset = " + this.getHandle().getOffset() + " con vertice inicial a null");
                if (seqend != null) {
                    first = last;
                    last = seqend;
                } else {
                    logger.warn("Polyline3D con vertice seqend a null");
                }
            }
            if (!(first instanceof DwgVertex3D)) {
                logger.warn("El primer vertice de Polyline3D es " + first.getClass().getName());
                return;
            }
            if (!(last instanceof DwgVertex3D)) {
                logger.warn("El ultimo vertice de Polyline3D es " + last.getClass().getName());
                return;
            }
            int firstObjIdx = dwgFile.getIndexOf(first);
            int lastObjIdx = dwgFile.getIndexOf(last);
            if (firstObjIdx == -1 || lastObjIdx == -1) {
                logger.warn("Calculate GIS Model: Problemas en la LinkedList: 1\u00c2\u00ba=" + firstObjIdx + ",Ultimo=" + lastObjIdx);
                return;
            }
            for (int i = firstObjIdx; i <= lastObjIdx; ++i) {
                DwgObject obj = dwgFile.getDwgObject(i);
                if (obj instanceof DwgVertex3D) {
                    DwgVertex3D vertex = (DwgVertex3D)obj;
                    pt = vertex.getPoint();
                    pts.add(new double[]{pt[0], pt[1], pt[2]});
                    continue;
                }
                if (obj instanceof DwgSeqend) break;
                logger.warn("Encontrado " + obj.getClass().getName() + " en la lista de vertices de Polyline3D");
            }
        }
        if (pts.size() > 0) {
            ArrayList newPts = new ArrayList();
            for (int j = 0; j < pts.size(); ++j) {
                newPts.add(pts.get(j));
            }
            if ((closedFlags & 1) == 1) {
                newPts.add(pts.get(0));
            }
            this.setPts(newPts);
        } else {
            logger.warn("Encontrada polil\u00c3\u00adnea sin puntos ...");
        }
    }

    public void calculateGisModel(List dwgObjects) {
        int closedFlags = this.getClosedFlags();
        int firstHandle = this.getFirstVertexHandle().getOffset();
        int lastHandle = this.getLastVertexHandle().getOffset();
        ArrayList<double[]> pts = new ArrayList<double[]>();
        double[] pt = new double[3];
        block0: for (int j = 0; j < dwgObjects.size(); ++j) {
            int vertexHandle;
            DwgObject firstVertex = (DwgObject)dwgObjects.get(j);
            if (!(firstVertex instanceof DwgVertex3D) || (vertexHandle = firstVertex.getHandle().getOffset()) != firstHandle) continue;
            int k = 0;
            while (true) {
                DwgObject vertex = (DwgObject)dwgObjects.get(j + k);
                int vHandle = vertex.getHandle().getOffset();
                if (vertex instanceof DwgVertex3D) {
                    pt = ((DwgVertex3D)vertex).getPoint();
                    pts.add(new double[]{pt[0], pt[1], pt[2]});
                    ++k;
                    if (vHandle != lastHandle || !(vertex instanceof DwgVertex3D)) continue;
                    continue block0;
                }
                if (vertex instanceof DwgSeqend) break;
            }
        }
        if (pts.size() > 0) {
            ArrayList newPts = new ArrayList();
            for (int j = 0; j < pts.size(); ++j) {
                newPts.add(pts.get(j));
            }
            if ((closedFlags & 1) == 1) {
                newPts.add(pts.get(0));
            }
            this.setPts(newPts);
        }
    }

    @Override
    public boolean has3DData() {
        List pts = this.getPts();
        if (pts == null) {
            return false;
        }
        double z = 0.0;
        for (int j = 0; j < pts.size(); ++j) {
            z = ((double[])pts.get(j))[2];
            if (z == 0.0) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getZ() {
        List points3D = this.getPts();
        if (points3D != null) {
            boolean constantElevation = true;
            double[] firstPt = (double[])points3D.get(0);
            for (int j = 0; j < points3D.size(); ++j) {
                double[] pt = (double[])points3D.get(j);
                if (pt[2] == firstPt[2]) continue;
                constantElevation = false;
                break;
            }
            if (constantElevation) {
                return firstPt[2];
            }
        }
        return 0.0;
    }

    public double[] getPZ() {
        List points3D = this.getPts();
        if (points3D != null) {
            double[] pZ = new double[points3D.size()];
            for (int i = 0; i < points3D.size(); ++i) {
                double[] pt = (double[])points3D.get(i);
                pZ[i] = pt[2];
            }
            return pZ;
        }
        return new double[]{0.0};
    }

    @Override
    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        return FMapUtil.ptsToLine(this.getPts(), this.getGeometrySubType(is3DFile));
    }

    @Override
    public String toFMapString(boolean is3DFile) {
        if (is3DFile) {
            return "FPolyline3D";
        }
        return "FPolyline2D";
    }

    @Override
    public String toString() {
        return "Polyline3D";
    }

    @Override
    public Object clone() {
        DwgPolyline3D obj = new DwgPolyline3D(this.index);
        this.fill(obj);
        return obj;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgPolyline3D myObj = (DwgPolyline3D)obj;
        myObj.setBulges(this.bulges);
        myObj.setClosedFlags(this.closedFlags);
        myObj.setFirstVertexHandle(this.firstVertexHandle);
        myObj.setLastVertexHandle(this.lastVertexHandle);
        myObj.setPts(this.vertices);
        myObj.setSeqendHandle(this.seqendHandle);
        myObj.setSplineFlags(this.splineFlags);
    }

    @Override
    public void addVertex(IDwgVertex vertex) {
        this.vertices.add(vertex.getPoint());
    }

    @Override
    public void transform2Block(double[] bPoint, Point2D insPoint, double[] scale, double rot, List dwgObjectsWithoutBlocks, Map handleObjWithoutBlocks, DwgFile callBack) {
        DwgPolyline3D transformedEntity = null;
        List vertices = this.getPts();
        if (vertices != null) {
            ArrayList<double[]> transformedVertices = new ArrayList<double[]>();
            for (int i = 0; i < vertices.size(); ++i) {
                double[] pointAux = null;
                pointAux = new double[]{((double[])vertices.get(i))[0] - bPoint[0], ((double[])vertices.get(i))[1] - bPoint[1]};
                double laX = insPoint.getX() + (pointAux[0] * scale[0] * Math.cos(rot) + pointAux[1] * scale[1] * -1.0 * Math.sin(rot));
                double laY = insPoint.getY() + (pointAux[0] * scale[0] * Math.sin(rot) + pointAux[1] * scale[1] * Math.cos(rot));
                double laZ = ((double[])vertices.get(i))[2] - bPoint[2];
                transformedVertices.add(new double[]{laX, laY, laZ});
            }
            transformedEntity = (DwgPolyline3D)this.clone();
            transformedEntity.setPts(transformedVertices);
            dwgObjectsWithoutBlocks.add(transformedEntity);
            handleObjWithoutBlocks.put(new Integer(transformedEntity.getHandle().getOffset()), transformedEntity);
        }
    }

    public void setVertexHandles(ArrayList Handles) {
        this.vertexHandles = Handles;
    }

    public ArrayList getVertexHandles() {
        return this.vertexHandles;
    }

    public void addVertexHandle(DwgHandleReference handle) {
        this.vertexHandles.add(handle);
    }

    @Override
    public int getGeometryType() {
        return 8;
    }
}

