/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.readers.v1314;

import java.util.ArrayList;
import java.util.HashMap;
import org.gvsig.dwg.lib.CorruptedDwgEntityException;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgUtil;
import org.gvsig.dwg.lib.objects.DwgHatch;
import org.gvsig.dwg.lib.readers.v1314.AbstractDwg1314Reader;

public class DwgHatchReader1314
extends AbstractDwg1314Reader {
    @Override
    public void readSpecificObj(int[] data, int offset, DwgObject dwgObj) throws RuntimeException, CorruptedDwgEntityException {
        if (!(dwgObj instanceof DwgHatch)) {
            throw new RuntimeException("ArcReader 14 solo puede leer DwgHatch");
        }
        DwgHatch h = (DwgHatch)dwgObj;
        int bitPos = offset;
        bitPos = this.headTailReader.readObjectHeader(data, offset, dwgObj);
        ArrayList val = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)val.get(0);
        double zCoord = (Double)val.get(1);
        h.setZ(zCoord);
        val = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)val.get(0);
        double xEx = (Double)val.get(1);
        val = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)val.get(0);
        double yEx = (Double)val.get(1);
        val = DwgUtil.getBitDouble(data, bitPos);
        bitPos = (Integer)val.get(0);
        double zEx = (Double)val.get(1);
        h.setExtrusion(new double[]{xEx, yEx, zEx});
        val = DwgUtil.getTextString(data, bitPos);
        bitPos = (Integer)val.get(0);
        String txt = (String)val.get(1);
        h.setName(txt);
        val = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)val.get(0);
        boolean solidFill = (Boolean)val.get(1);
        h.setSolidFill(solidFill);
        val = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)val.get(0);
        boolean associative = (Boolean)val.get(1);
        h.setAssociative(associative);
        val = DwgUtil.getBitLong(data, bitPos);
        bitPos = (Integer)val.get(0);
        int numPaths = (Integer)val.get(1);
        HashMap<String, Cloneable> paths = new HashMap<String, Cloneable>();
        int pathFlag = 0;
        int pixel = 0;
        int allBounds = 0;
        for (int i = 0; i < numPaths; ++i) {
            val = DwgUtil.getBitLong(data, bitPos);
            bitPos = (Integer)val.get(0);
            pathFlag = (Integer)val.get(1);
            if ((pathFlag & 4) > 0) {
                ++pixel;
            }
            if ((pathFlag & 2) > 0) {
                val = DwgUtil.testBit(data, bitPos);
                bitPos = (Integer)val.get(0);
                boolean hasBulges = (Boolean)val.get(1);
                val = DwgUtil.testBit(data, bitPos);
                bitPos = (Integer)val.get(0);
                boolean isClosed = (Boolean)val.get(1);
                val = DwgUtil.getBitLong(data, bitPos);
                bitPos = (Integer)val.get(0);
                int nps = (Integer)val.get(1);
                ArrayList<double[]> pathSegments = new ArrayList<double[]>();
                for (int j = 0; j < nps; ++j) {
                    val = DwgUtil.getRawDouble(data, bitPos);
                    bitPos = (Integer)val.get(0);
                    double x = (Double)val.get(1);
                    val = DwgUtil.getRawDouble(data, bitPos);
                    bitPos = (Integer)val.get(0);
                    double y = (Double)val.get(1);
                    double bulge = 0.0;
                    if (hasBulges) {
                        val = DwgUtil.getBitDouble(data, bitPos);
                        bitPos = (Integer)val.get(0);
                        bulge = (Double)val.get(1);
                    }
                    pathSegments.add(new double[]{x, y, bulge});
                }
                paths.put("polyline", pathSegments);
            } else {
                val = DwgUtil.getBitLong(data, bitPos);
                bitPos = (Integer)val.get(0);
                int nps = (Integer)val.get(1);
                HashMap<String, Object> pathSegments = new HashMap<String, Object>();
                block8: for (int j = 0; j < nps; ++j) {
                    val = DwgUtil.getRawChar(data, bitPos);
                    bitPos = (Integer)val.get(0);
                    int pts = (Integer)val.get(1);
                    switch (pts) {
                        case 1: {
                            val = DwgUtil.getRawDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double x1 = (Double)val.get(1);
                            val = DwgUtil.getRawDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double y1 = (Double)val.get(1);
                            val = DwgUtil.getRawDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double x2 = (Double)val.get(1);
                            val = DwgUtil.getRawDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double y2 = (Double)val.get(1);
                            pathSegments.put("line", new double[]{x1, y1, x2, y2});
                            continue block8;
                        }
                        case 2: {
                            val = DwgUtil.getRawDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double x = (Double)val.get(1);
                            val = DwgUtil.getRawDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double y = (Double)val.get(1);
                            val = DwgUtil.getBitDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double r = (Double)val.get(1);
                            val = DwgUtil.getBitDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double sa = (Double)val.get(1);
                            val = DwgUtil.getBitDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double ea = (Double)val.get(1);
                            val = DwgUtil.testBit(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            boolean isCcw = (Boolean)val.get(1);
                            ArrayList<Object> list = new ArrayList<Object>();
                            list.add(new Double(x));
                            list.add(new Double(y));
                            list.add(new Double(r));
                            list.add(new Double(sa));
                            list.add(new Double(ea));
                            list.add(new Boolean(isCcw));
                            pathSegments.put("arc", list);
                            continue block8;
                        }
                        case 3: {
                            val = DwgUtil.getRawDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double x = (Double)val.get(1);
                            val = DwgUtil.getRawDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double y = (Double)val.get(1);
                            val = DwgUtil.getRawDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double xe = (Double)val.get(1);
                            val = DwgUtil.getRawDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double ye = (Double)val.get(1);
                            val = DwgUtil.getBitDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double r = (Double)val.get(1);
                            val = DwgUtil.getBitDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double sa = (Double)val.get(1);
                            val = DwgUtil.getBitDouble(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            double ea = (Double)val.get(1);
                            val = DwgUtil.testBit(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            boolean isCcw = (Boolean)val.get(1);
                            ArrayList<Object> list = new ArrayList();
                            list.add(new Double(x));
                            list.add(new Double(y));
                            list.add(new Double(xe));
                            list.add(new Double(ye));
                            list.add(new Double(r));
                            list.add(new Double(sa));
                            list.add(new Double(ea));
                            list.add(new Boolean(isCcw));
                            pathSegments.put("elliptical_arc", list);
                            continue block8;
                        }
                        case 4: {
                            ArrayList<Object> list;
                            val = DwgUtil.getBitLong(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            int deg = (Integer)val.get(1);
                            val = DwgUtil.testBit(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            boolean isRat = (Boolean)val.get(1);
                            val = DwgUtil.testBit(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            boolean isPer = (Boolean)val.get(1);
                            val = DwgUtil.getBitLong(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            int numKnokts = (Integer)val.get(1);
                            val = DwgUtil.getBitLong(data, bitPos);
                            bitPos = (Integer)val.get(0);
                            int numCtrlPts = (Integer)val.get(1);
                            double[] knots = new double[numKnokts];
                            for (int z = 0; z < numKnokts; ++z) {
                                val = DwgUtil.getBitDouble(data, bitPos);
                                bitPos = (Integer)val.get(0);
                                knots[z] = (Double)val.get(1);
                            }
                            double[][] controlPoints = new double[3][numCtrlPts];
                            for (int z = 0; z < numCtrlPts; ++z) {
                                val = DwgUtil.getRawDouble(data, bitPos);
                                bitPos = (Integer)val.get(0);
                                controlPoints[0][z] = (Double)val.get(1);
                                val = DwgUtil.getRawDouble(data, bitPos);
                                bitPos = (Integer)val.get(0);
                                controlPoints[1][z] = (Double)val.get(1);
                                if (isRat) {
                                    val = DwgUtil.getBitDouble(data, bitPos);
                                    bitPos = (Integer)val.get(0);
                                    controlPoints[2][z] = (Double)val.get(1);
                                } else {
                                    controlPoints[2][z] = 0.0;
                                }
                                list = new ArrayList();
                                list.add(new Boolean(isRat));
                                list.add(new Boolean(isPer));
                                list.add(knots);
                                list.add(controlPoints);
                                pathSegments.put("spline", list);
                            }
                            continue block8;
                        }
                        default: {
                            System.out.println("Error leyendo un segmento de hatch:codigo=" + pts);
                        }
                    }
                }
                paths.put("stdpath", pathSegments);
            }
            val = DwgUtil.getBitLong(data, bitPos);
            bitPos = (Integer)val.get(0);
            int nbh = (Integer)val.get(1);
            allBounds += nbh;
        }
        h.setPaths(paths);
        val = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)val.get(0);
        int style = (Integer)val.get(1);
        h.setStyle(style);
        val = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)val.get(0);
        int patternType = (Integer)val.get(1);
        h.setPatterType(patternType);
        if (!solidFill) {
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            double fillAngle = (Double)val.get(1);
            h.setFillAngle(fillAngle);
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            double fillScaleOrSpacion = (Double)val.get(1);
            h.setFillScale(fillScaleOrSpacion);
            val = DwgUtil.testBit(data, bitPos);
            bitPos = (Integer)val.get(0);
            boolean fileDoubleHath = (Boolean)val.get(1);
            h.setFileDoubleHath(fileDoubleHath);
            val = DwgUtil.getBitShort(data, bitPos);
            bitPos = (Integer)val.get(0);
            int ndf = (Integer)val.get(1);
            ArrayList[] lines = new ArrayList[ndf];
            for (int i = 0; i < ndf; ++i) {
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double x = (Double)val.get(1);
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double y = (Double)val.get(1);
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double x0 = (Double)val.get(1);
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double y0 = (Double)val.get(1);
                val = DwgUtil.getBitShort(data, bitPos);
                bitPos = (Integer)val.get(0);
                int numDashes = (Integer)val.get(1);
                double[] dashes = new double[numDashes];
                for (int j = 0; j < numDashes; ++j) {
                    val = DwgUtil.getBitDouble(data, bitPos);
                    bitPos = (Integer)val.get(0);
                    dashes[j] = (Double)val.get(1);
                }
                lines[i] = new ArrayList();
                lines[i].add(new Double(x));
                lines[i].add(new Double(y));
                lines[i].add(new Double(x0));
                lines[i].add(new Double(y0));
                lines[i].add(dashes);
            }
            h.setFillLines(lines);
        }
        if (pixel > 0) {
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            double pixelSize = (Double)val.get(1);
            h.setPixelSize(pixelSize);
        }
        val = DwgUtil.getBitLong(data, bitPos);
        bitPos = (Integer)val.get(0);
        int numSeddPoints = (Integer)val.get(1);
        double[][] seedPoints = new double[2][numSeddPoints];
        for (int j = 0; j < numSeddPoints; ++j) {
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            double x = (Double)val.get(1);
            val = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)val.get(0);
            double y = (Double)val.get(1);
            seedPoints[0][j] = x;
            seedPoints[1][j] = y;
        }
        h.setSeedPoints(seedPoints);
        DwgHandleReference handle = null;
        for (int i = 0; i < h.getNumReactors(); ++i) {
            handle = new DwgHandleReference();
            bitPos = handle.read(data, bitPos);
        }
        handle = new DwgHandleReference();
        bitPos = handle.read(data, bitPos);
        h.setXDicObjHandle(handle);
        handle = new DwgHandleReference();
        bitPos = handle.read(data, bitPos);
        h.setLayerHandle(handle);
        if (!h.isLyrByLineType()) {
            handle = new DwgHandleReference();
            bitPos = handle.read(data, bitPos);
            h.setLineTypeHandle(handle);
        }
        if (!h.isNoLinks()) {
            handle = new DwgHandleReference();
            bitPos = handle.read(data, bitPos);
            h.setPreviousHandle(handle);
            handle = new DwgHandleReference();
            bitPos = handle.read(data, bitPos);
            h.setNextHandle(handle);
        }
        if (allBounds > 0) {
            DwgHandleReference[] handles = new DwgHandleReference[allBounds];
            for (int i = 0; i < allBounds; ++i) {
                handle = new DwgHandleReference();
                bitPos = handle.read(data, bitPos);
                handles[i] = handle;
            }
            h.setBoundaryHandles(handles);
        }
    }
}

