/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.util;

import org.gvsig.dwg.lib.util.Vector3D;

public final class Point3D {
    public double x;
    public double y;
    public double z;

    public Point3D() {
    }

    public Point3D(Point3D p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public Point3D(double xx, double yy, double zz) {
        this.x = xx;
        this.y = yy;
        this.z = zz;
    }

    public void scale(double f) {
        if (f != 1.0) {
            this.x *= f;
            this.y *= f;
            this.z *= f;
        }
    }

    public void add(Vector3D v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public Point3D plus(Vector3D v) {
        Point3D ret = new Point3D(this);
        ret.add(v);
        return ret;
    }

    public void sub(Vector3D v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public Point3D minus(Vector3D v) {
        Point3D ret = new Point3D(this);
        ret.sub(v);
        return ret;
    }

    public Vector3D minus(Point3D p) {
        Vector3D ret = new Vector3D(this);
        ret.sub(new Vector3D(p));
        return ret;
    }

    public String toString() {
        return new String(new StringBuffer().append("[").append(this.x).append(",").append(this.y).append(",").append(this.z).append("]"));
    }
}

