/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.hyperlink.app.extension;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.JPanel;
import org.gvsig.hyperlink.app.extension.LinkTarget;
import org.gvsig.tools.util.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHyperLinkPanel
extends JPanel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractHyperLinkPanel.class);
    protected LinkTarget document;

    public AbstractHyperLinkPanel(LinkTarget linkTarget) {
        this.document = linkTarget;
    }

    public LinkTarget getLinkTarget() {
        return this.document;
    }

    protected boolean checkAndNormalizeURI() {
        if (this.document == null) {
            LOGGER.warn("Hyperlink linked field does not exits");
            return false;
        }
        if (this.document.getURL() != null) {
            try {
                if (!this.document.getURL().toURI().isAbsolute()) {
                    try {
                        File file = this.document.toFile();
                        if (file == null) {
                            LOGGER.warn("Hyperlink can't get file from '" + this.document.getURL() + "'.");
                            return false;
                        }
                        if (!(file = file.getCanonicalFile()).exists()) {
                            LOGGER.warn("Hyperlink linked field, file '" + file + "' not exits");
                            return false;
                        }
                        this.document.setURL(URLUtils.toURL((File)file));
                        return true;
                    }
                    catch (IOException e) {
                        LOGGER.warn("Hyperlink linked field does not exits");
                        return false;
                    }
                }
            }
            catch (URISyntaxException ex) {
                LOGGER.warn("Hyperlink linked field does not exits");
                return false;
            }
        }
        return true;
    }
}

