/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.hyperlink.app.extension;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.hyperlink.app.extension.LinkTarget;
import org.gvsig.tools.util.URLUtils;

public class DefaultLinkTarget
implements LinkTarget {
    private URL url;
    private final String fieldExtension;
    private final FLyrVect _layer;
    private final String fieldName;
    private Object content;
    private String profileName;

    public DefaultLinkTarget(FLyrVect layer, Feature feature, String fieldName, String fieldExtension) {
        String fieldValue;
        this.fieldName = fieldName;
        this.fieldExtension = fieldExtension;
        this._layer = layer;
        this.url = null;
        Object val = feature.get(fieldName);
        String string = fieldValue = val == null ? "" : val.toString();
        if (!fieldValue.equals("")) {
            try {
                URI uri = this.getURI(fieldValue, fieldExtension);
                this.url = uri != null ? uri.toURL() : null;
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(DefaultLinkTarget.class.getName()).log(Level.SEVERE, null, ex);
                this.url = null;
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(DefaultLinkTarget.class.getName()).log(Level.SEVERE, null, ex);
                this.url = null;
            }
            if (this.url == null) {
                FeatureAttributeDescriptor fad;
                try {
                    this.content = feature.getFromProfile(fieldName);
                    fad = feature.getStore().getDefaultFeatureType().getAttributeDescriptor(fieldName);
                }
                catch (DataException ex) {
                    fad = null;
                    Logger.getLogger(DefaultLinkTarget.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.profileName = fad != null ? fad.getDataProfileName() : null;
            }
        }
    }

    protected URI getBasicURI(String baseURI, String extension) throws URISyntaxException {
        File ff;
        ProjectManager projectManager;
        Project project;
        String pathname = StringUtils.isEmpty((CharSequence)extension) ? baseURI : (extension.startsWith(".") ? baseURI + extension : baseURI + "." + extension);
        pathname = pathname.replace("\\", "//");
        if (this._layer.getFeatureStore().getParameters() instanceof FilesystemStoreParameters) {
            FilesystemStoreParameters params = (FilesystemStoreParameters)this._layer.getFeatureStore().getParameters();
            File f = params.getFile();
            URLClassLoader loader = new URLClassLoader(new URL[]{this.toURL(f)});
            URL url = loader.getResource(pathname);
            if (url != null) {
                return url.toURI();
            }
            url = loader.getResource("/" + pathname);
            if (url != null) {
                return url.toURI();
            }
            File ff2 = FileUtils.getFile((File)f.getParentFile(), (String[])new String[]{pathname});
            if (ff2.exists()) {
                return ff2.toURI();
            }
        }
        if ((project = (projectManager = ApplicationLocator.getProjectManager()).getCurrentProject()).getFile() != null && (ff = FileUtils.getFile((File)project.getFile().getParentFile(), (String[])new String[]{pathname})).exists()) {
            return ff.toURI();
        }
        ff = new File(pathname);
        if (ff.exists()) {
            return ff.toURI();
        }
        return null;
    }

    protected URI getURI(String baseURI, String extension) throws URISyntaxException {
        String x;
        if (StringUtils.isEmpty((CharSequence)baseURI)) {
            return null;
        }
        URI uri = this.getBasicURI(baseURI, extension);
        if (uri != null) {
            return uri;
        }
        String value = baseURI.trim();
        Pattern pattern = Pattern.compile(".*<img[^>]*src=\"([^\"]*)\".*", 42);
        Matcher m = pattern.matcher(value);
        if (m != null && m.matches() && !StringUtils.isEmpty((CharSequence)(x = m.group(1))) && (uri = this.getBasicURI(x, extension)) != null) {
            return uri;
        }
        pattern = Pattern.compile(".*<a[^>]*href=\"([^\"]*)\".*", 42);
        m = pattern.matcher(value);
        if (m != null && m.matches() && !StringUtils.isEmpty((CharSequence)(x = m.group(1))) && (uri = this.getBasicURI(x, extension)) != null) {
            return uri;
        }
        try {
            URI createURI = new URI(baseURI);
            return createURI;
        }
        catch (Exception e) {
            return null;
        }
    }

    private URL toURL(File f) {
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public File toFile() {
        return URLUtils.toFile((URL)this.url);
    }

    @Override
    public Object getFromProfile() {
        return this.content;
    }

    @Override
    public String getProfileName() {
        return this.profileName;
    }

    @Override
    public void setURL(URL url) {
        this.url = url;
    }

    @Override
    public URI toURI() {
        try {
            return this.url.toURI();
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }
}

