/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.hyperlink.app.extension;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.toolListeners.InfoListener;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.hyperlink.app.extension.ILinkActionManager;
import org.gvsig.hyperlink.app.extension.LinkTarget;
import org.gvsig.hyperlink.app.extension.ShowPanel;
import org.gvsig.hyperlink.app.extension.config.LayerLinkConfig;
import org.gvsig.hyperlink.app.extension.config.LinkConfig;
import org.gvsig.hyperlink.app.extension.layers.ILinkLayerManager;
import org.gvsig.hyperlink.app.extension.layers.IncompatibleLayerException;
import org.gvsig.hyperlink.app.extension.layers.ManagerRegistry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkListener
implements PointListener {
    private static Logger logger = LoggerFactory.getLogger(InfoListener.class);
    private Cursor cur = null;
    private MapControl mapCtrl;
    private ManagerRegistry registry;
    public static final int TYPELINKIMAGE = 0;
    public static final int TYPELINKTEXT = 1;
    public ExtensionPoint formatManagers;

    public LinkListener(MapControl mc, ManagerRegistry registry) {
        this.mapCtrl = mc;
        this.registry = registry;
        this.formatManagers = ToolsLocator.getExtensionPointManager().get("HyperLinkAction");
        this.initialize();
    }

    private void initialize() {
        this.cur = Toolkit.getDefaultToolkit().createCustomCursor(this.getImageCursor(), new Point(16, 16), "Hyperlink");
    }

    public void point(PointEvent event) throws BehaviorException {
        Point2D pReal = this.mapCtrl.getMapContext().getViewPort().toMapPoint(event.getPoint());
        FLayer[] sel = this.mapCtrl.getMapContext().getLayers().getVisibles();
        LinkTarget[] links = null;
        for (int layerCount = 0; layerCount < sel.length; ++layerCount) {
            FLayer theLayer = sel[layerCount];
            if (!this.registry.hasManager(theLayer)) continue;
            try {
                LayerLinkConfig layerLink;
                ILinkLayerManager layerManager = this.registry.get(theLayer);
                if (theLayer.getProperty((Object)"org.gvsig.hyperlink.config") == null || !(theLayer.getProperty((Object)"org.gvsig.hyperlink.config") instanceof LayerLinkConfig) || !(layerLink = (LayerLinkConfig)theLayer.getProperty((Object)"org.gvsig.hyperlink.config")).isEnabled() || layerLink.linkCount() <= 0) continue;
                double tol = this.mapCtrl.getViewPort().toMapDistance(3);
                for (int actionCount = 0; actionCount < layerLink.linkCount(); ++actionCount) {
                    LinkConfig linkConfig = layerLink.getLink(actionCount);
                    links = layerManager.getLink(pReal, tol, linkConfig.getFieldName(), linkConfig.getExtension());
                    for (int i = 0; i < links.length; ++i) {
                        if (links[i] == null) continue;
                        ILinkActionManager actionManager = (ILinkActionManager)this.formatManagers.get(linkConfig.getActionCode()).getExtension().newInstance();
                        if (actionManager == null) {
                            logger.warn("Hyperlink error -- invalid action code: " + linkConfig.getActionCode());
                            continue;
                        }
                        if (actionManager.hasPanel()) {
                            ShowPanel lpanel = new ShowPanel(actionManager.createPanel(links[i]));
                            PluginServices.getMDIManager().addWindow((IWindow)lpanel);
                            continue;
                        }
                        actionManager.showDocument(links[i]);
                    }
                }
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new BehaviorException("Hyperlink: There is no manager for this layer type", (Throwable)e);
            }
            catch (InstantiationException e) {
                logger.error("Hyperlink error: " + e.getMessage(), (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                logger.error("Hyperlink error: " + e.getMessage(), (Throwable)e);
                continue;
            }
            catch (IncompatibleLayerException e) {
                throw new BehaviorException("Hyperlink: There is no manager for this layer type", (Throwable)e);
            }
        }
    }

    public Cursor getCursor() {
        return this.cur;
    }

    public boolean cancelDrawing() {
        return false;
    }

    public void pointDoubleClick(PointEvent event) throws BehaviorException {
    }

    public Image getImageCursor() {
        return IconThemeHelper.getImage((String)"cursor-view-show-hyperlink");
    }
}

