/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.hyperlink.app.extension.config.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.project.documents.view.legend.gui.AbstractThemeManagerPage;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.hyperlink.app.extension.AbstractActionManager;
import org.gvsig.hyperlink.app.extension.HyperlinkExtension;
import org.gvsig.hyperlink.app.extension.config.LayerLinkConfig;
import org.gvsig.hyperlink.app.extension.config.LinkConfig;
import org.gvsig.hyperlink.app.extension.config.gui.LinkRow;
import org.gvsig.hyperlink.app.extension.layers.ILinkLayerManager;
import org.gvsig.hyperlink.app.extension.layers.IncompatibleLayerException;
import org.gvsig.hyperlink.app.extension.layers.ManagerRegistry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;

public class ConfigTab
extends AbstractThemeManagerPage
implements IWindow,
ActionListener,
ItemListener {
    FLayer layer;
    ArrayList rows = new ArrayList();
    JPanel rowList = null;
    GridBagLayout listLayout = null;
    private String[] actionCodes = null;
    private String[] actionNames = null;
    WindowInfo _windowInfo = null;
    JButton jbt_accept = null;
    JButton jbt_cancel = null;
    JPanel emptyRow;
    JCheckBox jcb_enabled = null;
    JPanel borderPanel = null;
    JButton jbt_addAction = null;
    JButton jbt_removeAction = null;

    public ConfigTab() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(8, 8, 8, 8);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 0;
        constraints.insets = insets;
        constraints.anchor = 18;
        this.add(this.getEnabledCheckBox(), constraints);
        this.borderPanel = new JPanel(new GridBagLayout());
        this.borderPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), PluginServices.getText((Object)this, (String)"Actions"), 0, 0, null, null));
        insets = new Insets(8, 8, 8, 8);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 0;
        constraints.insets = insets;
        constraints.anchor = 18;
        this.borderPanel.add((Component)this.getAddRemoveActionsPanel(), constraints);
        this.listLayout = new GridBagLayout();
        this.rowList = new JPanel(this.listLayout);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.insets = insets;
        constraints.anchor = 15;
        this.emptyRow = new JPanel();
        this.rowList.add((Component)this.emptyRow, constraints);
        JScrollPane scrolledList = new JScrollPane();
        scrolledList.setBorder(null);
        scrolledList.setViewportView(this.rowList);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets = insets;
        constraints.anchor = 10;
        this.borderPanel.add((Component)scrolledList, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets = insets;
        constraints.anchor = 18;
        this.add(this.borderPanel, constraints);
    }

    private void initAcceptCancelButtons() {
        JPanel acceptCancelButtons = new JPanel(new GridBagLayout());
        Insets insets = new Insets(14, 4, 8, 8);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 0;
        constraints.insets = insets;
        constraints.anchor = 13;
        acceptCancelButtons.add((Component)this.getAcceptButton(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.insets = insets;
        constraints.anchor = 13;
        acceptCancelButtons.add((Component)this.getCancelButton(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.insets = insets;
        constraints.anchor = 14;
        this.add(acceptCancelButtons, constraints);
    }

    private String[] getActionNames() {
        if (this.actionNames == null) {
            ExtensionPoint actions = ToolsLocator.getExtensionPointManager().get("HyperLinkAction");
            String[] actionArray = new String[actions.getCount()];
            String[] codes = this.getActionCodes();
            for (int i = 0; i < codes.length; ++i) {
                try {
                    AbstractActionManager aam = (AbstractActionManager)actions.get(codes[i]).getExtension().newInstance();
                    actionArray[i] = aam.getName();
                    continue;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            this.actionNames = actionArray;
        }
        return this.actionNames;
    }

    private String[] getActionCodes() {
        if (this.actionCodes == null) {
            ExtensionPoint actions = ToolsLocator.getExtensionPointManager().get("HyperLinkAction");
            String[] actionArray = new String[actions.getCount()];
            actionArray = actions.getNames().toArray(actionArray);
            this.actionCodes = actionArray;
        }
        return this.actionCodes;
    }

    private String[] getCandidateFields() {
        HyperlinkExtension ext = (HyperlinkExtension)PluginServices.getExtension(HyperlinkExtension.class);
        ManagerRegistry registry = ext.getLayerManager();
        try {
            ILinkLayerManager manager = registry.get(this.layer);
            manager.setLayer(this.layer);
            return manager.getFieldCandidates();
        }
        catch (InstantiationException e) {
            PluginServices.getLogger().warn("Hyperlink: error getting candidate fields", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            PluginServices.getLogger().warn("Hyperlink: error getting candidate fields", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            PluginServices.getLogger().warn("Hyperlink: error getting candidate fields", (Throwable)e);
        }
        catch (IncompatibleLayerException e) {
            PluginServices.getLogger().warn("Hyperlink: error getting candidate fields", (Throwable)e);
        }
        catch (NullPointerException e) {
            PluginServices.getLogger().warn("Hyperlink: error getting manager", (Throwable)e);
        }
        return new String[0];
    }

    public void acceptAction() {
        this.applyAction();
    }

    public void applyAction() {
        LayerLinkConfig config = new LayerLinkConfig();
        for (int i = 0; i < this.rows.size(); ++i) {
            LinkRow row = (LinkRow)this.rows.get(i);
            if (row.getSelectedField() == null || row.getSelectedAction() == -1) continue;
            config.addLink(this.getActionCodes()[row.getSelectedAction()], row.getSelectedField(), row.getExtension());
        }
        config.setEnabled(this.getEnabledCheckBox().isSelected());
        this.layer.setProperty((Object)"org.gvsig.hyperlink.config", (Object)config);
    }

    public void cancelAction() {
    }

    public String getName() {
        return PluginServices.getText((Object)this, (String)"Hyperlink");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(FLayer layer) {
        this.layer = layer;
        if (!(layer == null || layer.isAvailable() && layer instanceof FLyrVect)) {
            this.setLinkEnabled(false);
            this.getEnabledCheckBox().setEnabled(false);
            return;
        }
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            LinkRow row;
            int i;
            HyperlinkExtension ext = (HyperlinkExtension)PluginServices.getExtension(HyperlinkExtension.class);
            LayerLinkConfig layerConfig = ext.loadLegacyConfig(layer);
            for (i = this.rows.size() - 1; i >= 0; --i) {
                row = (LinkRow)this.rows.remove(i);
                this.rowList.remove(row);
            }
            if (layerConfig != null) {
                for (i = 0; i < layerConfig.linkCount(); ++i) {
                    row = this.addRow();
                    LinkConfig config = layerConfig.getLink(i);
                    String selectedAction = config.getActionCode();
                    String[] actions = this.getActionCodes();
                    for (int j = 0; j < actions.length; ++j) {
                        if (!actions[j].equals(selectedAction)) continue;
                        row.setSelectedAction(j);
                    }
                    row.setSelectedField(config.getFieldName());
                    row.setExtension(config.getExtension());
                }
                if (layerConfig.linkCount() < 1) {
                    this.addRow();
                }
                this.setLinkEnabled(layerConfig.isEnabled());
            } else {
                this.addRow();
                this.setLinkEnabled(false);
            }
        }
    }

    protected JPanel getAddRemoveActionsPanel() {
        JPanel container = new JPanel();
        container.add(this.getAddActionButton());
        container.add(this.getRemoveActionButton());
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkRow addRow() {
        LinkRow row = new LinkRow();
        row.setFields(this.getCandidateFields());
        row.setActions(this.getActionNames());
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            this.rows.add(row);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = this.rows.size() - 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.insets = new Insets(2, 4, 2, 4);
            constraints.anchor = 11;
            this.rowList.add((Component)row, constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = this.rows.size();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 0;
            constraints.anchor = 10;
            this.listLayout.setConstraints(this.emptyRow, constraints);
        }
        this.validate();
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeBottomRow() {
        LinkRow row;
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            if (this.rows.size() <= 1) {
                return false;
            }
            row = (LinkRow)this.rows.get(this.rows.size() - 1);
            this.rows.remove(this.rows.size() - 1);
        }
        this.rowList.remove(row);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = this.rows.size();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        this.listLayout.setConstraints(this.emptyRow, constraints);
        this.validate();
        this.repaint();
        return true;
    }

    protected JButton getAddActionButton() {
        if (this.jbt_addAction == null) {
            this.jbt_addAction = new JButton(PluginServices.getText((Object)this, (String)"Add_action"));
            this.jbt_addAction.setSize(150, 70);
            this.jbt_addAction.setActionCommand("addButton");
            this.jbt_addAction.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("addButton")) {
                        ConfigTab.this.addRow();
                    }
                }
            });
        }
        return this.jbt_addAction;
    }

    protected JButton getRemoveActionButton() {
        if (this.jbt_removeAction == null) {
            this.jbt_removeAction = new JButton(PluginServices.getText((Object)this, (String)"Remove_action"));
            this.jbt_removeAction.setActionCommand("removeButton");
            this.jbt_removeAction.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("removeButton")) {
                        ConfigTab.this.removeBottomRow();
                    }
                }
            });
            return this.jbt_removeAction;
        }
        return this.jbt_removeAction;
    }

    public WindowInfo getWindowInfo() {
        if (this._windowInfo == null) {
            this._windowInfo = new WindowInfo(7);
            this._windowInfo.setWidth(680);
            this._windowInfo.setHeight(500);
            this._windowInfo.setTitle(PluginServices.getText((Object)this, (String)"Hyperlink_Settings"));
        }
        return this._windowInfo;
    }

    protected JButton getAcceptButton() {
        if (this.jbt_accept == null) {
            this.jbt_accept = new org.gvsig.gui.beans.swing.JButton(PluginServices.getText((Object)this, (String)"Aceptar"));
            this.jbt_accept.addActionListener(this);
        }
        return this.jbt_accept;
    }

    protected JButton getCancelButton() {
        if (this.jbt_cancel == null) {
            this.jbt_cancel = new org.gvsig.gui.beans.swing.JButton(PluginServices.getText((Object)this, (String)"Cancel"));
            this.jbt_cancel.addActionListener(this);
        }
        return this.jbt_cancel;
    }

    protected JCheckBox getEnabledCheckBox() {
        if (this.jcb_enabled == null) {
            this.jcb_enabled = new JCheckBox(PluginServices.getText((Object)this, (String)"Enable_hyperlink"), true);
            this.jcb_enabled.addItemListener(this);
        }
        return this.jcb_enabled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getAcceptButton()) {
            this.acceptAction();
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        } else if (e.getSource() == this.getCancelButton()) {
            this.cancelAction();
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setListEnabled(boolean enabled) {
        this.getAddActionButton().setEnabled(enabled);
        this.getRemoveActionButton().setEnabled(enabled);
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            for (int i = 0; i < this.rows.size(); ++i) {
                LinkRow row = (LinkRow)this.rows.get(i);
                row.setEnabled(enabled);
            }
        }
    }

    protected void setLinkEnabled(boolean enabled) {
        this.getEnabledCheckBox().setSelected(enabled);
        this.setListEnabled(enabled);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getEnabledCheckBox()) {
            if (e.getStateChange() == 2) {
                this.setListEnabled(false);
            } else {
                this.setListEnabled(true);
            }
        }
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }
}

