/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geometrymeasurement.app.extension;

import java.awt.Component;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.gui.FeatureTableDocumentPanel;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeometryMeasurementExtension
extends Extension {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGeometryMeasurementExtension.class);
    private static boolean isInitialized = false;

    public void initialize() {
        if (!isInitialized) {
            isInitialized = true;
        }
    }

    public boolean isEnabled() {
        String name = "unknow";
        try {
            TableDocument tableDocument = this.getActiveTableDocument();
            if (tableDocument != null) {
                name = tableDocument.getName();
                return tableDocument != null && tableDocument.getStore().allowWrite();
            }
        }
        catch (Throwable e) {
            LOG.info("Error accesing to the table document (" + name + ")", e);
        }
        return false;
    }

    public final boolean isVisible() {
        String name = "unknow";
        try {
            TableDocument tableDocument = this.getActiveTableDocument();
            if (tableDocument != null) {
                name = tableDocument.getName();
                return this.isVisibleForTable(tableDocument);
            }
        }
        catch (Throwable e) {
            LOG.info("Error accesing to the table document (" + name + ")", e);
        }
        return false;
    }

    protected abstract boolean isVisibleForTable(TableDocument var1);

    protected TableDocument getActiveTableDocument() throws DataException {
        FeatureTableDocumentPanel table;
        TableDocument tableDocument;
        IWindow window = PluginServices.getMDIManager().getActiveWindow();
        if (window instanceof FeatureTableDocumentPanel && (tableDocument = (TableDocument)(table = (FeatureTableDocumentPanel)window).getDocument()).getStore().getDefaultFeatureType().getDefaultGeometryAttribute() != null) {
            return tableDocument;
        }
        return null;
    }

    protected boolean isStoreOfAnyType(TableDocument tableDocument, int[] geomTypes) {
        try {
            FeatureType featureType = tableDocument.getStore().getDefaultFeatureType();
            GeometryType geometryType = featureType.getDefaultGeometryAttribute().getGeomType();
            if (geometryType == null) {
                return false;
            }
            for (int i = 0; i < geomTypes.length; ++i) {
                if (!geometryType.isTypeOf(geomTypes[i])) continue;
                return true;
            }
        }
        catch (ReadException e) {
            LOG.error("Error reading the geometry type", (Throwable)e);
        }
        catch (DataException e) {
            LOG.error("Error reading the geometry type", (Throwable)e);
        }
        return false;
    }

    public void execute(String actionCommand) {
        try {
            TableDocument tableDocument = this.getActiveTableDocument();
            if (tableDocument == null) {
                return;
            }
            Component parentWindow = (Component)ApplicationLocator.getManager().getUIManager().getActiveWindow();
            int addField = JOptionPane.showConfirmDialog(parentWindow, Messages.getText((String)"new_field_query"), Messages.getText((String)"info"), 0);
            if (addField == 0) {
                FeatureStore featureStore = tableDocument.getStore();
                this.execute(actionCommand, featureStore);
            }
        }
        catch (Exception e) {
            LOG.error("Not possible to add the new field", (Throwable)e);
            NotificationManager.addError((Throwable)e);
        }
    }

    protected abstract void execute(String var1, FeatureStore var2) throws Exception;
}

