/*
 * Decompiled with CFR 0.152.
 */
package gishur.awt;

import gishur.awt.ToolTip;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ToolTipper
extends Canvas
implements Runnable,
MouseListener,
MouseMotionListener,
ContainerListener {
    public static final byte TOOLTIP_LOWER_RIGHT = 1;
    public static final byte TOOLTIP_UPPER_RIGHT = 2;
    public static final byte TOOLTIP_LOWER_LEFT = 3;
    public static final byte TOOLTIP_UPPER_LEFT = 4;
    private Container _container;
    private Applet _applet;
    private long _sleeptime = 1000L;
    private long _showtime = 10000L;
    private MouseEvent _lastmouse = null;
    private String _tip;
    public static int TIP_SPACE = 3;
    public Font tip_font = new Font("Helvetica", 0, 10);
    public Color backcolor = new Color(255, 255, 231);
    public Color textcolor = Color.black;
    private int _mouse_distance_x = 0;
    private int _mouse_distance_y = 20;
    private byte _tip_alignment = 1;
    private boolean wake_me_up = true;

    private void removeFromContainer(Container container) {
        container.removeContainerListener(this);
        container.removeMouseMotionListener(this);
        container.removeMouseListener(this);
        if (container.getComponentCount() <= 0) {
            return;
        }
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] != null && !(componentArray[n] instanceof ToolTipper)) {
                if (componentArray[n] instanceof Container) {
                    this.removeFromContainer((Container)componentArray[n]);
                } else {
                    componentArray[n].removeMouseMotionListener(this);
                    componentArray[n].removeMouseListener(this);
                }
            }
            ++n;
        }
    }

    public byte getToolTipAlignment() {
        return this._tip_alignment;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void setToolTipAlignment(byte by) {
        if (by != 3 && by != 1 && by != 4 && by != 2) {
            return;
        }
        this._tip_alignment = by;
    }

    public ToolTipper(Container container, Applet applet) {
        if (container == null) {
            throw new IllegalArgumentException();
        }
        this._container = container;
        this._applet = applet;
        this.setVisible(false);
        this._container.add((Component)this, 0);
        this.addToContainer(this._container);
        new Thread(this).start();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (this._applet != null && component instanceof ToolTip) {
            this._applet.showStatus(((ToolTip)((Object)component)).getStatusTip(mouseEvent.getX(), mouseEvent.getY()));
        }
        if (this.wake_me_up) {
            ToolTipper toolTipper = this;
            synchronized (toolTipper) {
                this.notifyAll();
                Object var4_4 = null;
            }
        }
        this._lastmouse = mouseEvent;
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof Container) {
            this.removeFromContainer((Container)containerEvent.getChild());
            return;
        }
        if (!(containerEvent.getChild() instanceof ToolTipper)) {
            containerEvent.getChild().removeMouseMotionListener(this);
        }
    }

    public ToolTipper(Container container) {
        this(container, null);
    }

    public void paint(Graphics graphics) {
        if (this._tip == null || this._tip == "") {
            return;
        }
        Rectangle rectangle = this.getBounds();
        graphics.setColor(this.backcolor);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(this.textcolor);
        graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        graphics.setFont(this.tip_font);
        graphics.drawString(this._tip, TIP_SPACE, rectangle.height - TIP_SPACE - 1);
    }

    public void setSleeptime(long l) {
        if (l <= 0L) {
            return;
        }
        this._sleeptime = l;
    }

    public long showtime() {
        return this._showtime;
    }

    public int getToolTipXDistance() {
        return this._mouse_distance_x;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this._applet != null) {
            this._applet.showStatus("");
        }
        if (this.wake_me_up) {
            ToolTipper toolTipper = this;
            synchronized (toolTipper) {
                this.notify();
                Object var3_3 = null;
            }
        }
        this._lastmouse = null;
    }

    private boolean getTip() {
        this._tip = null;
        if (this._lastmouse == null) {
            return false;
        }
        if (!(this._lastmouse.getComponent() instanceof ToolTip)) {
            return false;
        }
        this._tip = ((ToolTip)((Object)this._lastmouse.getComponent())).getToolTip(this._lastmouse.getX(), this._lastmouse.getY());
        return this._tip != null && this._tip != "";
    }

    private void showTip() {
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.tip_font);
        this.setSize(fontMetrics.stringWidth(this._tip) + 3 * TIP_SPACE, fontMetrics.getHeight() + TIP_SPACE);
        Point point = this._container.getLocationOnScreen();
        Point point2 = this._lastmouse.getComponent().getLocationOnScreen();
        point.x = point2.x - point.x + this._lastmouse.getX();
        point.y = point2.y - point.y + this._lastmouse.getY();
        Rectangle rectangle = this.getToolTipPosition(new Rectangle(this.getBounds()), point.x, point.y, this._tip_alignment);
        Rectangle rectangle2 = this._container.getBounds();
        if (rectangle.y < 0) {
            rectangle = this.getToolTipPosition(rectangle, point.x, point.y, this._tip_alignment == 2 ? (byte)1 : 3);
        } else if (rectangle.y + rectangle.height > rectangle2.height) {
            rectangle = this.getToolTipPosition(rectangle, point.x, point.y, this._tip_alignment == 1 ? (byte)2 : 4);
        }
        if (rectangle.x < 0) {
            rectangle = this.getToolTipPosition(rectangle, point.x, point.y, this._tip_alignment == 4 ? (byte)2 : 1);
        } else if (rectangle.x + rectangle.width > rectangle2.width) {
            rectangle = this.getToolTipPosition(rectangle, point.x, point.y, this._tip_alignment == 1 ? (byte)3 : 4);
            if (rectangle.x < 0) {
                rectangle = this.getToolTipPosition(rectangle, point.x, point.y, this._tip_alignment == 4 ? (byte)2 : 1);
            }
        }
        this.setLocation(rectangle.x, rectangle.y);
        this.setVisible(true);
        this.repaint();
    }

    private void addToContainer(Container container) {
        container.addContainerListener(this);
        container.addMouseMotionListener(this);
        container.addMouseListener(this);
        if (container.getComponentCount() <= 0) {
            return;
        }
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] != null && !(componentArray[n] instanceof ToolTipper)) {
                if (componentArray[n] instanceof Container) {
                    this.addToContainer((Container)componentArray[n]);
                } else {
                    componentArray[n].addMouseMotionListener(this);
                    componentArray[n].addMouseListener(this);
                }
            }
            ++n;
        }
    }

    public long sleeptime() {
        return this._sleeptime;
    }

    public void setShowtime(long l) {
        if (l <= 0L) {
            return;
        }
        this._showtime = l;
    }

    public int getToolTipYDistance() {
        return this._mouse_distance_y;
    }

    public void setToolTipMouseDistance(int n, int n2) {
        this._mouse_distance_x = n;
        this._mouse_distance_y = n2;
    }

    public synchronized void run() {
        Thread.currentThread().setPriority(1);
        long l = 0L;
        while (true) {
            try {
                while (true) {
                    this.wake_me_up = true;
                    this.wait();
                    this.wake_me_up = false;
                    while ((l = this._lastmouse == null ? this._sleeptime : System.currentTimeMillis() - this._lastmouse.getWhen()) < this._sleeptime) {
                        this.wait(Math.max(1L, this._sleeptime - l));
                    }
                    this.wake_me_up = true;
                    String string = null;
                    while (this.getTip()) {
                        if (this._tip != string) {
                            this.setVisible(false);
                            this.showTip();
                        }
                        this._lastmouse = null;
                        this.wait(Math.max(1L, this._showtime - l));
                        string = this._tip;
                    }
                    this.setVisible(false);
                }
            }
            catch (Exception exception) {
                System.err.println(this.getClass().getName() + ".run(): " + exception);
                continue;
            }
            break;
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof Container) {
            this.addToContainer((Container)containerEvent.getChild());
            return;
        }
        if (!(containerEvent.getChild() instanceof ToolTipper)) {
            containerEvent.getChild().addMouseMotionListener(this);
        }
    }

    private Rectangle getToolTipPosition(Rectangle rectangle, int n, int n2, byte by) {
        switch (by) {
            case 1: {
                rectangle.setLocation(n + this._mouse_distance_x, n2 + this._mouse_distance_y);
                break;
            }
            case 2: {
                rectangle.setLocation(n + this._mouse_distance_x, n2 - rectangle.height - this._mouse_distance_y);
                break;
            }
            case 3: {
                rectangle.setLocation(n - rectangle.width - this._mouse_distance_x, n2 + this._mouse_distance_y);
                break;
            }
            case 4: {
                rectangle.setLocation(n - rectangle.width - this._mouse_distance_x, n2 - rectangle.height - this._mouse_distance_y);
            }
        }
        return rectangle;
    }
}

