/*
 * Decompiled with CFR 0.152.
 */
package gishur.core;

import gishur.core.Comparitor;
import gishur.core.LinkException;
import gishur.core.ListItem;
import gishur.core.Owner;
import gishur.core.SimpleListItem;
import gishur.core.StdListItem;
import gishur.core.TreeItem;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class BasicTree
implements Owner,
Serializable {
    protected static final byte NO_ACCESS = 0;
    protected static final byte ANY_ACCESS = 1;
    protected static final byte TREEITEM = 0;
    protected static final byte KEY = 1;
    protected static final byte VALUE = 2;
    public static final byte CHILDS_ROOT_ORDER = 1;
    public static final byte ROOT_CHILDS_ORDER = 2;
    public static final byte LEFT_ROOT_RIGHT_ORDER = 3;
    public static final byte LEFT_RIGHT_ROOT_ORDER = 4;
    public static final byte ROOT_LEFT_RIGHT_ORDER = 5;
    private TreeItem _root = null;
    private int _length = 0;
    protected byte _access = 0;

    protected Enumeration emptyEnumeration() {
        return new TreeEnumerator();
    }

    public synchronized TreeItem double_rotation(TreeItem treeItem, int n, int n2) {
        if (!this.contains(treeItem)) {
            return null;
        }
        TreeItem treeItem2 = treeItem.child(n);
        TreeItem treeItem3 = treeItem.parent();
        TreeItem treeItem4 = treeItem2.child(n2);
        if (treeItem2 == null || treeItem4 == null) {
            return treeItem;
        }
        this.allowAccess((byte)1);
        if (!treeItem.connect(treeItem4.child(n2), n)) {
            this.throwException(new LinkException(1537, treeItem, treeItem4.child(n2)));
        }
        if (!treeItem2.connect(treeItem4.child(n), n2)) {
            this.throwException(new LinkException(1537, treeItem, treeItem4.child(n)));
        }
        if (!treeItem4.connect(treeItem, n2)) {
            this.throwException(new LinkException(1537, treeItem4, treeItem));
        }
        if (!treeItem4.connect(treeItem2, n)) {
            this.throwException(new LinkException(1537, treeItem4, treeItem2));
        }
        if (treeItem3 == null) {
            this._root = treeItem4;
            if (!treeItem4.connect(null, -1)) {
                this.throwException(new LinkException(1537, null, treeItem2));
            }
        } else if (!treeItem3.connect(treeItem4, treeItem3.pos(treeItem))) {
            this.throwException(new LinkException(1537, treeItem3, treeItem4));
        }
        this.allowAccess((byte)0);
        return treeItem4;
    }

    protected ListItem getListItemChain(TreeItem treeItem, byte by) {
        if (treeItem == null) {
            treeItem = this._root;
        }
        TreeItem treeItem2 = this.first(treeItem, by);
        ListItem listItem = null;
        ListItem listItem2 = null;
        while (treeItem2 != null) {
            ListItem listItem3;
            if (treeItem2 instanceof ListItem) {
                listItem3 = (ListItem)((Object)treeItem2);
                if (!listItem3.setOwningList(null) && !(listItem3 = (ListItem)treeItem2.clone(null, 1)).setOwningList(null)) {
                    listItem3 = new StdListItem(treeItem2.key(), treeItem2.value());
                }
            } else {
                listItem3 = treeItem2.key() == treeItem2.value() ? new SimpleListItem(treeItem2.key()) : new StdListItem(treeItem2.key(), treeItem2.value());
            }
            listItem3.connect(listItem2, false);
            if (listItem == null) {
                listItem = listItem3;
            }
            listItem2 = listItem3;
            treeItem2 = this.next(treeItem, treeItem2, by);
        }
        return listItem;
    }

    protected Enumeration enumerate(TreeItem treeItem, byte by, boolean bl, byte by2) {
        return new TreeEnumerator(treeItem, by, bl, by2);
    }

    protected Enumeration enumerate(TreeItem treeItem, TreeItem treeItem2, byte by, byte by2) {
        return new TreeEnumerator(treeItem, treeItem2, by, by2);
    }

    protected int cutTree(TreeItem treeItem) {
        if (treeItem == null) {
            treeItem = this._root;
        } else if (!this.contains(treeItem)) {
            return 0;
        }
        this.allowAccess((byte)1);
        if (!treeItem.cut()) {
            this.throwException(new LinkException(1537, null, treeItem));
        }
        TreeItem treeItem2 = this.first(treeItem, (byte)1);
        int n = 0;
        while (treeItem2 != null) {
            if (!treeItem2.setOwningTree(null)) {
                this.throwException(new LinkException(1538, treeItem2));
            }
            treeItem2 = this.next(treeItem, treeItem2, (byte)1);
            ++n;
        }
        this._length -= n;
        this.allowAccess((byte)0);
        return n;
    }

    protected synchronized TreeItem add(TreeItem treeItem, TreeItem treeItem2, int n) {
        if (treeItem == null) {
            return null;
        }
        treeItem = this.ownTree(treeItem, this);
        this._length += this.connect(treeItem, treeItem2, n);
        return treeItem;
    }

    protected synchronized TreeItem add(TreeItem treeItem, Comparitor comparitor, boolean bl, boolean bl2) {
        TreeItem treeItem2 = this.find(treeItem, null, comparitor, bl);
        if (treeItem2 == null) {
            return this.add(treeItem, null, 0);
        }
        short s = comparitor.compare(treeItem, treeItem2);
        if (!bl2 && s == 0) {
            TreeItem treeItem3;
            this.allowAccess((byte)1);
            if (!treeItem.setOwningTree(this) && !(treeItem = (TreeItem)treeItem.clone(null, 1)).setOwningTree(this)) {
                this.throwException(new LinkException(1538, treeItem));
            }
            if ((treeItem3 = treeItem2.parent()) != null) {
                if (!treeItem3.connect(treeItem, treeItem3.pos(treeItem2))) {
                    this.throwException(new LinkException(1537, treeItem3, treeItem));
                }
            } else {
                if (!treeItem2.connect(null, -1)) {
                    this.throwException(new LinkException(1537, null, treeItem2));
                }
                this._root = treeItem2;
            }
            int n = 0;
            while (n < treeItem.maxRank()) {
                if (!treeItem.connect(treeItem2.child(n), n)) {
                    this.throwException(new LinkException(1537, treeItem, treeItem2.child(n)));
                }
                ++n;
            }
            this.allowAccess((byte)0);
            return treeItem2;
        }
        int n = 0;
        if (s == 1) {
            n = 1;
        }
        return this.add(treeItem, treeItem2, n);
    }

    protected synchronized TreeItem removeSym(TreeItem treeItem) {
        TreeItem treeItem2 = this.getRemovableTreeItem(treeItem);
        if (treeItem2 == null) {
            return null;
        }
        if (treeItem2 == treeItem) {
            TreeItem treeItem3 = treeItem.child(treeItem.nextChildPos(0));
            if (treeItem.parent() == null) {
                this._root = treeItem3;
            }
            this.allowAccess((byte)1);
            treeItem.remove();
            this.allowAccess((byte)0);
        } else {
            this.fitInPlace(treeItem2, treeItem);
        }
        this.allowAccess((byte)1);
        if (!treeItem.setOwningTree(null)) {
            this.throwException(new LinkException(1538, treeItem));
        }
        if (!treeItem.clearConnections()) {
            this.throwException(new LinkException(1539, treeItem));
        }
        this._length += -1;
        this.allowAccess((byte)0);
        return treeItem;
    }

    protected int countItems(TreeItem treeItem) {
        if (treeItem == null) {
            return 0;
        }
        TreeItem treeItem2 = this.first(treeItem, (byte)2);
        int n = 0;
        while (treeItem2 != null) {
            treeItem2 = this.next(treeItem, treeItem2, (byte)2);
            ++n;
        }
        return n;
    }

    protected void allowAccess(byte by) {
        this._access = by;
    }

    protected TreeItem findLast(TreeItem treeItem, int n) {
        if (treeItem == null) {
            treeItem = this._root;
        }
        TreeItem treeItem2 = null;
        while (treeItem != null) {
            treeItem2 = treeItem;
            treeItem = treeItem.child(n);
        }
        return treeItem2;
    }

    protected TreeItem last(TreeItem treeItem, byte by) {
        if (treeItem == null) {
            treeItem = this._root;
        }
        switch (by) {
            case 3: 
            case 5: {
                return this.findLast(treeItem, 1);
            }
            case 2: {
                return this.findLast(treeItem, -2);
            }
            case 1: 
            case 4: {
                return treeItem;
            }
        }
        return null;
    }

    protected int storeInArray(Object[] objectArray, int n, int n2, TreeItem treeItem, byte by, byte by2) {
        if (objectArray == null) {
            return 0;
        }
        if (treeItem == null) {
            treeItem = this._root;
        }
        int n3 = n;
        int n4 = 0;
        TreeItem treeItem2 = this.first(treeItem, by);
        while (treeItem2 != null && n2 > 0) {
            switch (by2) {
                case 0: {
                    objectArray[n3] = treeItem2;
                    break;
                }
                case 1: {
                    objectArray[n3] = treeItem2.key();
                    break;
                }
                case 2: {
                    objectArray[n3] = treeItem2.value();
                }
            }
            treeItem2 = this.next(treeItem, treeItem2, by);
            ++n3;
            --n2;
            ++n4;
        }
        return n4;
    }

    protected synchronized TreeItem ownTree(TreeItem treeItem, Owner owner, Hashtable hashtable, int n) {
        if (owner == this) {
            this.allowAccess((byte)1);
        }
        TreeItem treeItem2 = treeItem;
        TreeItem treeItem3 = null;
        TreeItem treeItem4 = null;
        TreeItem treeItem5 = null;
        int n2 = 0;
        while (treeItem2 != null) {
            TreeItem treeItem6 = treeItem2;
            if (!treeItem6.setOwningTree(owner)) {
                if (!(treeItem6 = (TreeItem)treeItem6.clone(hashtable, n)).setOwningTree(owner)) {
                    this.throwException(new LinkException(1538, treeItem6));
                }
                if (treeItem4 == null) {
                    if (!treeItem6.connect(null, -1)) {
                        this.throwException(new LinkException(1537, null, treeItem6));
                    }
                } else if (!treeItem4.connect(treeItem6, n2)) {
                    this.throwException(new LinkException(1537, treeItem4, treeItem6));
                }
            }
            if (treeItem5 == null) {
                treeItem5 = treeItem6;
            }
            if (treeItem2.isLeaf()) {
                treeItem4 = treeItem6;
                do {
                    treeItem3 = treeItem2;
                    if (treeItem2 != treeItem) {
                        treeItem2 = treeItem2.parent();
                        treeItem4 = treeItem4.parent();
                        continue;
                    }
                    treeItem2 = null;
                } while (treeItem2 != null && treeItem2.nextChildPos(treeItem2.pos(treeItem3) + 1) == -3);
                if (treeItem2 == null) continue;
                n2 = treeItem2.nextChildPos(treeItem2.pos(treeItem3) + 1);
                treeItem3 = treeItem2;
                treeItem2 = treeItem2.child(n2);
                continue;
            }
            n2 = treeItem2.nextChildPos(0);
            treeItem4 = treeItem6;
            treeItem3 = treeItem2;
            treeItem2 = treeItem2.child(n2);
        }
        if (owner == this) {
            this.allowAccess((byte)0);
        }
        return treeItem5;
    }

    protected synchronized TreeItem ownTree(TreeItem treeItem, Owner owner) {
        return this.ownTree(treeItem, owner, null, 1);
    }

    protected TreeItem root() {
        return this._root;
    }

    protected Object clone(Hashtable hashtable, int n) {
        try {
            TreeItem treeItem;
            BasicTree basicTree;
            if (hashtable == null && n != 1) {
                hashtable = new Hashtable<BasicTree, BasicTree>();
            }
            if (hashtable != null && hashtable.containsKey(this)) {
                return hashtable.get(this);
            }
            BasicTree basicTree2 = this;
            synchronized (basicTree2) {
                basicTree = (BasicTree)super.clone();
                if (hashtable != null) {
                    hashtable.put(this, basicTree);
                }
                treeItem = this.copy(this._root, hashtable, n);
                Object var7_6 = null;
            }
            basicTree.allowAccess((byte)1);
            basicTree._root = treeItem;
            TreeItem treeItem2 = treeItem;
            while (treeItem2 != null) {
                treeItem2.setOwningTree(basicTree);
                treeItem2 = basicTree.next(this._root, treeItem2, (byte)2);
            }
            basicTree.allowAccess((byte)0);
            return basicTree;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Error while cloning");
        }
    }

    protected String getTreeString(boolean bl, String string, String string2, String string3, String string4, String string5) {
        if (this._length <= 0) {
            return "";
        }
        String[] stringArray = new String[this._length];
        boolean[] blArray = new boolean[this._length];
        int n = 0;
        int n2 = 0;
        TreeItem treeItem = this._root;
        TreeItem treeItem2 = null;
        while (treeItem != null) {
            int n3;
            stringArray[n] = "";
            int n4 = 0;
            while (n4 < n2 - 1) {
                if (blArray[n4]) {
                    int n5 = n;
                    stringArray[n5] = stringArray[n5] + string2;
                } else {
                    int n6 = n;
                    stringArray[n6] = stringArray[n6] + string3;
                }
                ++n4;
            }
            if (n2 > 0) {
                if (blArray[n2 - 1]) {
                    int n7 = n;
                    stringArray[n7] = stringArray[n7] + string4;
                } else {
                    int n8 = n;
                    stringArray[n8] = stringArray[n8] + string5;
                }
            }
            if (bl) {
                int n9 = n;
                stringArray[n9] = stringArray[n9] + treeItem;
            } else if (treeItem.value() != treeItem.key()) {
                int n10 = n;
                stringArray[n10] = stringArray[n10] + "(" + treeItem.key() + "," + treeItem.value() + ")";
            } else {
                int n11 = n;
                stringArray[n11] = stringArray[n11] + treeItem.key();
            }
            do {
                n3 = treeItem.nextChildPos(treeItem.pos(treeItem2) + 1);
                treeItem2 = treeItem;
                if (n3 == -3) {
                    treeItem = treeItem.parent();
                    --n2;
                    continue;
                }
                blArray[n2] = treeItem.nextChildPos(n3 + 1) != -3;
                treeItem = treeItem.child(n3);
                ++n2;
            } while (treeItem != null && n3 == -3);
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        n = 0;
        while (n < this._length) {
            stringBuffer.append(string);
            stringBuffer.append(stringArray[n]);
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    protected int length() {
        return this._length;
    }

    protected int height(TreeItem treeItem) {
        if (treeItem == null) {
            treeItem = this._root;
        }
        if (treeItem == null) {
            return 0;
        }
        TreeItem treeItem2 = treeItem;
        int n = 0;
        int n2 = 0;
        while (treeItem2 != null) {
            if (n > n2) {
                n2 = n;
            }
            if (treeItem2.isLeaf()) {
                TreeItem treeItem3;
                do {
                    treeItem3 = treeItem2;
                    --n;
                } while ((treeItem2 = treeItem2 != treeItem ? treeItem2.parent() : null) != null && treeItem2.nextChildPos(treeItem2.pos(treeItem3) + 1) == -3);
                if (treeItem2 == null) continue;
                treeItem2 = treeItem2.child(treeItem2.nextChildPos(treeItem2.pos(treeItem3) + 1));
                ++n;
                continue;
            }
            treeItem2 = treeItem2.child(treeItem2.nextChildPos(0));
            ++n;
        }
        return n2 + 1;
    }

    private void throwException(RuntimeException runtimeException) {
        this.allowAccess((byte)0);
        throw runtimeException;
    }

    public String toString() {
        return this.getClass().getName() + "[length=" + this._length + ",{" + this.getTreeString(false, "   ", "|  ", "   ", "|- ", "^- ") + "}]";
    }

    protected BasicTree() {
    }

    protected boolean contains(TreeItem treeItem) {
        return treeItem != null && treeItem.getOwningTree() == this;
    }

    protected TreeItem first(TreeItem treeItem, byte by) {
        if (treeItem == null) {
            treeItem = this._root;
        }
        switch (by) {
            case 3: {
                return this.findLast(treeItem, 0);
            }
            case 4: {
                TreeItem treeItem2 = this.findLast(treeItem, 0);
                if (treeItem2 != null && treeItem2.child(1) != null) {
                    while ((treeItem2 = this.findLast(treeItem2.child(1), 0)).child(1) != null) {
                    }
                }
                return treeItem2;
            }
            case 1: {
                TreeItem treeItem3 = this.findLast(treeItem, 0);
                if (treeItem3 != null && treeItem3.nextChildPos(1) != -3) {
                    while ((treeItem3 = this.findLast(treeItem3.child(treeItem3.nextChildPos(1)), 0)).nextChildPos(1) != -3) {
                    }
                }
                return treeItem3;
            }
            case 2: 
            case 5: {
                return treeItem;
            }
        }
        return null;
    }

    protected TreeItem getRemovableTreeItem(TreeItem treeItem) {
        if (!this.contains(treeItem)) {
            return null;
        }
        if (treeItem.rank() < 2) {
            return treeItem;
        }
        TreeItem treeItem2 = treeItem.parent();
        int n = treeItem2 != null ? treeItem2.pos(treeItem) : 1;
        return this.findLast(treeItem.child(n), n == 1 ? 0 : 1);
    }

    protected TreeItem copy(TreeItem treeItem, Hashtable hashtable, int n) {
        if (this.empty()) {
            return null;
        }
        if (treeItem == null) {
            treeItem = this._root;
        } else if (!this.contains(treeItem)) {
            return null;
        }
        TreeItem treeItem2 = (TreeItem)treeItem.clone(hashtable, n);
        TreeItem treeItem3 = treeItem;
        TreeItem treeItem4 = treeItem2;
        while (treeItem3 != null) {
            int n2 = 0;
            while (n2 < treeItem3.maxRank()) {
                if (treeItem3.child(n2) != null) {
                    treeItem4.connect((TreeItem)treeItem3.child(n2).clone(hashtable, n), n2);
                } else {
                    treeItem4.connect(null, n2);
                }
                ++n2;
            }
            if (treeItem3.isLeaf()) {
                TreeItem treeItem5;
                do {
                    treeItem5 = treeItem3;
                    if (treeItem3 != treeItem) {
                        treeItem3 = treeItem3.parent();
                        treeItem4 = treeItem4.parent();
                        continue;
                    }
                    treeItem3 = null;
                } while (treeItem3 != null && treeItem3.nextChildPos(treeItem3.pos(treeItem5) + 1) == -3);
                if (treeItem3 == null) continue;
                n2 = treeItem3.nextChildPos(treeItem3.pos(treeItem5) + 1);
                treeItem3 = treeItem3.child(n2);
                treeItem4 = treeItem4.child(n2);
                continue;
            }
            n2 = treeItem3.nextChildPos(0);
            treeItem3 = treeItem3.child(n2);
            treeItem4 = treeItem4.child(n2);
        }
        return treeItem2;
    }

    public boolean requestAccess(int n, Object object, Object object2) {
        if (this._access == 1) {
            return true;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 101: 
            case 102: {
                return false;
            }
            case 103: {
                int n2 = ((Number)object2).intValue();
                TreeItem treeItem = (TreeItem)object;
                return n2 >= treeItem.maxRank();
            }
        }
        return true;
    }

    protected TreeItem next(TreeItem treeItem, TreeItem treeItem2, byte by) {
        if (treeItem2 == null) {
            return this.first(treeItem, by);
        }
        if (treeItem == null) {
            treeItem = this._root;
        }
        TreeItem treeItem3 = null;
        switch (by) {
            case 3: {
                if (treeItem2.child(1) == null) {
                    do {
                        treeItem3 = treeItem2;
                    } while ((treeItem2 = treeItem2 != treeItem ? treeItem2.parent() : null) != null && treeItem2.pos(treeItem3) != 0);
                    break;
                }
                treeItem2 = this.findLast(treeItem2.child(1), 0);
                break;
            }
            case 5: {
                if (treeItem2.child(0) == null) {
                    if (treeItem2.child(1) == null) {
                        do {
                            treeItem3 = treeItem2;
                        } while ((treeItem2 = treeItem2 != treeItem ? treeItem2.parent() : null) != null && (treeItem2.child(1) == treeItem3 || treeItem2.child(1) == null));
                        if (treeItem2 == null) break;
                        treeItem2 = treeItem2.child(1);
                        break;
                    }
                    treeItem2 = treeItem2.child(1);
                    break;
                }
                treeItem2 = treeItem2.child(0);
                break;
            }
            case 4: {
                treeItem3 = treeItem2;
                treeItem2 = treeItem2 != treeItem ? treeItem2.parent() : null;
                if (treeItem2 == null || treeItem2.child(1) == null || treeItem2.child(1) == treeItem3) break;
                while ((treeItem2 = this.findLast(treeItem2.child(1), 0)).child(1) != null) {
                }
                break;
            }
            case 2: {
                if (treeItem2.isLeaf()) {
                    do {
                        treeItem3 = treeItem2;
                    } while ((treeItem2 = treeItem2 != treeItem ? treeItem2.parent() : null) != null && treeItem2.nextChildPos(treeItem2.pos(treeItem3) + 1) == -3);
                    if (treeItem2 == null) break;
                    treeItem2 = treeItem2.child(treeItem2.nextChildPos(treeItem2.pos(treeItem3) + 1));
                    break;
                }
                treeItem2 = treeItem2.child(treeItem2.nextChildPos(0));
                break;
            }
            case 1: {
                treeItem3 = treeItem2;
                treeItem2 = treeItem2 != treeItem ? treeItem2.parent() : null;
                if (treeItem2 == null) break;
                int n = treeItem2.nextChildPos(treeItem2.pos(treeItem3) + 1);
                while (n != -3) {
                    treeItem2 = treeItem2.child(n);
                    n = treeItem2.nextChildPos(0);
                }
                break;
            }
        }
        return treeItem2;
    }

    protected synchronized TreeItem fitInPlace(TreeItem treeItem, TreeItem treeItem2) {
        TreeItem treeItem3 = treeItem.parent();
        this.allowAccess((byte)1);
        TreeItem treeItem4 = treeItem.isLeaf() ? null : treeItem.child(treeItem.nextChildPos(0));
        if (treeItem3 != treeItem && treeItem3 != null && !treeItem3.connect(treeItem4, treeItem3.pos(treeItem))) {
            this.throwException(new LinkException(1537, treeItem3, treeItem4));
        }
        if ((treeItem3 = treeItem2.parent()) == null) {
            if (!treeItem.connect(null, -1)) {
                this.throwException(new LinkException(1537, null, treeItem));
            }
            this._root = treeItem;
        } else if (!treeItem3.connect(treeItem, treeItem3.pos(treeItem2))) {
            this.throwException(new LinkException(1537, treeItem3, treeItem));
        }
        int n = 0;
        while (n < treeItem2.maxRank()) {
            if (treeItem2.child(n) != treeItem) {
                if (!treeItem.connect(treeItem2.child(n), n)) {
                    this.throwException(new LinkException(1537, treeItem, treeItem2.child(n)));
                }
            } else if (!treeItem.connect(treeItem4, n)) {
                this.throwException(new LinkException(1537, treeItem, treeItem4));
            }
            ++n;
        }
        treeItem.setBalance(treeItem2.balance());
        this.allowAccess((byte)0);
        return treeItem2;
    }

    protected boolean empty() {
        return this._length <= 0;
    }

    protected synchronized TreeItem rotation(TreeItem treeItem, int n, int n2) {
        if (!this.contains(treeItem)) {
            return null;
        }
        TreeItem treeItem2 = treeItem.child(n);
        TreeItem treeItem3 = treeItem.parent();
        if (treeItem2 == null) {
            return treeItem;
        }
        this.allowAccess((byte)1);
        if (!treeItem.connect(treeItem2.child(n2), n)) {
            this.throwException(new LinkException(1537, treeItem, treeItem2.child(n2)));
        }
        if (!treeItem2.connect(treeItem, n2)) {
            this.throwException(new LinkException(1537, treeItem2, treeItem));
        }
        if (treeItem3 == null) {
            this._root = treeItem2;
            if (!treeItem2.connect(null, -1)) {
                this.throwException(new LinkException(1537, null, treeItem2));
            }
        } else if (!treeItem3.connect(treeItem2, treeItem3.pos(treeItem))) {
            this.throwException(new LinkException(1537, treeItem3, treeItem2));
        }
        this.allowAccess((byte)0);
        return treeItem2;
    }

    protected int removeTree(TreeItem treeItem) {
        int n = this.cutTree(treeItem);
        TreeItem treeItem2 = this.first(treeItem, (byte)1);
        while (treeItem2 != null) {
            TreeItem treeItem3 = this.next(treeItem, treeItem2, (byte)1);
            if (!treeItem2.clearConnections()) {
                this.throwException(new LinkException(1539, treeItem2));
            }
            treeItem2 = treeItem3;
        }
        return n;
    }

    protected TreeItem find(Object object, TreeItem treeItem) {
        if (treeItem != null && !this.contains(treeItem) || this._root == null) {
            return null;
        }
        TreeItem treeItem2 = this.first(treeItem, (byte)2);
        TreeItem treeItem3 = null;
        while (treeItem2 != null && treeItem3 == null) {
            if (treeItem2.equals(object)) {
                treeItem3 = treeItem2;
            }
            treeItem2 = this.next(treeItem, treeItem2, (byte)2);
        }
        return treeItem3;
    }

    protected TreeItem find(Object object, TreeItem treeItem, Comparitor comparitor, boolean bl) {
        if (treeItem != null && !this.contains(treeItem) || this._root == null) {
            return null;
        }
        if (treeItem == null) {
            treeItem = this._root;
        }
        TreeItem treeItem2 = null;
        TreeItem treeItem3 = treeItem;
        int n = -1;
        int n2 = -1;
        if (!bl) {
            n2 = 1;
        }
        while (treeItem3 != null && n != 0) {
            n = comparitor.compare(object, treeItem3);
            treeItem2 = treeItem3;
            treeItem3 = n == n2 ? treeItem3.child(0) : treeItem3.child(1);
        }
        return treeItem2;
    }

    protected TreeItem prev(TreeItem treeItem, TreeItem treeItem2, byte by) {
        if (treeItem2 == null) {
            return this.last(treeItem, by);
        }
        if (treeItem == null) {
            treeItem = this._root;
        }
        TreeItem treeItem3 = null;
        switch (by) {
            case 3: {
                if (treeItem2.child(0) == null) {
                    do {
                        treeItem3 = treeItem2;
                    } while ((treeItem2 = treeItem2 != treeItem ? treeItem2.parent() : null) != null && treeItem2.pos(treeItem3) != 1);
                    break;
                }
                treeItem2 = this.findLast(treeItem2.child(0), 1);
                break;
            }
            case 5: {
                treeItem3 = treeItem2;
                treeItem2 = treeItem2 != treeItem ? treeItem2.parent() : null;
                if (treeItem2 == null || treeItem2.child(0) == null || treeItem2.child(0) == treeItem3) break;
                while ((treeItem2 = this.findLast(treeItem2.child(0), 1)).child(0) != null) {
                }
                break;
            }
            case 4: {
                if (treeItem2.child(1) == null) {
                    if (treeItem2.child(0) == null) {
                        do {
                            treeItem3 = treeItem2;
                        } while ((treeItem2 = treeItem2 != treeItem ? treeItem2.parent() : null) != null && (treeItem2.child(0) == treeItem3 || treeItem2.child(0) == null));
                        if (treeItem2 == null) break;
                        treeItem2 = treeItem2.child(0);
                        break;
                    }
                    treeItem2 = treeItem2.child(0);
                    break;
                }
                treeItem2 = treeItem2.child(1);
                break;
            }
            case 2: {
                treeItem3 = treeItem2;
                treeItem2 = treeItem2 != treeItem ? treeItem2.parent() : null;
                if (treeItem2 == null) break;
                int n = treeItem2.pos(treeItem3);
                n = n > 0 ? treeItem2.prevChildPos(n - 1) : -3;
                while (n != -3) {
                    treeItem2 = treeItem2.child(n);
                    n = treeItem2.prevChildPos(-2);
                }
                break;
            }
            case 1: {
                if (treeItem2.isLeaf()) {
                    do {
                        treeItem3 = treeItem2;
                    } while ((treeItem2 = treeItem2 != treeItem ? treeItem2.parent() : null) != null && (treeItem2.pos(treeItem3) == 0 || treeItem2.prevChildPos(treeItem2.pos(treeItem3) - 1) == -3));
                    if (treeItem2 == null) break;
                    treeItem2 = treeItem2.child(treeItem2.prevChildPos(treeItem2.pos(treeItem3) - 1));
                    break;
                }
                treeItem2 = treeItem2.child(treeItem2.prevChildPos(-2));
            }
        }
        return treeItem2;
    }

    protected synchronized int connect(TreeItem treeItem, TreeItem treeItem2, int n) {
        if (treeItem2 != null && !this.contains(treeItem2) || !this.contains(treeItem)) {
            return 0;
        }
        this.allowAccess((byte)1);
        int n2 = this.countItems(treeItem);
        TreeItem treeItem3 = this.findLast(treeItem, n);
        if (treeItem2 != null && treeItem2.child(n) != null && !treeItem3.connect(treeItem2.child(n), n)) {
            this.throwException(new LinkException(1537, treeItem3, treeItem2.child(n)));
        }
        if (treeItem2 == null) {
            if (!treeItem3.connect(this._root, n)) {
                this.throwException(new LinkException(1537, treeItem3, this._root));
            }
            this._root = treeItem;
        } else if (!treeItem2.connect(treeItem, n)) {
            this.throwException(new LinkException(1537, treeItem2, treeItem));
        }
        this.allowAccess((byte)0);
        return n2;
    }

    private class TreeEnumerator
    implements Enumeration {
        private TreeItem _t_root;
        private TreeItem _i;
        private TreeItem _end;
        private byte _order;
        private boolean _forward;
        private byte _objecttype;

        public Object nextElement() throws NoSuchElementException {
            if (this._i == null) {
                throw new NoSuchElementException();
            }
            Object object = null;
            switch (this._objecttype) {
                case 1: {
                    object = this._i.key();
                    break;
                }
                case 2: {
                    object = this._i.value();
                    break;
                }
                case 0: {
                    object = this._i;
                }
            }
            this._i = this._i == this._end ? null : (this._forward ? BasicTree.this.next(this._t_root, this._i, this._order) : BasicTree.this.prev(this._t_root, this._i, this._order));
            return object;
        }

        TreeEnumerator() {
            BasicTree.this.getClass();
            this._i = null;
        }

        TreeEnumerator(TreeItem treeItem, byte by, boolean bl, byte by2) {
            BasicTree.this.getClass();
            this._order = by;
            this._objecttype = by2;
            this._forward = bl;
            this._t_root = treeItem;
            this._i = this._forward ? BasicTree.this.first(treeItem, by) : BasicTree.this.last(treeItem, by);
            this._end = null;
        }

        TreeEnumerator(TreeItem treeItem, TreeItem treeItem2, byte by, byte by2) {
            BasicTree.this.getClass();
            this._order = by;
            this._objecttype = by2;
            this._forward = true;
            this._t_root = null;
            this._i = treeItem != null ? treeItem : BasicTree.this.first(null, by);
            this._end = treeItem2;
        }

        public boolean hasMoreElements() {
            return this._i != null;
        }
    }
}

