/*
 * Decompiled with CFR 0.152.
 */
package gishur.core;

import gishur.core.BasicList;
import gishur.core.ControlledCloneable;
import gishur.core.ListException;
import gishur.core.ListItem;
import gishur.core.ListView;
import gishur.core.SimpleListItem;
import java.util.Enumeration;
import java.util.Hashtable;

public class Stack
extends BasicList
implements ControlledCloneable {
    public Object pop() {
        if (super.length() <= 0) {
            throw new ListException(1000);
        }
        ListItem listItem = this.last();
        super.remove(listItem, null, 1);
        return listItem.key();
    }

    public Object[] convertToArray() {
        if (super.length() <= 0) {
            return new Object[0];
        }
        int n = super.length();
        Object[] objectArray = new Object[n];
        this.storeInArray(objectArray, 0, n, this.first(), (byte)1, false);
        return objectArray;
    }

    public Object bottom() {
        if (super.length() > 0) {
            return this.first().key();
        }
        throw new ListException(1000);
    }

    public String toString() {
        if (super.length() > 0) {
            return this.getClass().getName() + "[length=" + super.length() + ",{top=" + this.getListString(",", 0, 2, -1, false, true) + "=bottom}]";
        }
        return this.getClass().getName() + "[length=" + super.length() + "{}]";
    }

    public Object peek() {
        return this.top();
    }

    public int popInt() {
        if (this.top() instanceof Number) {
            return ((Number)this.pop()).intValue();
        }
        throw new ListException(1003, this.top());
    }

    public Object top() {
        if (super.length() > 0) {
            return this.last().key();
        }
        throw new ListException(1000);
    }

    public boolean contains(Object object) {
        return super.find(object, super.first(), null, -1, false) != null;
    }

    public Enumeration elements() {
        return this.enumerate(null, null, -1, (byte)1);
    }

    public void push(Object object) {
        if (super.add(this.last(), this.createNew(object), null, 1) != 1) {
            throw new ListException(1004);
        }
    }

    public void push(int n) {
        this.push(new Integer(n));
    }

    public void push(long l) {
        this.push(new Long(l));
    }

    public void push(float f) {
        this.push(new Float(f));
    }

    public void push(double d) {
        this.push(new Double(d));
    }

    public synchronized ListView getListView() {
        this.allowAccess((byte)1);
        ListView listView = new ListView(this, 1023);
        this.allowAccess((byte)0);
        return listView;
    }

    public void push(boolean bl) {
        this.push(new Boolean(bl));
    }

    public long popLong() {
        if (this.top() instanceof Number) {
            return ((Number)this.pop()).longValue();
        }
        throw new ListException(1003, this.top());
    }

    public float popFloat() {
        if (this.top() instanceof Number) {
            return ((Number)this.pop()).floatValue();
        }
        throw new ListException(1003, this.top());
    }

    public boolean popBoolean() {
        if (this.top() instanceof Boolean) {
            return (Boolean)this.pop();
        }
        throw new ListException(1003, this.top());
    }

    public boolean empty() {
        return super.empty();
    }

    public void clear() {
        super.clear();
    }

    public Object clone(Hashtable hashtable, int n) {
        return super.clone(hashtable, n);
    }

    public Object clone() {
        return super.clone(null, -1);
    }

    private ListItem createNew(Object object) {
        return new SimpleListItem(object);
    }

    public int length() {
        return super.length();
    }

    public double popDouble() {
        if (this.top() instanceof Number) {
            return ((Number)this.pop()).doubleValue();
        }
        throw new ListException(1003, this.top());
    }
}

