/*
 * Decompiled with CFR 0.152.
 */
package gishur.core.math;

import gishur.core.math.MathNumber;

public class DoubleNumber
extends MathNumber {
    private double number;

    public int sign() {
        if (this.number < 0.0) {
            return -1;
        }
        if (this.number > 0.0) {
            return 1;
        }
        return 0;
    }

    public MathNumber log() {
        return new DoubleNumber(Math.log(this.number));
    }

    public double doubleValue() {
        return this.number;
    }

    public DoubleNumber(double d) {
        this.number = d;
    }

    public DoubleNumber(DoubleNumber doubleNumber) {
        this.number = doubleNumber.number;
    }

    public MathNumber negate() {
        return new DoubleNumber(-this.number);
    }

    public MathNumber add(MathNumber mathNumber) {
        return new DoubleNumber(this.number + mathNumber.doubleValue());
    }

    public MathNumber multiply(MathNumber mathNumber) {
        return new DoubleNumber(this.number * mathNumber.doubleValue());
    }

    public MathNumber sqrt() {
        return new DoubleNumber(Math.sqrt(this.number));
    }

    public MathNumber pow(long l) {
        return new DoubleNumber(Math.pow(this.number, l));
    }

    public int compareTo(MathNumber mathNumber) {
        double d = this.number - mathNumber.doubleValue();
        if (d < 0.0) {
            return -1;
        }
        if (d > 0.0) {
            return 1;
        }
        return 0;
    }

    static {
        MathNumber.ZERO = new DoubleNumber(0.0);
        MathNumber.ONE = new DoubleNumber(1.0);
        MathNumber.MINUS_ONE = new DoubleNumber(-1.0);
    }

    public MathNumber invert() {
        return new DoubleNumber(1.0 / this.number);
    }

    public MathNumber abs() {
        if (this.number < 0.0) {
            return this.negate();
        }
        return this;
    }

    public MathNumber divide(MathNumber mathNumber) {
        return new DoubleNumber(this.number / mathNumber.doubleValue());
    }

    public MathNumber subtract(MathNumber mathNumber) {
        return new DoubleNumber(this.number - mathNumber.doubleValue());
    }
}

