/*
 * Decompiled with CFR 0.152.
 */
package gishur.core.math;

import gishur.core.math.MathNumber;
import gishur.core.math.MathNumberException;
import java.math.BigInteger;

public class RationalNumber
extends MathNumber {
    private BigInteger numerator;
    private BigInteger denominator;

    public final void normalize() {
        if (this.numerator == null || this.denominator == null) {
            throw new MathNumberException(1001, this);
        }
        BigInteger bigInteger = this.numerator.gcd(this.denominator);
        this.numerator = this.numerator.divide(bigInteger);
        this.denominator = this.denominator.divide(bigInteger);
        if (this.denominator.signum() == -1) {
            this.numerator = this.numerator.negate();
            this.denominator = this.denominator.negate();
        }
    }

    public int sign() {
        return this.numerator.signum();
    }

    public double doubleValue() {
        return this.numerator.doubleValue() / this.denominator.doubleValue();
    }

    public RationalNumber(long l) {
        this.numerator = BigInteger.valueOf(l);
        this.denominator = BigInteger.valueOf(1L);
    }

    public RationalNumber(long l, long l2) {
        this.numerator = BigInteger.valueOf(l);
        this.denominator = BigInteger.valueOf(l2);
        this.normalize();
    }

    public RationalNumber(BigInteger bigInteger, BigInteger bigInteger2) {
        this.numerator = bigInteger;
        this.denominator = bigInteger2;
        this.normalize();
    }

    public MathNumber negate() {
        return new RationalNumber(this.numerator.negate(), this.denominator);
    }

    public MathNumber add(MathNumber mathNumber) {
        if (!(mathNumber instanceof RationalNumber)) {
            throw new MathNumberException(1003, this, mathNumber);
        }
        RationalNumber rationalNumber = (RationalNumber)mathNumber;
        BigInteger bigInteger = this.numerator.multiply(rationalNumber.denominator);
        BigInteger bigInteger2 = this.denominator.multiply(rationalNumber.numerator);
        return new RationalNumber(bigInteger.add(bigInteger2), this.denominator.multiply(rationalNumber.denominator));
    }

    public MathNumber multiply(MathNumber mathNumber) {
        if (!(mathNumber instanceof RationalNumber)) {
            throw new MathNumberException(1003, this, mathNumber);
        }
        RationalNumber rationalNumber = (RationalNumber)mathNumber;
        return new RationalNumber(this.numerator.multiply(rationalNumber.numerator), this.denominator.multiply(rationalNumber.denominator));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public MathNumber pow(long var1_1) {
        if (var1_1 == 0L) {
            return MathNumber.ONE;
        }
        var3_2 /* !! */  = this;
        if (var1_1 <= 0L) ** GOTO lbl12
        while (var1_1 > 0L) {
            var3_2 /* !! */  = this.multiply(var3_2 /* !! */ );
            --var1_1;
        }
        return var3_2 /* !! */ ;
lbl-1000:
        // 1 sources

        {
            var3_2 /* !! */  = this.multiply(var3_2 /* !! */ );
            ++var1_1;
lbl12:
            // 2 sources

            ** while (var1_1 < 0L)
        }
lbl13:
        // 1 sources

        return var3_2 /* !! */ .invert();
    }

    public BigInteger numerator() {
        return this.numerator;
    }

    static {
        MathNumber.ZERO = new RationalNumber(0L);
        MathNumber.ONE = new RationalNumber(1L);
        MathNumber.MINUS_ONE = new RationalNumber(-1L);
    }

    public MathNumber invert() {
        return new RationalNumber(this.denominator, this.numerator);
    }

    public MathNumber abs() {
        if (this.numerator.signum() == -1) {
            return this.negate();
        }
        return this;
    }

    public MathNumber divide(MathNumber mathNumber) {
        if (!(mathNumber instanceof RationalNumber)) {
            throw new MathNumberException(1003, this, mathNumber);
        }
        RationalNumber rationalNumber = (RationalNumber)mathNumber;
        return new RationalNumber(this.numerator.multiply(rationalNumber.denominator), this.denominator.multiply(rationalNumber.numerator));
    }

    public BigInteger denominator() {
        return this.denominator;
    }

    public MathNumber subtract(MathNumber mathNumber) {
        if (!(mathNumber instanceof RationalNumber)) {
            throw new MathNumberException(1003, this, mathNumber);
        }
        RationalNumber rationalNumber = (RationalNumber)mathNumber;
        BigInteger bigInteger = this.numerator.multiply(rationalNumber.denominator);
        BigInteger bigInteger2 = this.denominator.multiply(rationalNumber.numerator);
        return new RationalNumber(bigInteger.subtract(bigInteger2), this.denominator.multiply(rationalNumber.denominator));
    }
}

