/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dgn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.tools.logger.FilteredLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessGroupOperation {
    private static final Logger logger = LoggerFactory.getLogger(PostProcessGroupOperation.class);
    private int groupByFieldIndex = -1;
    private Map<Object, FeatureProvider> groupedFeatures = null;
    private GeometryManager geomManager = null;
    private int ID_FIELD_GEOMETRY = -1;
    private int MAX_FIELD_ID = -1;
    private int groupGeometriesOperation = -1;
    private Envelope envelope = null;

    public PostProcessGroupOperation(FeatureType featureType, String groupfield, int groupGeometriesOperation) {
        this.groupByFieldIndex = featureType.getIndex(groupfield);
        if (this.groupByFieldIndex < 0) {
            throw new IllegalArgumentException("Can't group by field '" + groupfield + ", the field don't exists.");
        }
        this.geomManager = GeometryLocator.getGeometryManager();
        this.ID_FIELD_GEOMETRY = featureType.getDefaultGeometryAttribute().getIndex();
        this.MAX_FIELD_ID = featureType.size() - 1;
        this.groupGeometriesOperation = groupGeometriesOperation;
    }

    public void add(FeatureProvider data) {
        Object groupbyValue;
        FeatureProvider group;
        if (this.groupedFeatures == null) {
            this.groupedFeatures = new HashMap<Object, FeatureProvider>();
        }
        if ((group = this.groupedFeatures.get(groupbyValue = data.get(this.groupByFieldIndex))) == null) {
            this.groupedFeatures.put(groupbyValue, data);
            MultiPrimitive multi = this.getMultiPrimitive((Geometry)data.get(this.ID_FIELD_GEOMETRY));
            if (multi == null) {
                data.set(this.ID_FIELD_GEOMETRY, null);
            } else {
                data.set(this.ID_FIELD_GEOMETRY, (Object)multi);
            }
            return;
        }
        for (int i = 0; i <= this.MAX_FIELD_ID; ++i) {
            String s;
            Object value = group.get(i);
            if (i == this.ID_FIELD_GEOMETRY) {
                Geometry newgeom = (Geometry)data.get(i);
                if (newgeom == null) continue;
                if (value == null) {
                    group.set(this.ID_FIELD_GEOMETRY, (Object)this.getMultiPrimitive(newgeom));
                    continue;
                }
                try {
                    ((MultiPrimitive)value).addPrimitive((Primitive)newgeom);
                }
                catch (Exception ex) {
                    logger.warn("Can't group geoemtry '" + newgeom.toString() + "' in '" + value.toString() + "'.", (Throwable)ex);
                }
                continue;
            }
            if (value == null) {
                group.set(i, data.get(i));
                continue;
            }
            if (!(value instanceof String) || (s = (String)value).trim().length() != 0) continue;
            group.set(i, data.get(i));
        }
    }

    private MultiPrimitive getMultiPrimitive(Geometry geom) {
        if (geom == null) {
            return null;
        }
        if (geom instanceof MultiPrimitive) {
            return (MultiPrimitive)geom;
        }
        MultiPrimitive multi = null;
        try {
            if (geom instanceof Point) {
                multi = (MultiPrimitive)this.geomManager.create(7, geom.getGeometryType().getSubType());
            } else if (geom instanceof Curve) {
                multi = (MultiPrimitive)this.geomManager.create(8, geom.getGeometryType().getSubType());
            } else if (geom instanceof Surface) {
                multi = (MultiPrimitive)this.geomManager.create(9, geom.getGeometryType().getSubType());
            }
            if (multi != null) {
                multi.addPrimitive((Primitive)geom);
            }
        }
        catch (CreateGeometryException ex) {
            logger.warn("Can't create multi-geometry to group", (Throwable)ex);
        }
        return multi;
    }

    public List<FeatureProvider> getRows() {
        if (this.groupGeometriesOperation < 0) {
            for (FeatureProvider feature : this.groupedFeatures.values()) {
                Geometry geometry = feature.getDefaultGeometry();
                if (geometry == null) continue;
                if (this.envelope == null) {
                    this.envelope = geometry.getEnvelope();
                    continue;
                }
                this.envelope.add(geometry.getEnvelope());
            }
            return (List)this.groupedFeatures.values();
        }
        ArrayList<FeatureProvider> result = new ArrayList<FeatureProvider>();
        FilteredLogger log = new FilteredLogger(logger, "ConsolideGroupBy", 10);
        for (Map.Entry<Object, FeatureProvider> entry : this.groupedFeatures.entrySet()) {
            String groupValue = "<null>";
            if (entry.getKey() != null) {
                groupValue = entry.getKey().toString();
            }
            try {
                FeatureProvider data = entry.getValue();
                Geometry geometry = data.getDefaultGeometry();
                if (geometry != null) {
                    switch (this.groupGeometriesOperation) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            try {
                                geometry = geometry.convexHull();
                                data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                            }
                            catch (Exception ex) {
                                log.warn("Can't create convex-hull with geometries of the group '" + groupValue + "'.", (Throwable)ex);
                            }
                            break;
                        }
                        case 2: {
                            if (!(geometry instanceof Aggregate)) break;
                            try {
                                geometry = ((Aggregate)geometry).union();
                                data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                            }
                            catch (Exception ex) {
                                log.warn("Can't create a union with geometries of the group '" + groupValue + "'.", (Throwable)ex);
                            }
                            break;
                        }
                        case 3: {
                            if (!(geometry instanceof Aggregate)) break;
                            try {
                                geometry = ((Aggregate)geometry).intersection();
                                data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                            }
                            catch (Exception ex) {
                                log.warn("Can't create a intersection with geometries of the group '" + groupValue + "'.", (Throwable)ex);
                            }
                            break;
                        }
                        case 4: {
                            try {
                                if (geometry instanceof Line) {
                                    geometry = ((Line)geometry).toPoints();
                                    data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                                    break;
                                }
                                if (geometry instanceof Polygon) {
                                    geometry = ((Polygon)geometry).toPoints();
                                    data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                                    break;
                                }
                                if (geometry instanceof Point) {
                                    geometry = ((Point)geometry).toPoints();
                                    data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                                    break;
                                }
                                if (geometry instanceof MultiLine) {
                                    geometry = ((MultiLine)geometry).toPoints();
                                    data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                                    break;
                                }
                                if (!(geometry instanceof MultiPolygon)) break;
                                geometry = ((MultiPolygon)geometry).toPoints();
                                data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                            }
                            catch (Exception ex) {
                                log.warn("Can't convert to points the geometries of the group '" + groupValue + "'.", (Throwable)ex);
                            }
                            break;
                        }
                        case 5: {
                            try {
                                if (geometry instanceof Polygon) {
                                    geometry = ((Polygon)geometry).toLines();
                                    data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                                    break;
                                }
                                if (!(geometry instanceof MultiPolygon)) break;
                                geometry = ((MultiPolygon)geometry).toLines();
                                data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                            }
                            catch (Exception ex) {
                                log.warn("Can't convert to lines the geometries of the group '" + groupValue + "'.", (Throwable)ex);
                            }
                            break;
                        }
                        case 6: {
                            try {
                                if (geometry instanceof Line) {
                                    geometry = ((Line)geometry).toPolygons();
                                    data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                                    break;
                                }
                                if (geometry instanceof MultiLine) {
                                    geometry = ((MultiLine)geometry).toPolygons();
                                    data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                                    break;
                                }
                                geometry = null;
                                data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                            }
                            catch (Exception ex) {
                                log.warn("Can't convert to polygons the geometries of the group '" + groupValue + "'.", (Throwable)ex);
                            }
                            break;
                        }
                        case 7: {
                            try {
                                if (geometry instanceof Line) {
                                    geometry = ((Line)geometry).toPolygons();
                                    geometry = geometry.buffer(0.0);
                                    data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                                    break;
                                }
                                if (geometry instanceof MultiLine) {
                                    geometry = ((MultiLine)geometry).toPolygons();
                                    geometry = geometry.buffer(0.0);
                                    data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                                    break;
                                }
                                geometry = null;
                                data.set(this.ID_FIELD_GEOMETRY, (Object)geometry);
                                break;
                            }
                            catch (Exception ex) {
                                log.warn("Can't convert to polygons the geometries of the group '" + groupValue + "'.", (Throwable)ex);
                            }
                        }
                    }
                    if (geometry != null) {
                        if (this.envelope == null) {
                            this.envelope = geometry.getEnvelope();
                        } else {
                            this.envelope.add(geometry.getEnvelope());
                        }
                    }
                }
                result.add(data);
            }
            catch (Exception ex) {
                log.warn("Problem adding data from group '" + groupValue + "'.", (Throwable)ex);
            }
        }
        return result;
    }

    public Envelope getEnvelope() {
        if (this.envelope == null) {
            // empty if block
        }
        return this.envelope;
    }
}

