/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.exportto.kml.style;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.gpe.exportto.kml.style.KmlIconStyle;
import org.gvsig.gpe.exportto.kml.style.KmlLabelStyle;
import org.gvsig.gpe.exportto.kml.style.KmlLineStyle;
import org.gvsig.gpe.exportto.kml.style.KmlPolygonStyle;
import org.gvsig.gpe.exportto.kml.style.KmlStyle;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamWriter;

public class KmlCompoundStyle
extends KmlStyle {
    protected KmlIconStyle iconStyle = null;
    protected KmlLineStyle lineStyle = null;
    protected KmlPolygonStyle polygonStyle = null;
    protected KmlLabelStyle labelStyle = null;

    @Override
    public void writeXml(IXmlStreamWriter writer) throws IOException {
        if (this.iconStyle != null) {
            this.iconStyle.writeXml(writer);
        }
        if (this.lineStyle != null) {
            this.lineStyle.writeXml(writer);
        }
        if (this.polygonStyle != null) {
            this.polygonStyle.writeXml(writer);
        }
        if (this.labelStyle != null) {
            this.labelStyle.writeXml(writer);
        }
    }

    public void addStyles(List<KmlStyle> list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.addStyle(list.get(i));
            }
        }
    }

    public List<KmlStyle> getStyles() {
        ArrayList<KmlStyle> resp = new ArrayList<KmlStyle>();
        if (this.iconStyle != null) {
            resp.add(this.iconStyle);
        }
        if (this.lineStyle != null) {
            resp.add(this.lineStyle);
        }
        if (this.polygonStyle != null) {
            resp.add(this.polygonStyle);
        }
        if (this.labelStyle != null) {
            resp.add(this.labelStyle);
        }
        return resp;
    }

    public void addStyle(KmlStyle sty) {
        if (sty instanceof KmlIconStyle) {
            this.iconStyle = (KmlIconStyle)sty;
            return;
        }
        if (sty instanceof KmlLineStyle) {
            this.lineStyle = (KmlLineStyle)sty;
            return;
        }
        if (sty instanceof KmlPolygonStyle) {
            this.polygonStyle = (KmlPolygonStyle)sty;
            return;
        }
        if (sty instanceof KmlLabelStyle) {
            this.labelStyle = (KmlLabelStyle)sty;
            return;
        }
        if (sty instanceof KmlCompoundStyle) {
            this.addStyles(((KmlCompoundStyle)sty).getStyles());
            return;
        }
    }

    public KmlIconStyle getIconStyle() {
        return this.iconStyle;
    }

    public KmlLineStyle getLineStyle() {
        return this.lineStyle;
    }

    public KmlPolygonStyle getPolygonStyle() {
        return this.polygonStyle;
    }

    public KmlLabelStyle getLabelStyle() {
        return this.labelStyle;
    }
}

