/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.sextante.gui.toolbox;

import es.unex.sextante.core.IInputFactory;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.toolbox.AlgorithmsPanel;
import es.unex.sextante.gui.toolbox.IToolboxDialog;
import es.unex.sextante.gui.toolbox.ToolboxPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.IWindowListener;
import org.gvsig.andami.ui.mdiManager.SingletonWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.ProjectDocumentListener;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.mapcontext.layers.CancelationException;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionEvent;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionListener;
import org.gvsig.fmap.mapcontext.layers.LayerPositionEvent;
import org.gvsig.i18n.Messages;

public class ToolboxWindow
extends JPanel
implements SingletonWindow,
IWindowListener,
LayerCollectionListener,
PropertyChangeListener,
ProjectDocumentListener,
IToolboxDialog,
TreeExpansionListener {
    private static final long serialVersionUID = 2205888138813789720L;
    private WindowInfo windowInfo;
    private ToolboxPanel toolboxPanel;
    private ApplicationManager manager = ApplicationLocator.getManager();

    public ToolboxWindow() {
        IInputFactory inputFactory = SextanteGUI.getInputFactory();
        if (inputFactory.getDataObjects() == null) {
            inputFactory.createDataObjects();
        }
        this.windowInfo = new WindowInfo(39);
        this.toolboxPanel = new ToolboxPanel((IToolboxDialog)this, null, new ImageIcon());
        this.windowInfo.setWidth(this.toolboxPanel.getWidth());
        this.windowInfo.setHeight(this.toolboxPanel.getHeight());
        this.windowInfo.setPersistence(true);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.toolboxPanel);
        this.addListeners();
    }

    private void removeBaseTreeText(boolean register) {
        for (int i = 0; i < this.toolboxPanel.getComponentCount(); ++i) {
            if (!(this.toolboxPanel.getComponent(i) instanceof AlgorithmsPanel)) continue;
            AlgorithmsPanel p = (AlgorithmsPanel)this.toolboxPanel.getComponent(i);
            for (int j = 0; j < p.getComponentCount(); ++j) {
                if (!(p.getComponent(j) instanceof JScrollPane)) continue;
                JScrollPane scrollPane = (JScrollPane)p.getComponent(j);
                JViewport vp = scrollPane.getViewport();
                for (int k = 0; k < vp.getComponentCount(); ++k) {
                    if (!(vp.getComponent(k) instanceof JTree)) continue;
                    JTree tree = (JTree)vp.getComponent(k);
                    if (register) {
                        tree.addTreeExpansionListener(this);
                    }
                    DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
                    node.setUserObject("");
                }
            }
        }
    }

    private void addListeners() {
        this.doForEachFLayers(new FLayersAction(){

            @Override
            public void performAction(FLayers layers) {
                layers.addLayerCollectionListener((LayerCollectionListener)ToolboxWindow.this);
            }
        });
    }

    private void removeListeners() {
        this.doForEachFLayers(new FLayersAction(){

            @Override
            public void performAction(FLayers layers) {
                layers.removeLayerCollectionListener((LayerCollectionListener)ToolboxWindow.this);
            }
        });
    }

    private void doForEachFLayers(FLayersAction action) {
        Project project = this.manager.getCurrentProject();
        project.addPropertyChangeListener((PropertyChangeListener)this);
        IWindow[] window = this.manager.getUIManager().getAllWindows();
        for (int i = 0; i < window.length; ++i) {
            if (!(window[i] instanceof IView)) continue;
            FLayers layers = ((IView)window[i]).getMapControl().getMapContext().getLayers();
            action.performAction(layers);
        }
    }

    public WindowInfo getWindowInfo() {
        return this.windowInfo;
    }

    public Object getWindowProfile() {
        return WindowInfo.TOOL_PROFILE;
    }

    public Object getWindowModel() {
        return "GeoprocessingSelector";
    }

    public ToolboxPanel getToolboxPanel() {
        return this.toolboxPanel;
    }

    public void cancel() {
        this.removeListeners();
        this.manager.getUIManager().closeWindow((IWindow)this);
    }

    public void windowActivated() {
    }

    public void windowClosed() {
        this.removeListeners();
        SextanteGUI.getInputFactory().clearDataObjects();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("addDocument") && evt.getNewValue() instanceof ViewDocument) {
            ViewDocument dvd = (ViewDocument)evt.getNewValue();
            dvd.addListener((ProjectDocumentListener)this);
        }
    }

    public void windowCreated(IWindow window) {
        if (window instanceof IView) {
            FLayers layers = ((IView)window).getMapControl().getMapContext().getLayers();
            layers.addLayerCollectionListener((LayerCollectionListener)this);
        }
    }

    public void layerAdded(LayerCollectionEvent e) {
        SextanteGUI.getInputFactory().clearDataObjects();
        SextanteGUI.getInputFactory().createDataObjects();
    }

    public void layerRemoved(LayerCollectionEvent e) {
        SextanteGUI.getInputFactory().clearDataObjects();
        SextanteGUI.getInputFactory().createDataObjects();
    }

    public void layerMoved(LayerPositionEvent e) {
    }

    public void layerAdding(LayerCollectionEvent e) throws CancelationException {
    }

    public void layerMoving(LayerPositionEvent e) throws CancelationException {
    }

    public void layerRemoving(LayerCollectionEvent e) throws CancelationException {
    }

    public void visibilityChanged(LayerCollectionEvent e) throws CancelationException {
    }

    public JDialog getDialog() {
        return null;
    }

    public void setAlgorithmsCount(int count) {
        this.getWindowInfo().setTitle(Messages.getText((String)"Geoprocessing_Toolbox") + " - " + Integer.toString(count) + " " + Messages.getText((String)"tools"));
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
    }

    private static interface FLayersAction {
        public void performAction(FLayers var1);
    }
}

