/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.complexlegend.swing.impl;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;
import org.gvsig.app.project.documents.view.legend.gui.AbstractParentPanel;
import org.gvsig.app.project.documents.view.legend.gui.ILegendPanel;
import org.gvsig.complexlegend.ComplexLegendItem;
import org.gvsig.complexlegend.VectorComplexLegend;
import org.gvsig.complexlegend.impl.DefaultComplexLegendItem;
import org.gvsig.complexlegend.swing.impl.ComplexLegendItemPanelView;
import org.gvsig.complexlegend.swing.impl.DefaultComplexLegendPanelController;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.symbology.swing.SymbologySwingLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexLegendItemPanel
extends ComplexLegendItemPanelView
implements Observable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComplexLegendItemPanel.class);
    private static final long serialVersionUID = 8565120915575756286L;
    private DefaultComplexLegendItem complexItem;
    private VectorComplexLegend complexLegend;
    private FLayer layer;
    private DefaultComboBoxModel model;
    private List<Observer> observers;
    private I18nManager i18nManager = ToolsLocator.getI18nManager();
    private ExpressionPickerController pickerFilter;

    public ComplexLegendItemPanel(FLayer layer, VectorComplexLegend vcl) {
        this.observers = new ArrayList<Observer>();
        this.layer = layer;
        this.complexLegend = vcl;
        this.initialize();
    }

    public ComplexLegendItemPanel(FLayer layer, VectorComplexLegend vcl, DefaultComplexLegendItem cli) {
        this(layer, vcl);
        this.complexItem = cli;
        this.setData((ComplexLegendItem)cli);
    }

    private void initialize() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblFiltro);
        toolsSwingManager.translate(this.legendTypeLbl);
        toolsSwingManager.translate(this.maxScaleLbl);
        toolsSwingManager.translate(this.maxScaleLbl);
        toolsSwingManager.translate(this.minScaleLbl);
        toolsSwingManager.translate((AbstractButton)this.minScaleCk);
        toolsSwingManager.translate((AbstractButton)this.maxScaleCk);
        toolsSwingManager.translate((AbstractButton)this.acceptButton);
        toolsSwingManager.translate((AbstractButton)this.cancelButton);
        toolsSwingManager.translate((JComponent)this.lblFilterByScale);
        toolsSwingManager.translate((JComponent)this.lblFilterByFeature);
        toolsSwingManager.translate((JComponent)this.lblLegend);
        if (this.layer instanceof FLyrVect) {
            FeatureStore fs = ((FLyrVect)this.layer).getFeatureStore();
            this.pickerFilter = DALSwingLocator.getDataSwingManager().createExpressionPickerController(fs, (JTextComponent)this.txtFiltro, this.btnFiltro);
        } else {
            this.pickerFilter = ExpressionEvaluatorSwingLocator.getManager().createExpressionPickerController((JTextComponent)this.txtFiltro, this.btnFiltro);
        }
        this.minScaleCk.addActionListener(arg0 -> this.getMinScaleField().setEnabled(!this.minScaleCk.isSelected()));
        this.maxScaleCk.addActionListener(arg0 -> this.getMaxScaleField().setEnabled(!this.maxScaleCk.isSelected()));
        this.acceptButton.addActionListener(arg0 -> this.acceptWindow());
        this.cancelButton.addActionListener(arg0 -> this.hideWindow());
        this.maxScaleTXT.setModel(new SpinnerNumberModel(0, 0, 1000000000, 1000000));
        this.legendTypeCB.setModel(this.getModel());
        this.legendTypeCB.setEditable(false);
        this.legendTypeCB.addActionListener(arg0 -> this.getLegendPanel());
    }

    private JCheckBox getWithoutMinScale() {
        return this.minScaleCk;
    }

    private JCheckBox getWithoutMaxScale() {
        return this.maxScaleCk;
    }

    private JButton getAcceptButton() {
        return this.acceptButton;
    }

    protected void acceptWindow() {
        if (this.validateValues()) {
            this.notifyObservers(this, true);
        }
    }

    private JButton getCancelButton() {
        return this.cancelButton;
    }

    protected void hideWindow() {
        this.notifyObservers(this, false);
    }

    private JSpinner getMaxScaleField() {
        if (this.maxScaleTXT == null) {
            // empty if block
        }
        return this.maxScaleTXT;
    }

    private JSpinner getMinScaleField() {
        return this.minScaleTXT;
    }

    private ComboBoxModel getModel() {
        if (this.model == null) {
            this.model = new DefaultComboBoxModel();
            List legendPanels = SymbologySwingLocator.getSwingManager().getLegendEditors(this.layer);
            for (ILegendPanel legPanel : legendPanels) {
                if (legPanel instanceof AbstractParentPanel || legPanel instanceof DefaultComplexLegendPanelController) continue;
                this.model.addElement(new LegendPanelCombo(legPanel));
            }
        }
        return this.model;
    }

    private JComboBox getLegendTypes() {
        return this.legendTypeCB;
    }

    public ILegendPanel getLegendPanel() {
        LegendPanelCombo legPanel = (LegendPanelCombo)this.getLegendTypes().getSelectedItem();
        return legPanel.getLegendPanel();
    }

    private void setData(ComplexLegendItem cli) {
    }

    public boolean validateValues() {
        ComplexLegendItem auxLeg = this.getLegendItem();
        if (this.getLegendPanel() == null) {
            this.createErrorDialog("panel_error_title", "panel_error");
            return false;
        }
        if (this.getMinScaleField().getValue() == null || this.getMaxScaleField().getValue() == null) {
            this.createErrorDialog("min_max_error_title", "min_max_error");
            return false;
        }
        if (auxLeg.getMinScale() > auxLeg.getMaxScale() && auxLeg.getMaxScale() >= 0.0) {
            this.createErrorDialog("min_greather_than_max_error_title", "min_greather_than_max_error");
            return false;
        }
        if (!this.complexLegend.getAllowOverlap() && this.complexLegend.isOverlapped(auxLeg)) {
            this.createErrorDialog("overlaping_error_title", "overlaping_error");
            return false;
        }
        return true;
    }

    private void createErrorDialog(String title, String text) {
        JOptionPane.showMessageDialog(null, this.i18nManager.getTranslation(text), this.i18nManager.getTranslation(title), 0);
    }

    public ComplexLegendItem getLegendItem() {
        if (this.complexItem == null) {
            this.complexItem = new DefaultComplexLegendItem();
        }
        ILegendPanel panelLegend = this.getLegendPanel();
        try {
            ILegend leg = ((FLyrVect)this.layer).getLegend();
            panelLegend.setData(this.layer, leg);
            ILegend leg2 = panelLegend.getLegend();
            if (leg2 != null) {
                this.complexItem.setLegend(leg2);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can't get legen item from GUI", (Throwable)e);
        }
        if (this.getMinScaleField().getValue() != null && !this.getWithoutMinScale().isSelected()) {
            double min = Double.parseDouble(this.getMinScaleField().getValue().toString());
            this.complexItem.setMinScale(min);
        } else {
            this.complexItem.setMinScale(-1.0);
        }
        if (this.getMaxScaleField().getValue() != null && !this.getWithoutMaxScale().isSelected()) {
            double max = Double.parseDouble(this.getMaxScaleField().getValue().toString());
            this.complexItem.setMaxScale(max);
        } else {
            this.complexItem.setMaxScale(-1.0);
        }
        this.complexItem.setFeatureFilter(this.pickerFilter.get());
        return this.complexItem;
    }

    public void addObserver(Observer o) {
        this.observers.add(o);
    }

    public void deleteObserver(Observer o) {
        this.observers.remove(o);
    }

    public void deleteObservers() {
        this.observers.clear();
    }

    public synchronized void notifyObservers(Observable observable, Object tableName) {
        for (int i = 0; i < this.observers.size(); ++i) {
            Observer o = this.observers.get(i);
            o.update((Observable)this, tableName);
        }
    }

    public class LegendPanelCombo {
        private final ILegendPanel legendPanel;

        public LegendPanelCombo(ILegendPanel panel) {
            this.legendPanel = panel;
        }

        public ILegendPanel getLegendPanel() {
            return this.legendPanel;
        }

        public String toString() {
            return this.legendPanel.getTitle();
        }
    }
}

