/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.clip;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.geoprocess.algorithm.clip.ClipOperation;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.task.SimpleTaskStatus;

public class ClipAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String RESULT_POL = "RESULT_POL";
    public static final String RESULT_LIN = "RESULT_LIN";
    public static final String RESULT_POINT = "RESULT_POINT";
    public static final String LAYER = "LAYER";
    public static final String CLIP = "CLIP";
    public static final String SELECTGEOM_INPUT = "SELECTGEOM_INPUT";
    public static final String SELECTGEOM_OVERLAY = "SELECTGEOM_OVERLAY";

    public void defineCharacteristics() {
        this.setName(this.getTranslation("Clip"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, this.getTranslation("Input_layer"), -1, true);
            this.m_Parameters.addInputVectorLayer(CLIP, this.getTranslation("Clip_layer"), 2, true);
            this.m_Parameters.addBoolean(SELECTGEOM_INPUT, this.getTranslation("Selected_geometries_input_layer_clip"), false);
            this.m_Parameters.addBoolean(SELECTGEOM_OVERLAY, this.getTranslation("Selected_geometries_overlay_layer_clip"), false);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.addOutputVectorLayer(RESULT_POL, this.getTranslation("Clip_polygon"), 2);
        this.addOutputVectorLayer(RESULT_LIN, this.getTranslation("Clip_line"), 1);
        this.addOutputVectorLayer(RESULT_POINT, this.getTranslation("Clip_point"), 0);
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT_POL, 0) || this.existsOutPutFile(RESULT_LIN, 0) || this.existsOutPutFile(RESULT_POINT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        Geometry clippingGeometry = null;
        IVectorLayer clip = this.m_Parameters.getParameterValueAsVectorLayer(CLIP);
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        boolean selectedGeomInput = this.m_Parameters.getParameter(SELECTGEOM_INPUT).getParameterValueAsBoolean();
        boolean selectedGeomOverlay = this.m_Parameters.getParameter(SELECTGEOM_OVERLAY).getParameterValueAsBoolean();
        try {
            clippingGeometry = this.calculateSurfaceUnion(clip, selectedGeomOverlay);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        FeatureStore storeLayer = null;
        if (!(layer instanceof FlyrVectIVectorLayer) || clippingGeometry == null) {
            return false;
        }
        storeLayer = ((FlyrVectIVectorLayer)layer).getFeatureStore();
        try {
            FeatureType featureType = storeLayer.getDefaultFeatureType();
            FeatureStore outFeatStorePolygon = null;
            FeatureStore outFeatStoreLine = null;
            FeatureStore outFeatStorePoint = null;
            if (this.isPolygon(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStorePolygon = this.buildOutPutStore(featureType, 6, this.getTranslation("Clip_polygon"), RESULT_POL);
            } else {
                this.buildOutPutStore(featureType, 6, this.getTranslation("Null_polygon"), RESULT_POL);
            }
            if (this.isLine(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStoreLine = this.buildOutPutStore(featureType, 5, this.getTranslation("Clip_line"), RESULT_LIN);
            } else {
                this.buildOutPutStore(featureType, 5, this.getTranslation("Null_line"), RESULT_LIN);
            }
            if (this.isPoint(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStorePoint = this.buildOutPutStore(featureType, 0, this.getTranslation("Clip_point"), RESULT_POINT);
            } else {
                this.buildOutPutStore(featureType, 0, this.getTranslation("Null_point"), RESULT_POINT);
            }
            ClipOperation operation = new ClipOperation(clippingGeometry, this);
            operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
            FeatureAttributeDescriptor geomAttr = featureType.getDefaultGeometryAttribute();
            GeometryExpressionBuilder builder = (GeometryExpressionBuilder)storeLayer.createExpressionBuilder();
            String filter = builder.andand((ExpressionBuilder.Value)builder.column(geomAttr.getName()), (ExpressionBuilder.Value)builder.geometry(clippingGeometry.getEnvelope().getGeometry(), geomAttr.getSRS())).toString();
            FeatureQuery query = storeLayer.createFeatureQuery(filter);
            operation.computesGeometryOperation(storeLayer, query, outFeatStorePolygon, outFeatStoreLine, outFeatStorePoint, this.attrNames, selectedGeomInput, false, true);
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return true;
    }
}

