/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.groupby;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.algorithm.OutputChannelSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.Output;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.geoprocess.lib.api.GeoProcessLocator;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.geoprocess.sextante.gui.algorithm.AlgorithmOutputPanel;
import org.gvsig.gui.beans.Messages;
import org.gvsig.timesupport.Instant;

public class GroupByParametersPanel
extends GeoAlgorithmParametersPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private GeoAlgorithm m_Algorithm = null;
    private JButton buttonAdd = null;
    private JButton buttonDel = null;
    private JComboBox groupingField = null;
    private JComboBox timeField = null;
    private JComboBox layersCombo = null;
    private JList fieldList = null;
    private JList operationJList = null;
    private JScrollPane jlistScroll1 = null;
    private AlgorithmOutputPanel output = null;
    private String[] opListNumeric = null;
    private String[] opListNumericLast = null;
    private String[] opListDefault = null;
    private String[] opListDefaultLast = null;
    private final String[] columnNames = new String[]{Messages.getText((String)"Field"), Messages.getText((String)"Function")};
    private JTable table = null;
    private JScrollPane jtableScroll = null;
    private JRadioButton firstGeom = null;
    private JRadioButton multiGeom = null;
    private JRadioButton spatialFusion = null;
    private OutputChannelSelectionPanel outputChannelSelectionPanel;
    private JPanel outputPanel;
    private JPanel panelOpList = null;

    public void init(GeoAlgorithm algorithm) {
        this.m_Algorithm = algorithm;
        this.opListNumeric = new String[]{"first", "sum", "average", "max", "min"};
        this.opListNumericLast = new String[]{"first", "sum", "average", "max", "min", "last"};
        this.opListDefault = new String[]{"first"};
        this.opListDefaultLast = new String[]{"first", "last"};
        this.initGUI();
    }

    private void initGUI() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 4, 4, 4);
        gbc.gridy = 0;
        this.add(this.getComboPanel(GeoProcessLocator.getGeoProcessManager().getTranslation("grouping_layer"), this.getLayers1Combo()), gbc);
        gbc.gridy = 1;
        this.add(this.getComboPanel(GeoProcessLocator.getGeoProcessManager().getTranslation("grouping_field"), this.getFields1Combo()), gbc);
        gbc.gridy = 2;
        this.add(this.getComboPanel(GeoProcessLocator.getGeoProcessManager().getTranslation("time_field"), this.getFields2Combo()), gbc);
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add(this.getTablePanel(), gbc);
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.gridy = 4;
        this.add(this.getGeometryPanel(), gbc);
        gbc.gridy = 5;
        this.add(this.getOutputChannelSelectionPanel(), gbc);
    }

    private JPanel getOutputChannelSelectionPanel() {
        if (this.outputPanel == null) {
            try {
                this.outputPanel = new JPanel();
                this.outputPanel.setLayout(new BorderLayout());
                OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
                Output out = ooSet.getOutput("RESULT");
                this.outputChannelSelectionPanel = new OutputChannelSelectionPanel(out, this.m_Algorithm.getParameters());
                this.outputPanel.add((Component)new JLabel(GeoProcessLocator.getGeoProcessManager().getTranslation("GroupBy") + " [" + GeoProcessLocator.getGeoProcessManager().getTranslation("Vectorial") + "]                       "), "West");
                this.outputPanel.add((Component)this.outputChannelSelectionPanel, "Center");
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        return this.outputPanel;
    }

    private AlgorithmOutputPanel getAlgorithmOutputPanel() {
        if (this.output == null) {
            this.output = new AlgorithmOutputPanel();
        }
        return this.output;
    }

    public JPanel getComboPanel(String text, JComboBox combo) {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 2, 0, 5);
        JLabel label = new JLabel(text);
        label.setPreferredSize(new Dimension(180, 18));
        panel.add((Component)label, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 2, 0, 0);
        panel.add((Component)combo, gbc);
        return panel;
    }

    public JComboBox getFields1Combo() {
        if (this.groupingField == null) {
            this.groupingField = new JComboBox();
            this.groupingField.setPreferredSize(new Dimension(0, 18));
            DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(this.getFieldList(false).toArray());
            this.groupingField.setModel(comboModel);
            this.groupingField.addActionListener(this);
        }
        return this.groupingField;
    }

    public JComboBox getFields2Combo() {
        if (this.timeField == null) {
            this.timeField = new JComboBox();
            this.timeField.setPreferredSize(new Dimension(0, 18));
            DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(this.getTimeFieldList().toArray());
            this.timeField.setModel(comboModel);
            this.timeField.addActionListener(this);
        }
        return this.timeField;
    }

    public JPanel getTablePanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        p.add((Component)this.getJList(), gbc);
        gbc.gridx = 2;
        p.add((Component)this.getJTable(), gbc);
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.gridx = 3;
        p.add((Component)this.getOperationJList(), gbc);
        gbc.gridx = 1;
        p.add((Component)this.getButtonsPanel(), gbc);
        return p;
    }

    public JComboBox getLayers1Combo() {
        if (this.layersCombo == null) {
            this.layersCombo = new JComboBox();
            this.layersCombo.setPreferredSize(new Dimension(0, 18));
            DefaultComboBoxModel<ObjectAndDescription> comboModel = new DefaultComboBoxModel<ObjectAndDescription>(this.getLayerList());
            this.layersCombo.setModel(comboModel);
            this.layersCombo.addActionListener(this);
        }
        return this.layersCombo;
    }

    private JPanel getButtonsPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        p.add((Component)this.getButtonAdd(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        p.add((Component)this.getButtonDel(), gbc);
        return p;
    }

    public JButton getButtonAdd() {
        if (this.buttonAdd == null) {
            this.buttonAdd = new JButton(">>");
            this.buttonAdd.setPreferredSize(new Dimension(32, 32));
            this.buttonAdd.addActionListener(this);
        }
        return this.buttonAdd;
    }

    public JButton getButtonDel() {
        if (this.buttonDel == null) {
            this.buttonDel = new JButton("<<");
            this.buttonDel.setPreferredSize(new Dimension(32, 32));
            this.buttonDel.addActionListener(this);
        }
        return this.buttonDel;
    }

    public JScrollPane getJTable() {
        if (this.table == null) {
            DefaultTableModel model = new DefaultTableModel();
            model.setColumnIdentifiers(this.columnNames);
            this.table = new JTable(model);
            this.table.addMouseListener(this);
            this.table.setRowHeight(24);
            this.jtableScroll = new JScrollPane(this.table);
        }
        return this.jtableScroll;
    }

    public JScrollPane getJList() {
        if (this.fieldList == null) {
            this.fieldList = new JList();
            this.fieldList.setModel(new DefaultListModel());
            this.jlistScroll1 = new JScrollPane(this.fieldList);
            this.fieldList.setSelectionMode(2);
            this.fieldList.addMouseListener(this);
            List<String> list = this.getFieldList(true);
            for (int i = 0; i < list.size(); ++i) {
                ((DefaultListModel)this.fieldList.getModel()).addElement(list.get(i));
            }
        }
        return this.jlistScroll1;
    }

    public JPanel getOperationJList() {
        if (this.operationJList == null) {
            this.operationJList = new JList();
            this.operationJList.setModel(new DefaultListModel());
            this.operationJList.setSelectionMode(0);
            this.operationJList.addMouseListener(this);
            this.panelOpList = new JPanel(new GridBagLayout());
            this.panelOpList.setPreferredSize(new Dimension(70, 0));
            this.panelOpList.setSize(new Dimension(70, 0));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 3;
            gbc.weighty = 1.0;
            this.panelOpList.add((Component)this.operationJList, gbc);
            this.panelOpList.setBorder(BorderFactory.createLineBorder(Color.black));
        }
        return this.panelOpList;
    }

    public JPanel getGeometryPanel() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.getButtonFirstGeom());
        group.add(this.getButtonMultiGeom());
        group.add(this.getButtonSpatialFusion());
        JPanel panel = new JPanel();
        String text = GeoProcessLocator.getGeoProcessManager().getTranslation("geom");
        panel.setBorder(BorderFactory.createTitledBorder(text));
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 2, 4, 0);
        panel.add((Component)this.getButtonFirstGeom(), gbc);
        gbc.gridy = 1;
        panel.add((Component)this.getButtonMultiGeom(), gbc);
        gbc.gridy = 2;
        panel.add((Component)this.getButtonSpatialFusion(), gbc);
        return panel;
    }

    private JRadioButton getButtonFirstGeom() {
        if (this.firstGeom == null) {
            String text = GeoProcessLocator.getGeoProcessManager().getTranslation("first_geom");
            this.firstGeom = new JRadioButton(text);
        }
        return this.firstGeom;
    }

    private JRadioButton getButtonMultiGeom() {
        if (this.multiGeom == null) {
            String text = GeoProcessLocator.getGeoProcessManager().getTranslation("multi_geom");
            this.multiGeom = new JRadioButton(text);
        }
        return this.multiGeom;
    }

    private JRadioButton getButtonSpatialFusion() {
        if (this.spatialFusion == null) {
            String text = GeoProcessLocator.getGeoProcessManager().getTranslation("spatial_fusion");
            this.spatialFusion = new JRadioButton(text);
            this.checkSpatialFusionOptionActivation();
        }
        return this.spatialFusion;
    }

    private void reloadFields() {
        int i;
        for (int i2 = ((DefaultTableModel)this.table.getModel()).getRowCount() - 1; i2 >= 0; --i2) {
            ((DefaultTableModel)this.table.getModel()).removeRow(i2);
        }
        List<String> list = this.getFieldList(false);
        this.groupingField.removeAllItems();
        for (i = 0; i < list.size(); ++i) {
            this.groupingField.addItem(list.get(i));
        }
        list = this.getFieldList(true);
        while (this.table.getRowCount() > 0) {
            ((DefaultTableModel)this.table.getModel()).removeRow(0);
        }
        for (i = 0; i < list.size(); ++i) {
            ((DefaultListModel)this.fieldList.getModel()).addElement(list.get(i));
        }
        DefaultTableModel model = new DefaultTableModel();
        model.setColumnIdentifiers(this.columnNames);
        this.table = new JTable(model);
        this.table.setRowHeight(24);
        this.getFields2Combo().removeAllItems();
        List<String> timeFieldList = this.getTimeFieldList();
        for (int i3 = 0; i3 < timeFieldList.size(); ++i3) {
            this.getFields2Combo().addItem(timeFieldList.get(i3));
        }
    }

    private IVectorLayer getSelectedVectorLayer() {
        if (this.layersCombo.getSelectedItem() != null) {
            return (IVectorLayer)((ObjectAndDescription)this.layersCombo.getSelectedItem()).getObject();
        }
        return null;
    }

    private int getSelectedLayerType() {
        return this.getSelectedVectorLayer().getShapeType();
    }

    private void checkSpatialFusionOptionActivation() {
        if (this.getSelectedLayerType() == 2) {
            this.spatialFusion.setEnabled(true);
        } else {
            this.spatialFusion.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getLayers1Combo()) {
            this.checkSpatialFusionOptionActivation();
            this.reloadFields();
        }
        if (e.getSource() == this.getFields1Combo()) {
            List<String> list = this.getFieldList(true);
            DefaultListModel m = (DefaultListModel)this.fieldList.getModel();
            while (m.size() > 0) {
                m.remove(0);
            }
            for (int i = 0; i < list.size(); ++i) {
                ((DefaultListModel)this.fieldList.getModel()).addElement(list.get(i));
            }
        }
        if (e.getSource() == this.getButtonAdd()) {
            this.addRowToTable();
        }
        if (e.getSource() == this.getButtonDel()) {
            this.removeRowTable();
        }
    }

    public void assignParameters() {
        try {
            ParametersSet params = this.m_Algorithm.getParameters();
            params.getParameter("LAYER_NAME").setParameterValue((Object)"GroupBy_Layer");
            params.getParameter("LAYER").setParameterValue((Object)this.getSelectedVectorLayer());
            params.getParameter("FIELD").setParameterValue((Object)((String)this.getFields1Combo().getSelectedItem()));
            String dateField = (String)this.getFields2Combo().getSelectedItem();
            params.getParameter("FIELD_DATE").setParameterValue((Object)dateField);
            params.getParameter("FIELD_LIST").setParameterValue((Object)this.getFieldStringList());
            params.getParameter("FUNCTION_LIST").setParameterValue((Object)this.getFunctionStringList());
            int geom = this.getButtonFirstGeom().isSelected() ? 0 : (this.getButtonMultiGeom().isSelected() ? 1 : (this.getButtonSpatialFusion().isSelected() ? 2 : -1));
            params.getParameter("GEOM_OPTION").setParameterValue((Object)geom);
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            Output out = ooSet.getOutput("RESULT");
            out.setOutputChannel(this.outputChannelSelectionPanel.getOutputChannel());
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private String getFunctionStringList() {
        if (this.table != null) {
            String value = "";
            for (int i = 0; i < ((DefaultTableModel)this.table.getModel()).getRowCount(); ++i) {
                Object obj = ((DefaultTableModel)this.table.getModel()).getValueAt(i, 1);
                value = i == 0 ? obj + "" : value + ";" + obj;
            }
            return value;
        }
        return null;
    }

    private String getFieldStringList() {
        if (this.table != null) {
            String value = "";
            for (int i = 0; i < ((DefaultTableModel)this.table.getModel()).getRowCount(); ++i) {
                Object obj = ((DefaultTableModel)this.table.getModel()).getValueAt(i, 0);
                if (!(obj instanceof String)) continue;
                List<String> fList = this.getFieldList(true);
                for (int j = 0; j < fList.size(); ++j) {
                    if (fList.get(j).compareTo((String)obj) != 0) continue;
                    value = value.compareTo("") == 0 ? obj + "" : value + ";" + obj;
                }
            }
            return value;
        }
        return null;
    }

    public void setOutputValue(String arg0, String arg1) {
    }

    public void setParameterValue(String arg0, String arg1) {
    }

    private ObjectAndDescription[] getLayerList() {
        IVectorLayer[] layers = SextanteGUI.getInputFactory().getVectorLayers(-1);
        ObjectAndDescription[] oad = new ObjectAndDescription[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            oad[i] = new ObjectAndDescription(layers[i].getName(), (Object)layers[i]);
        }
        return oad;
    }

    public List<String> getFieldList(boolean withGroupingField) {
        IVectorLayer layer = this.getSelectedVectorLayer();
        ArrayList<String> data = new ArrayList<String>();
        int indexGeom = -1;
        FeatureStore fs = ((FlyrVectIVectorLayer)layer).getFeatureStore();
        FeatureType ftype = null;
        try {
            ftype = fs.getDefaultFeatureType();
            if (ftype != null) {
                indexGeom = ftype.getDefaultGeometryAttributeIndex();
            }
        }
        catch (DataException e) {
            return data;
        }
        String groupingField = null;
        if (withGroupingField) {
            groupingField = (String)this.getFields1Combo().getSelectedItem();
        }
        for (int i = 0; i < layer.getFieldCount(); ++i) {
            if (i == indexGeom || ftype.getAttributeDescriptor(i).getDataType().getType() == 10 || groupingField != null && groupingField.equals(layer.getFieldName(i))) continue;
            data.add(layer.getFieldName(i));
        }
        return data;
    }

    public List<String> getTimeFieldList() {
        IVectorLayer layer = this.getSelectedVectorLayer();
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < layer.getFieldCount(); ++i) {
            Class type = layer.getFieldType(i);
            if (!Instant.class.isAssignableFrom(type)) continue;
            data.add(layer.getFieldName(i));
        }
        return data;
    }

    private void addRowToTable() {
        Object[] values = this.fieldList.getSelectedValues();
        for (int i = 0; i < values.length; ++i) {
            Object[] obj = new Object[]{values[i], this.opListNumeric[0]};
            ((DefaultTableModel)this.table.getModel()).addRow(obj);
        }
        this.loadOperationInJList(this.getFieldSelectedInTable());
    }

    private void removeRowTable() {
        int row = this.table.getSelectedRow();
        if (row >= 0 && row < this.table.getRowCount()) {
            ((DefaultTableModel)this.table.getModel()).removeRow(row);
            int rowSelected = ((DefaultTableModel)this.table.getModel()).getRowCount() - 1;
            if (rowSelected >= 0) {
                this.table.setRowSelectionInterval(rowSelected, rowSelected);
            }
            this.loadOperationInJList(this.getFieldSelectedInTable());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.fieldList && e.getClickCount() == 2) {
            this.addRowToTable();
        }
        if (e.getSource() == this.table) {
            this.loadOperationInJList(this.getFieldSelectedInTable());
        }
        if (e.getSource() == this.operationJList) {
            this.changeFunctionInTable();
        }
    }

    private void changeFunctionInTable() {
        int rowSelected = this.table.getSelectedRow();
        if (rowSelected < 0) {
            return;
        }
        String value = (String)this.operationJList.getSelectedValue();
        ((DefaultTableModel)this.table.getModel()).setValueAt(value, rowSelected, 1);
    }

    private String getFieldSelectedInTable() {
        if (this.table.getRowCount() == 0) {
            return null;
        }
        int rowSelected = this.table.getSelectedRow();
        if (rowSelected < 0) {
            rowSelected = ((DefaultTableModel)this.table.getModel()).getRowCount() - 1;
            this.table.setRowSelectionInterval(rowSelected, rowSelected);
        }
        return (String)((DefaultTableModel)this.table.getModel()).getValueAt(rowSelected, 0);
    }

    private void loadOperationInJList(String field) {
        this.operationJList.setModel(new DefaultListModel());
        DefaultListModel model = (DefaultListModel)this.operationJList.getModel();
        if (field == null) {
            return;
        }
        if (this.existsTimeField()) {
            if (this.isFieldNumeric(field)) {
                for (int i = 0; i < this.opListNumericLast.length; ++i) {
                    model.addElement(this.opListNumericLast[i]);
                }
            } else {
                for (int i = 0; i < this.opListDefaultLast.length; ++i) {
                    model.addElement(this.opListDefaultLast[i]);
                }
            }
        } else if (this.isFieldNumeric(field)) {
            for (int i = 0; i < this.opListNumeric.length; ++i) {
                model.addElement(this.opListNumeric[i]);
            }
        } else {
            for (int i = 0; i < this.opListDefault.length; ++i) {
                model.addElement(this.opListDefault[i]);
            }
        }
    }

    public boolean isFieldNumeric(String field) {
        IVectorLayer layer = this.getSelectedVectorLayer();
        FeatureStore fs = ((FlyrVectIVectorLayer)layer).getFeatureStore();
        try {
            FeatureType ftype = fs.getDefaultFeatureType();
            FeatureAttributeDescriptor desc = ftype.getAttributeDescriptor(field);
            if (desc != null && desc.getDataType().isNumeric()) {
                return true;
            }
        }
        catch (DataException e) {
            return false;
        }
        return false;
    }

    private boolean existsTimeField() {
        IVectorLayer layer = this.getSelectedVectorLayer();
        if (layer != null) {
            boolean existsTimeField = false;
            for (int i = 0; i < layer.getFieldCount(); ++i) {
                Class type = layer.getFieldType(i);
                if (!Instant.class.isAssignableFrom(type)) continue;
                existsTimeField = true;
            }
            if (layer.getShapeType() != 2) {
                this.getButtonSpatialFusion().setEnabled(false);
            }
            return existsTimeField;
        }
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

