/*
 * Decompiled with CFR 0.152.
 */
package com.github.miachm.SODS.spreadsheet;

class Cell {
    private Object value;
    private String formula;
    private boolean bold;

    Cell() {
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    void clear() {
        this.value = null;
    }

    String getFormula() {
        return this.formula;
    }

    Object getValue() {
        return this.value;
    }

    void setValue(Object value) {
        this.value = value;
    }

    public void setFormula(String formula) {
        if (formula != null && formula.startsWith("of:")) {
            formula = this.convertFormula(formula);
        }
        this.formula = formula;
    }

    private String convertFormula(String formula) {
        formula = formula.trim();
        formula = formula.substring("of:".length());
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < formula.length(); ++i) {
            char character = formula.charAt(i);
            if (character == '[' || character == ']' || character == '.') continue;
            result.append(character);
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell cell = (Cell)o;
        if (this.value != null ? !this.value.equals(cell.value) : cell.value != null) {
            return false;
        }
        return this.formula != null ? this.formula.equals(cell.formula) : cell.formula == null;
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.formula != null ? this.formula.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Cell{value=" + this.value + ", formula='" + this.formula + '\'' + '}';
    }
}

