/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.resource.db;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.resource.ResourceParameters;
import org.gvsig.fmap.dal.resource.db.AbstractDBResourceParameters;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.exception.ResourceException;
import org.gvsig.fmap.dal.resource.spi.AbstractNonBlockingResource;

public abstract class AbstractDBResourceNoBlocker
extends AbstractNonBlockingResource {
    protected AbstractDBResourceNoBlocker(AbstractDBResourceParameters parameters) throws InitializeException {
        super((ResourceParameters)parameters);
    }

    public Object get() throws AccessResourceException {
        if (!this.isConnected()) {
            try {
                this.connect();
            }
            catch (DataException e) {
                throw new CanConnectException(((Object)((Object)this)).toString(), e);
            }
        }
        try {
            return this.getTheConnection();
        }
        catch (DataException e) {
            throw new CanGetConnectException(((Object)((Object)this)).toString(), e);
        }
    }

    public Object getConnection() throws AccessResourceException {
        return this.get();
    }

    public abstract boolean isConnected();

    public final void connect() throws DataException {
        if (this.isConnected()) {
            return;
        }
        this.prepare();
        this.connectToDB();
    }

    protected abstract void connectToDB() throws DataException;

    protected abstract Object getTheConnection() throws DataException;

    public boolean isThis(ResourceParameters parameters) throws ResourceException {
        if (!(parameters instanceof AbstractDBResourceParameters)) {
            return false;
        }
        AbstractDBResourceParameters params = (AbstractDBResourceParameters)parameters.getCopy();
        this.prepare((ResourceParameters)params);
        AbstractDBResourceParameters myParams = (AbstractDBResourceParameters)this.getParameters();
        if (!this.equals((Comparable)((Object)myParams.getHost()), (Comparable)((Object)params.getHost()))) {
            return false;
        }
        if (!this.equals(myParams.getPort(), params.getPort())) {
            return false;
        }
        if (!this.equals((Comparable)((Object)myParams.getUser()), (Comparable)((Object)params.getUser()))) {
            return false;
        }
        return this.equals((Comparable)((Object)myParams.getPassword()), (Comparable)((Object)params.getPassword()));
    }

    protected boolean equals(Comparable v1, Comparable v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 != null && v2 != null) {
            return v1.compareTo(v2) == 0;
        }
        return false;
    }

    private static class CanGetConnectException
    extends AccessResourceException {
        public CanGetConnectException(String datasource, DataException cause) {
            super("Can't get the connection of the resource (%(resource))", (Throwable)cause, "_CanGetConnectionException", 0L);
            this.setValue("resource", datasource);
        }
    }

    private static class CanConnectException
    extends AccessResourceException {
        public CanConnectException(String resource, DataException cause) {
            super("Can't get a connection to the resource (%(resource))", (Throwable)cause, "_CanConnectException", 0L);
            this.setValue("resource", resource);
        }
    }
}

