/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.splitlines;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import es.unex.sextante.core.Sextante;
import java.util.ArrayList;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;

public class SplitLinesOperation
extends GeometryOperation {
    private double distance = 0.0;
    private boolean multigeometry = false;

    public SplitLinesOperation(double distance, FeatureStore inputStore, AbstractSextanteGeoProcess p, boolean multigeometry) {
        super(p);
        this.distance = distance;
        this.multigeometry = multigeometry;
    }

    public EditableFeature invoke(org.gvsig.fmap.geom.Geometry g, Feature feature) {
        Geometry originalGeometry = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g);
        if (originalGeometry == null) {
            return null;
        }
        if (this.multigeometry) {
            this.splitGeometryAsMultigeometry(originalGeometry, feature);
        } else {
            this.splitGeometryAsMultipleFeatures(originalGeometry, feature);
        }
        return this.lastEditFeature;
    }

    private void splitGeometryAsMultipleFeatures(Geometry originalGeometry, Feature feature) {
        LengthIndexedLine lil = new LengthIndexedLine(originalGeometry);
        double end = lil.getEndIndex();
        int i = 0;
        while (this.distance * (double)i < end) {
            Geometry newGeom = lil.extractLine(this.distance * (double)i, this.distance * (double)(i + 1));
            ++i;
            try {
                this.lastEditFeature = this.persister.addFeature(feature, newGeom);
            }
            catch (CreateGeometryException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            catch (DataException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    private void splitGeometryAsMultigeometry(Geometry originalGeometry, Feature feature) {
        LengthIndexedLine lil = new LengthIndexedLine(originalGeometry);
        double end = lil.getEndIndex();
        ArrayList<Geometry> geomList = new ArrayList<Geometry>();
        int i = 0;
        while (this.distance * (double)i < end) {
            Geometry newGeom = lil.extractLine(this.distance * (double)i, this.distance * (double)(i + 1));
            ++i;
            geomList.add(newGeom);
        }
        try {
            this.lastEditFeature = this.persister.addFeature(feature, geomList);
        }
        catch (CreateGeometryException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void invoke(org.gvsig.fmap.geom.Geometry g, EditableFeature feature) {
        this.invoke(g, (Feature)feature);
    }
}

