/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.io;

import java.lang.reflect.Field;
import org.gvsig.raster.wms.io.WMSLayerNode;
import org.gvsig.remoteclient.wms.WMSStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class RemoteWMSStyle
implements Persistent {
    public String name;
    public String title;
    public String styleAbstract;
    public String format;
    public String type;
    public String href;
    public WMSLayerNode parent;
    public int legendHeight;
    public int legendWidth;

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.name = state.getString("name");
        this.title = state.getString("title");
        this.styleAbstract = state.getString("styleAbstract");
        this.format = state.getString("format");
        this.type = state.getString("type");
        this.href = state.getString("href");
        this.parent = (WMSLayerNode)state.get("parent");
        this.legendHeight = state.getInt("legendHeight");
        this.legendWidth = state.getInt("legendWidth");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("parent", (Persistent)this.parent);
        state.set("name", this.name);
        state.set("title", this.title);
        state.set("styleAbstract", this.styleAbstract);
        state.set("format", this.format);
        state.set("type", this.type);
        state.set("href", this.href);
        state.set("legendHeight", this.legendHeight);
        state.set("legendWidth", this.legendWidth);
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("RemoteWMSStyle_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(RemoteWMSStyle.class, "RemoteWMSStyle_Persistent", "RemoteWMSStyle Persistence", null, null);
        }
        definition.addDynFieldInt("legendHeight").setMandatory(false);
        definition.addDynFieldInt("legendWidth").setMandatory(false);
        definition.addDynFieldObject("parent").setClassOfValue(WMSLayerNode.class).setMandatory(false);
        definition.addDynFieldString("name").setMandatory(false);
        definition.addDynFieldString("title").setMandatory(false);
        definition.addDynFieldString("styleAbstract").setMandatory(false);
        definition.addDynFieldString("format").setMandatory(false);
        definition.addDynFieldString("type").setMandatory(false);
        definition.addDynFieldString("href").setMandatory(false);
    }

    public RemoteWMSStyle(WMSStyle style, WMSLayerNode parent) {
        this.name = style.getName();
        this.title = style.getTitle();
        this.styleAbstract = style.getAbstract();
        this.legendWidth = style.getLegendURLWidth();
        this.legendHeight = style.getLegendURLHeight();
        this.format = style.getLegendURLFormat();
        this.href = style.getLegendURLOnlineResourceHRef();
        this.type = style.getLegendURLOnlineResourceType();
        this.parent = parent;
    }

    public RemoteWMSStyle() {
    }

    public String toString() {
        return this.name;
    }

    public Object clone() throws CloneNotSupportedException {
        RemoteWMSStyle clone = new RemoteWMSStyle();
        Field[] fields = RemoteWMSStyle.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                Class<?> clazz = this.getClass();
                String fieldName = fields[i].getName();
                if (fields[i].getType().equals(Integer.class)) {
                    clazz.getField(fieldName).setInt(clone, clazz.getField(fieldName).getInt(this));
                    continue;
                }
                if (fields[i].getType().equals(Double.class)) {
                    clazz.getField(fieldName).setDouble(clone, clazz.getField(fieldName).getDouble(this));
                    continue;
                }
                clazz.getField(fieldName).set(clone, clazz.getField(fieldName).get(this));
                continue;
            }
            catch (Exception e) {
                throw new CloneNotSupportedException("Reflect error when cloning '" + fields[i].getName() + "' field " + "(FMapWMSStyle)");
            }
        }
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getStyleAbstract() {
        return this.styleAbstract;
    }

    public String getFormat() {
        return this.format;
    }

    public String getType() {
        return this.type;
    }

    public String getHref() {
        return this.href;
    }

    public WMSLayerNode getParent() {
        return this.parent;
    }

    public int getLegendHeight() {
        return this.legendHeight;
    }

    public int getLegendWidth() {
        return this.legendWidth;
    }

    public void setParent(WMSLayerNode node) {
        this.parent = node;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStyleAbstract(String sa) {
        this.styleAbstract = sa;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setLegendHeight(int lHeight) {
        this.legendHeight = lHeight;
    }

    public void setLegendWidth(int lWidth) {
        this.legendWidth = lWidth;
    }
}

