/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.api;

import java.awt.image.BufferedImage;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandInfo;
import org.gvsig.raster.lib.buffer.api.BufferDimensions;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.statistics.StatisticsCapable;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.task.SimpleTaskStatus;

public interface Buffer
extends StatisticsCapable,
Iterable<Band>,
Observer,
Disposable {
    public static final int INTERPOLATION_Undefined = 0;
    public static final int INTERPOLATION_NearestNeighbour = 1;
    public static final int INTERPOLATION_Bilinear = 2;
    public static final int INTERPOLATION_InverseDistance = 3;
    public static final int INTERPOLATION_BicubicSpline = 4;
    public static final int INTERPOLATION_BSpline = 5;

    public int getBandCount();

    public Band[] getBands();

    public BandInfo[] getBandsInfo();

    public int getColumns();

    public int getRows();

    public Envelope getEnvelope() throws LocatorException, CreateEnvelopeException;

    public IProjection getProjection();

    public boolean isInside(int var1, int var2);

    public boolean isInside(Point var1);

    public void addBand(Band var1);

    public void setBand(int var1, Band var2) throws BandException;

    public void removeBand(int var1);

    public Band getBand(int var1);

    public Band.BandByte getBandByte(int var1);

    public Band.BandShort getBandShort(int var1);

    public Band.BandInt getBandInt(int var1);

    public Band.BandFloat getBandFloat(int var1);

    public Band.BandDouble getBandDouble(int var1);

    public void switchBands(int[] var1);

    public void switchBands(int var1, int var2);

    public Buffer createInterpolated(int var1, int var2, int var3, SimpleTaskStatus var4) throws LocatorException, BufferException;

    public Buffer convert(ICoordTrans var1, SimpleTaskStatus var2) throws BufferException;

    public int[] getBandTypes();

    public boolean areAllBandsOfTheSameType();

    public NoData[] getBandNoData();

    public Buffer clip(Envelope var1) throws BufferException;

    public double getPixelSizeX();

    public double getPixelSizeY();

    public BufferedImage getBufferedImage();

    public BufferDimensions getDimensions();
}

