/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.api;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandInfo;
import org.gvsig.raster.lib.buffer.api.BandPageManager;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferDimensions;
import org.gvsig.raster.lib.buffer.api.Kernel;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.PageManager;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.tools.dataTypes.CoercionException;

public interface BufferManager {
    public static final int TYPE_UNDEFINED = 32;
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_USHORT = 1;
    public static final int TYPE_SHORT = 2;
    public static final int TYPE_INT = 3;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_DOUBLE = 5;

    public NoData createNoData(Number var1, Number var2);

    public BandInfo createBandInfo(int var1, String var2, String var3, int var4, List<Map.Entry<Object, Object>> var5);

    public Band createBand(int var1, int var2, int var3, NoData var4, PageManager var5) throws BandException;

    public Buffer createBuffer(int var1, int var2, int[] var3, IProjection var4) throws BufferException;

    public Buffer createBuffer(int var1, int var2, int[] var3, NoData[] var4, IProjection var5) throws BufferException;

    public Buffer createBuffer(int var1, int var2, int[] var3, NoData[] var4, IProjection var5, Envelope var6) throws BufferException;

    public Buffer createBuffer(int var1, int var2, int[] var3, NoData[] var4, IProjection var5, Envelope var6, List<PageManager> var7) throws BufferException;

    public Buffer createBuffer(Buffer var1, boolean var2) throws BufferException;

    public Buffer createConvertedTypeBuffer(Buffer var1, int var2) throws BufferException;

    public Buffer createClippedBuffer(Buffer var1, Envelope var2) throws BufferException;

    public PageManager createSimpleBandPageManager(File var1, int var2, int var3, int var4) throws IOException;

    public List<PageManager> createSimpleBandPageManagerList(File[] var1, int var2, int var3, int[] var4) throws IOException;

    public int getDataTypeSize(int var1);

    public Band createClippedBand(Buffer var1, Band var2) throws BandException;

    public Band createConvertedTypeBand(Buffer var1, Band var2, int var3) throws BandException;

    public Buffer createRGBABuffer(BufferedImage var1, IProjection var2, Envelope var3) throws BufferException;

    public Buffer createRGBBuffer(BufferedImage var1, IProjection var2, Envelope var3) throws BufferException;

    public String getTypeName(int var1);

    public String getBufferTypeName(int var1);

    public Object coerce(int var1, Object var2) throws CoercionException;

    public List<Buffer> createOneBufferPerBand(Buffer var1, boolean var2) throws BufferException;

    public BufferDimensions createBufferDimensions(int var1, int var2, Envelope var3);

    public void setLastFolderUsedToSaveRaster(File var1);

    public File getLastFolderUsedToSaveRaster();

    public Kernel createKernel(double[][] var1);

    public Kernel createKernel(double[][] var1, double var2);

    public List<PageManager> createAwtRasterBandPageManagerList(Raster var1) throws IOException;

    public BandPageManager createAwtRasterBandPageManager(Raster var1, int var2);

    public int getBufferTypeFromAwtRaster(Raster var1);

    public Buffer createBufferFromAwtRaster(Raster var1, IProjection var2, Envelope var3) throws IOException, BufferException;
}

